package org.postgresforest.tool;

import java.sql.Timestamp;

public class Logger
{
	public static final int DEBUG  = 5;
	public static final int NOTICE = 3;
	public static final int ERROR  = 1;

	static int logLevel = Logger.NOTICE;

	public static void setLogLevel(int level)
	{
		logLevel = level;
	}
	
	private static void println(String prefix, String msg)
	{
		Timestamp ts = new Timestamp(System.currentTimeMillis());
		System.out.println(ts.toString() + " " + prefix + ": " + msg);
	}

	public static void debug(String msg)
	{
		if ( logLevel >= DEBUG )
			println("DEBUG", msg);
	}

	public static void error(String msg)
	{
		if ( logLevel >= ERROR )
			println("ERROR", msg);
	}

	public static void notice(String msg)
	{
		if ( logLevel >= NOTICE )
			println("NOTICE", msg);
	}
}
