/*-------------------------------------------------------------------------
*
* Copyright (c) 2004-2005, PostgreSQL Global Development Group
*
* IDENTIFICATION
*   $PostgreSQL: pgjdbc/org/postgresforest/test/jdbc2/DriverTest.java,v 1.12 2005/01/11 08:25:48 jurka Exp $
*
*-------------------------------------------------------------------------
*/
package org.postgresforest.test.jdbc2;

import org.postgresforest.test.TestUtil;
import junit.framework.TestCase;
import java.sql.*;

/*
 * Tests the dynamically created class org.postgresforest.Driver
 *
 */
public class DriverTest extends TestCase
{

    public DriverTest(String name)
    {
        super(name);
    }

    /*
     * This tests the acceptsURL() method with a couple of well and poorly
     * formed jdbc urls.
     */
    public void testAcceptsURL() throws SQLException
    {
        // Load the driver (note clients should never do it this way!)
        org.postgresforest.Driver drv = new org.postgresforest.Driver();
        assertNotNull(drv);

        // These are always correct
        assertTrue(drv.acceptsURL("jdbc:postgresforest:test"));
        assertTrue(drv.acceptsURL("jdbc:postgresforest://localhost/test"));
        assertTrue(drv.acceptsURL("jdbc:postgresforest://localhost:5432/test"));
        assertTrue(drv.acceptsURL("jdbc:postgresforest://127.0.0.1/anydbname"));
        assertTrue(drv.acceptsURL("jdbc:postgresforest://127.0.0.1:5433/hidden"));
        assertTrue(drv.acceptsURL("jdbc:postgresforest://[::1]:5740/db"));

        // Badly formatted url's
        assertTrue(!drv.acceptsURL("jdbc:postgres:test"));
        assertTrue(!drv.acceptsURL("postgresforest:test"));
        assertTrue(!drv.acceptsURL("db"));

    }

    /*
     * Tests parseURL (internal)
     */
    /*
     * Tests the connect method by connecting to the test database
     */
    public void testConnect() throws Exception
    {
        Class.forName("org.postgresforest.Driver");

        // Test with the url, username & password
        Connection con = DriverManager.getConnection(TestUtil.getURL(), TestUtil.getUser(), TestUtil.getPassword());
        assertNotNull(con);
        con.close();

        // Test with the username in the url
        con = DriverManager.getConnection(TestUtil.getURL() + "&user=" + TestUtil.getUser() + "&password=" + TestUtil.getPassword());
        assertNotNull(con);
        con.close();
    }
}
