/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.vm;

/**
 * SELECT の出力列情報
 * @since
 * @since 2.0
 */
public class SelectColumnInfo extends ColumnInfo {

	public static final int FUNCTION_NONE = -2;
	public static final int FUNCTION_OTHERS = -1;
	public static final int FUNCTION_MAX = 0;
	public static final int FUNCTION_MIN = 1;
	public static final int FUNCTION_COUNT = 2;
	public static final int FUNCTION_SUM = 3;

	protected int m_functionType = FUNCTION_NONE;
	protected String m_alias = null;

	/**
	 * @param name
	 */
	public SelectColumnInfo(String name) {
		super(name);
	}

	/**
	 * @param number
	 */
	public SelectColumnInfo(int number) {
		super(number);
	}

	/**
	 * @return
	 */
	public int getFunctionType() {
		return m_functionType;
	}

	/**
	 * @param i
	 */
	public void setFunctionType(int i) {
		m_functionType = i;
	}

	/**
	 * @return
	 */
	public String getAlias() {
		return m_alias;
	}

	/**
	 * @param string
	 */
	public void setAlias(String string) {
		m_alias = string;
	}

}
