<?php

/*
 * postLdapAdmin
 *
 * Copyright (C) 2006,2007 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/***********************************************************
 * ᡼󥰥ꥹȽ
 *
 * $RCSfile: admin_ml_mod.php,v $
 * $Revision: 1.18 $
 * $Date: 2007/08/24 06:53:55 $
 **********************************************************/

include_once("../../lib/libcommon");
include_once("../../lib/libpage");
include_once("../../lib/libldap");
include_once("../../lib/libsess");

/********************************************************
ƥڡ
*********************************************************/
/* ֤μ */
define("MY_TAB", TAB_ML);

/* ѥ󤯤ꥹ */
$topic[0]["name"] = TOPIC_SYSTEM_ML;
$topic[0]["url"] = "admin_ml_list.php";
$topic[1]["name"] = TOPIC_SYSTEM_ML_M;
$topic[1]["url"] = "";

/***********************************************************
 * 饹: ˥塼
 **********************************************************/
Class my_page extends page {

    /***********************************************************
     * ܥǥɽʥС饤ɡ
     **********************************************************/
    function display_body() {

        global $result;
        global $sesskey;
        global $dispml;

        $mladdr = htmlspecialchars($_POST["mladdr"]);
        $newaddr = "";
        if (isset($_POST["newaddr"])) {
            $newaddr = htmlspecialchars($_POST["newaddr"]);
        }

        print <<<EOD

</script>
<form enctype="multipart/form-data" method="post" action="admin_ml_mod.php">
<table class="table">
  <tr>
    <td class="key1">᡼󥰥ꥹȥɥ쥹</td>
    <td class="value">$dispml</td>
    <input type="hidden" name="mladdr" value="$mladdr">
  </tr>
  <tr>
</table>
<table>
    <td>
        <select size="10" name="addr[]" multiple>

EOD;

        if (isset($result[0]["mailForwardingAddr"])) {
            sort($result[0]["mailForwardingAddr"]);
            reset($result[0]["mailForwardingAddr"]);
            $num = 0;
            foreach($result[0]["mailForwardingAddr"] as $i) {
                $addr = $i;
                $addr = htmlspecialchars($addr);
                print("          <option value=\"$addr\">$addr" . "\n");
            }
        }

        print <<<EOD
        </select>
    </td>
    <td valign="bottom">
        <input type="submit" name="mydel" value="򤷤᡼륢ɥ쥹" onClick="return msgConfirm('򤷤᡼륢ɥ쥹ޤ\\nǤ')">
    </td>
  </tr>
</table>
<br>
<input type="text" size="40" maxlength="256" name="newaddr" value="$newaddr">
<input type="submit" name="myadd" value="ɲ">
<br><br>
<input type="file" size="40" name="filename">
<input type="submit" name="myaddlist" value="ɲ">
<input type="hidden" name="sk" value="$sesskey">
</form>
EOD;
    }
};

/*********************************************************
 * mk_addr_list
 *
 * ɥ쥹ΥꥹȤ
 *
 * []
 *           $nowlist	ߤΥꥹ
 *           $input	Ϥ줿ꥹ
 *           $list      ɥ쥹γǼ
 *           $bool      ꥹȤ˲ä(TRUE:¸ߤ| FALSE:ʤ)
 *
 * [֤]
 *	     int	ɥ쥹ο
 **********************************************************/
function mk_addr_list($nowlist, $input, &$list, $bool)
{
    global $err_msg;

    $list = array();

    $i = 0;
    /* ߤΥꥹȤĤ̵ */
    if (!is_array($nowlist)) {
        if ($bool === TRUE) {
            return 0; 
        }
        $list = $input;
        return count($list);
    }

    foreach($input as $addr) {
        reset($nowlist);
        if ((array_search($addr, $nowlist) !== FALSE) === $bool) {
            $list[] = $addr;
            $i++;
        }
    }

    return $i;
}

/***********************************************************
 * 
 **********************************************************/
/* 󥹥󥹺 */
$pg  = new my_page();
if (isset($_POST["sk"])) {
    $sesskey = $_POST["sk"];
}

/* ɥᥤ */
$domain = $_SERVER['DOMAIN'];

/* եɹ */
$ret = read_web_conf();
if ($ret === FALSE) {
    $sys_err = TRUE;
    $pg->display($topic, MY_TAB);
    exit (1);
}

/* Ź沽Υѥ򥻥å */
$admkey_file = BASEDIR . ETCDIR . $domain . "/" . ADMKEY;

/* å */
if (isset($sesskey) === FALSE) {
    header("Location: index.php?e=2");
    exit (1);
}

/* åå */
if (is_sysadm($sesskey) !== TRUE) {
    /* ̤ */
    header("Location: index.php?e=1");
    exit (1);
}

/* 顼å */
$err_msg = "";

/***********************************************************
 * main
 **********************************************************/

/* ᡼󥰥ꥹȤ򤵤Ƥʤ */
if (isset($_POST["mladdr"]) === FALSE) {

    $logstr = "᡼󥰥ꥹȥɥ쥹";
    $err_msg = "᡼󥰥ꥹȥɥ쥹ꤵƤޤ";

    $logstr .= ":NG:" . $err_msg;
    result_log($logstr);
    
    /* ᡼󥰥ꥹȴ̤ */
    dgp_location("admin_ml_list.php", $err_msg);
    exit;
}

/* LDAPθDN */
$search_dn = sprintf(SEARCH_DN, $web_conf['ldaplistsuffix'], $web_conf["ldapbasedn"]);

$dispmlatt = $web_conf['displayml'];

/* LDAPե륿 */
$filter = "(&(objectClass=" . PLAOC . ")" .
          "(&(mail=" . $_POST['mladdr'] . ")" . 
          "(&" . $web_conf["ldapmlfilter"] .
          "(" . $dispmlatt . "=*)" .
          ")))";

/* Ͽ */
if (isset($_POST["myadd"])) {

    $logstr = "᡼륢ɥ쥹ɲ";

    /* ɥ쥹ν񼰥å */
    if (check_mail($_POST["newaddr"]) === FALSE) {
        $err_msg = "᡼륢ɥ쥹ηޤ";
        $logstr .= ":NG:" . $err_msg;
    } else {
        /* ᡼륢ɥ쥹μ */
        $result = array();
        $ret = main_get_entry($search_dn, $filter, array(), $web_conf["ldapscope"], $result);
        /* LDAP˼ */
        if ($ret != LDAP_OK) {
            $sys_err = TRUE;
            $pg->display($topic, MY_TAB);
            result_log($logstr . ":NG:" . $err_msg);
            exit (1);
        }
        $dn = $result[0]["dn"];

        /*᡼󥰥ꥹȥɥ쥹Ȥνʣå */
        if ($_POST["newaddr"] == $_POST["mladdr"]) {
            $err_msg = "᡼륢ɥ쥹᡼󥰥ꥹ" .
                       "ɥ쥹ȽʣƤޤ";
            $logstr .= ":NG:" . $err_msg;
        } else {
            $attr = array("mailForwardingAddr" => $_POST["newaddr"]);

            /* °ɲ */
            $ret = LDAP_add_attribute($dn, $attr);
            if ($ret == LDAP_ERR_DUPLICATE) {
                    $err_msg = "¸ߤƤ" .
                               "ɥ쥹ꤵƤޤ(" .
                               $_POST["newaddr"] . ")";
                    $logstr .= ":NG:" . $err_msg;
            } elseif ($ret != LDAP_OK) {
                $logstr .= ":NG:" . $err_msg;
            } else {
                $err_msg = "ɥ쥹ɲäޤ({$_POST["newaddr"]})";
                $logstr .= ":OK:" . $err_msg;
                $_POST["newaddr"] = "";
            }
        }
    }
    result_log($logstr);

/* Ͽ */
} else if (isset($_POST["myaddlist"])) {

    $logstr = "᡼󥰥ꥹȥɥ쥹ɲ";

    if (get_addr_list($_FILES["filename"]["tmp_name"], $fwaddrs) === FALSE) {
        $logstr .= ":NG:" . $err_msg;

    } else {

        /* ᡼륢ɥ쥹μ */
        $result = array();
        $ret = main_get_entry($search_dn, $filter, array(), $web_conf["ldapscope"], $result);
        /* LDAP˼ */
        if ($ret != LDAP_OK) {
            $sys_err = TRUE;
            $pg->display($topic, MY_TAB);
            result_log($logstr . ":NG:" . $err_msg);
            exit (1);
        }
        $dn = $result[0]["dn"];

        if (!isset($result[0]["mailForwardingAddr"])) {
            $num = 0;
            $result[0]["mailForwardingAddr"] = array();
        }

        $num = mk_addr_list($result[0]["mailForwardingAddr"], $fwaddrs,
                                $addlist, FALSE);

        /* ᡼󥰥ꥹȥɥ쥹Ȥνʣå */
        foreach ($addlist as $eachmail) {
            if ($_POST["mladdr"] == $eachmail) {
                $err_msg = "᡼륢ɥ쥹᡼󥰥ꥹ" .
                           "ɥ쥹ȽʣƤޤ";
                $logstr .= ":NG:" . $err_msg;
                $dup_flg = 1;
                break;
            }
        }

        if (!isset($dup_flg)) {
            /* °ɲ */
            if ($num != 0) {
                $attr = array("mailForwardingAddr" => $addlist);
                $ret = LDAP_add_attribute($dn, $attr);
            } else {
                $ret = LDAP_OK;
            }

            if ($ret != LDAP_OK) {
                if ($ret == LDAP_ERR_DUPLICATE) {
                    $err_msg = "¸ߤƤ륢ɥ쥹ꤵƤޤ";
                }
                $logstr .= ":NG:" . $err_msg;
            } else {
                $err_msg = "ɥ쥹ɲäޤ";
                $logstr .= ":OK:" . $err_msg;
            }
        }
    }
    $logstr = preg_replace("/<br>/i", " / ", $logstr);
    result_log($logstr);

/*  */
} else if (isset($_POST["mydel"])) {

    /*  */
    $logstr = "᡼󥰥ꥹȥɥ쥹";

    if (isset($_POST["addr"])) {

        /* ߤΥ᡼륢ɥ쥹μ */
        $result = array();
        $ret = main_get_entry($search_dn, $filter, array(), $web_conf["ldapscope"], $result);
        /* LDAP˼ */
        if ($ret != LDAP_OK) {
            $sys_err = TRUE;
            $pg->display($topic, MY_TAB);
            result_log($logstr . ":NG:" . $err_msg);
            exit (1);
        }
        $dn = $result[0]["dn"];

        if (!isset($result[0]["mailForwardingAddr"])) {
            $result[0]["mailForwardingAddr"] = array();
        }
        $num = mk_addr_list($result[0]["mailForwardingAddr"], $_POST["addr"],
                            $dellist, TRUE);

        /* LDAP° */
        if ($num != 0) {
            $ret = LDAP_del_attribute($dn, array("mailForwardingAddr" =>
                                                 $dellist));
        } else {
            $ret = LDAP_OK;
        }

        if ($ret != LDAP_OK) {
            if ($ret == LDAP_ERR_NOATTR) {
                $err_msg = "˺Ƥ륢ɥ쥹ꤵƤޤ(dn=$dn)";
            }
            $logstr .= ":NG:" . $err_msg;
        } else {
            $err_msg = "᡼륢ɥ쥹ޤ";
            $logstr .= ":OK:" . $err_msg;
        }

    } else {
        $err_msg = "᡼륢ɥ쥹򤵤Ƥޤ";
        $logstr .= ":NG:" . $err_msg;
    }
    result_log($logstr);
}

/* ᡼륢ɥ쥹μ */
$result = array();
$ret = main_get_entry($search_dn, $filter, array(), $web_conf["ldapscope"], $result);
/* LDAP˼ */
if ($ret != LDAP_OK) {
    $sys_err = TRUE;
    $pg->display($topic, MY_TAB);
    result_log("᡼󥰥ꥹȥɥ쥹:NG:" . $err_msg);
    exit (1);
}
$dn = $result[0]["dn"];

/* ɽѤ°Ǽ */
$dispml = $result[0]["$dispmlatt"][0];

/***********************************************************
 * ɽ
 **********************************************************/

/* ڡν */
$pg->display($topic, MY_TAB);

?>
