<?php

/*
 * postLDAPadmin
 *
 * Copyright (C) 2006,2007 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/***********************************************************
 * ᡼󥰥ꥹȰ
 *
 * $RCSfile: index.php,v $
 * $Revision: 1.1.1.1 $
 * $Date: 2010/04/22 01:52:47 $
 **********************************************************/

include_once("../../initial");
include_once("lib/dglibpostldapadmin");
include_once("lib/dglibcommon");
include_once("lib/dglibpage");
include_once("lib/dglibldap");
include_once("lib/dglibsess");

/********************************************************
ƥڡ
*********************************************************/
/* ֤μ */
define("MY_TAB", TAB_ML);

/* ѥ󤯤ꥹ */
$topic[0]["name"] = TOPIC_SYSTEM_ML;
$topic[0]["url"] = "";

define("OPERATION", "᡼󥰥ꥹȰ");

/***********************************************************
 * 饹: ˥塼
 **********************************************************/
Class my_page extends page {

    /***********************************************************
     * ܥǥɽʥС饤ɡ
     **********************************************************/
    function display_body() {

        global $result;
        global $sesskey;
        global $domain;
        global $web_conf;
        global $displayml;
        global $url_data;

        $newml = "";
        if (isset($_POST["newml"])) {
            $newml = htmlspecialchars($_POST["newml"]);
        }

        $domain = htmlspecialchars($domain);
        print <<<EOD

<script type="text/javascript">
<!--
function sysSubmit(url) {
    document.ml.action = url;
    document.ml.submit();
}
// -->
</script>
<form method="post" action="index.php" name="ml">
<table>
  <tr>
    <td>
        <select size="10" name="mladdr">

EOD;

        $displayml = $web_conf[$url_data["script"]]["displayml"];
        usort($result, "ml_sort");
        reset($result);
        foreach($result as $i) {
            $mldisp = $i["$displayml"][0];
            $mldisp = htmlspecialchars($mldisp);
            $mladdr = $i["mail"][0];
            $mladdr = htmlspecialchars($mladdr);
            print("          <option value=\"$mladdr\">$mldisp" . "\n");
        }

        print <<<EOD
        </select>
    </td>
    <td valign="bottom">
        <input type="submit" name="add" value="᡼륢ɥ쥹ɲá" onClick="return sysSubmit('mod.php')"><br><input type="submit" name="del" value="򤷤᡼󥰥ꥹȤ" onClick="return msgConfirm('򤷤᡼󥰥ꥹȥɥ쥹ޤ\\nǤ')">
    </td>
  </tr>
</table>
<br>
<input type="text" size="40" maxlength="32" name="newml" value="$newml"><span class="maildomain">@$domain</span>
<input type="submit" name="add" value="Ͽ">
<input type="hidden" name="sk" value="$sesskey">
</form>
EOD;
    }
};

/*********************************************************
 * add_ml
 *
 * ᡼󥰥ꥹȥȥɲ
 *
 * []
 *        $newm    MLɥ쥹
 *
 * [֤]
 *        TRUE     
 *        FALSE    顼
 **********************************************************/
function add_ml($newml)
{
    global $web_conf;
    global $err_msg;
    global $domain;
    global $url_data;

    $mail = $newml . "@" . $domain;

    /* ᡼󥰥ꥹȥɥ쥹νʣå */
    $ret = check_duplicate($mail);
    if ($ret == LDAP_FOUNDUSER || $ret == LDAP_FOUNDALIAS ||
        $ret == LDAP_FOUNDOTHER) {
        $err_msg = "᡼륢ɥ쥹ϴ˻ȤƤޤ";
        return FALSE;
    } elseif ($ret == LDAP_ERRUSER) {
        return FALSE;
    }

    /* LDAPɲ° */
    $add_dn = sprintf(ADD_DN, $mail, 
                      $web_conf[$url_data["script"]]["ldaplistsuffix"], 
                      $web_conf[$url_data["script"]]["ldapbasedn"]);
    $objectclass = mk_oc_list($web_conf[$url_data['script']]['ldapobjectclass']);
    $attr = array("objectClass" => $objectclass,
                  "mail" => $mail,
                  "uid" => $newml);

    /* LDAPȥɲ */
    $ret = LDAP_add_entry($add_dn, $attr);
    if ($ret != LDAP_OK) {
        return FALSE;
    }

    $dispml = $web_conf[$url_data["script"]]["displayml"];
    $dispval = $attr["$dispml"];

    $err_msg = "᡼󥰥ꥹȡ" . $dispval ."פޤ";
    return TRUE;
}

/*********************************************************
 * del_ml
 *
 * ᡼󥰥ꥹȥȥκ
 *
 * []
 *        $mladdr    MLɥ쥹
 *
 * [֤]
 *        TRUE       
 *        FALSE      顼
 **********************************************************/
function del_ml($mladdr)
{
    global $web_conf;
    global $err_msg;
    global $url_data;

    $dispml = $web_conf[$url_data["script"]]["displayml"];

    /* ᡼󥰥ꥹȥȥμ */
    $dn = sprintf(SEARCH_DN, $web_conf[$url_data['script']]['ldaplistsuffix'], 
                  $web_conf[$url_data['script']]['ldapbasedn']);
    $result = array();
    $filter = "(&(mail=" . $mladdr . ")(objectClass=" . PLAOC . "))";
    $ret = main_get_entry($dn, $filter, array($dispml),
                          $web_conf[$url_data["script"]]["ldapscope"], $result);
    /* ˺Ƥ */
    if ($ret == LDAP_ERR_NODATA) {
        $err_msg = "ꤵ줿᡼󥰥ꥹȥɥ쥹ϴ˺Ƥޤ";
        return TRUE;
    }
    /* LDAP˼ */
    if ($ret != LDAP_OK) {
        return FALSE;
    }

    $del_dn = $result[0]["dn"];
    $dispval = $result[0]["$dispml"][0];

    /* LDAPȥ */
    $ret = LDAP_del_entry($del_dn);
    if ($ret != LDAP_OK && $ret != LDAP_ERR_NODATA) {
        return FALSE;
    }

    $err_msg = "᡼󥰥ꥹȡ" . $dispval . "פޤ";
    return TRUE;
}

/***********************************************************
 * 
 **********************************************************/

/* 󥹥󥹺 */
$pg  = new my_page();

/* ե롢ִեɹåå */
$ret = init();
if ($ret === FALSE) {
    $sys_err = TRUE;
    $pg->display(NULL);
    exit (1);
}

/* 顼å */
$err_msg = "";
if (isset($_POST["msg"])) {
    $err_msg = $_POST["msg"];
}

/***********************************************************
 * main
 **********************************************************/

/* Ͽ */
if (isset($_POST["add"])) {

    /* ɥ쥹ν񼰥å */
    if ($_POST["newml"] == "") {
        $err_msg = "᡼󥰥ꥹȥɥ쥹ϤƤޤ";
        result_log(OPERATION . ":NG:" . $err_msg);
    } else {
        if (check_name($_POST["newml"], MAXNAME) === FALSE) {
            $err_msg = "᡼󥰥ꥹȥɥ쥹ηǤ";
            result_log(OPERATION . ":NG:" . $err_msg);
        } else {
            if (add_ml($_POST["newml"]) === FALSE) {
                result_log(OPERATION . ":NG:" . $err_msg);
            } else {
                result_log(OPERATION . ":OK:" . $err_msg);
                $_POST["newml"] = "";
            }
        }
    }

/*  */
} else if (isset($_POST["del"])) {

    if (isset($_POST["mladdr"])) {

        if (del_ml($_POST["mladdr"]) === FALSE) {
            result_log(OPERATION . ":NG:" . $err_msg);
        } else {
            result_log(OPERATION . ":OK:" . $err_msg);
            $err_msg = htmlspecialchars($err_msg);
        }
    } else {
        $err_msg = "᡼󥰥ꥹȥɥ쥹򤵤Ƥޤ";
        result_log(OPERATION . ":NG:" . $err_msg);
    }

}

$err_tmp = $err_msg;

/* ᡼󥰥ꥹȥȥμ */
$dn = sprintf(SEARCH_DN, $web_conf[$cmp]['ldaplistsuffix'], $web_conf[$cmp]['ldapbasedn']);
$result = array();
$filter = "(&(objectClass=" . PLAOC . ")" .
          "(&(" . $web_conf[$cmp]['displayml'] . "=*)" . 
          $web_conf[$cmp]['ldapmlfilter'] . "))";
$ret = main_get_entry($dn, $filter, array(), $web_conf[$cmp]["ldapscope"], $result);

/* LDAP˼ */
if ($ret != LDAP_OK && $ret != LDAP_ERR_NODATA) {
    result_log(OPERATION . ":NG:" . $err_msg);
    if ($err_tmp != "" && $err_tmp != $err_msg) {
        $err_msg = $err_tmp . "<BR>" . $err_msg;
    }
    $sys_err = TRUE;
    $pg->display($topic, MY_TAB);
    exit (1);
}
if ($ret == LDAP_ERR_NODATA) {
    $err_msg = $err_tmp;
}

/***********************************************************
 * ɽ
 **********************************************************/

/* ڡν */
$pg->display(CONTENT);

?>
