<?php

/*
 * postLdapAdmin
 *
 * Copyright (C) 2006,2007 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/***********************************************************
 * CSV̲
 *
 * $RCSfile$
 * $Revision$
 * $Date$
 **********************************************************/

include_once("../../initial");
include_once("lib/dglibpostldapadmin");
include_once("lib/dglibcommon");
include_once("lib/dglibpage");
include_once("lib/dglibsess");
include_once("lib/dglibldap");
include_once("lib/dglibforward");
include_once("lib/dglibdovecot");

/********************************************************
ƥڡ
*********************************************************/
define("OPERATION", "Registering CSV at once");

/* CSV֤ */
define("CSV_BATCH_OK", 0);             # 
define("CSV_BATCH_NG_ERR_IGNORE", 1);  # (顼̵)
define("CSV_BATCH_NG_END", 2);         # ()

/* CSVκ */
define("CSV_ADDCOLUMN_MAX", 6);
define("CSV_ADDCOLUMN_FORWARD_MAX", 8);

/* ʸΥ󥳡ǥ */
define("USERNAME_DISP_ENCODING", "EUC-JP");
define("READ_CSVFILE_ENCODING",  "SJIS");

/***********************************************************
 * mk_ldap_array
 *
 * LDAPѹ
 *
 * []
 *        $csvdata   CSVե뤫ɤ߹
 *
 *        $csvdata[0] = (桼̾)
 *        $csvdata[1] = (ѥ)
 *        $csvdata[2] = (᡼ܥå)
 *        $csvdata[3] = (᡼륨ꥢ)
 *        $csvdata[4] = (žɥ쥹)
 *        $csvdata[5] = (Ф˥᡼Ĥ/Ĥʤ)
 *        $csvdata[6] = (mailFilterOrderForwardConfONλΤ)
 *        $csvdata[7] = (mailFilterArticleForwardConfONλΤ)
 * [֤]
 *        Ѵ줿
 *        $userdata["uid"] = (桼̾)
 *        $userdata["pass"] = (ѥ)
 *        $userdata["re_pass"] = (ѥ)
 *        $userdata["quota"] = (᡼ܥå)
 *        $userdata["alias"] = (᡼륨ꥢ)
 *        $userdata["transes"][0] = (᡼žɥ쥹)
 *        $userdata["save"] = (Ф˥᡼Ĥ/Ĥʤ)
 *        $userdata["order"] = (mailFilterOrderForwardConfONλΤ)
 *        $userdata["article"] = (mailFilterArticleForwardConfONλΤ)
 *
 **********************************************************/
function mk_ldap_array($csvdata)
{
    global $web_conf;
    global $url_data;

    /* ηѴ */

    # 桼̾ʷɽѤEUCѴ
    if (isset($csvdata[0])) {
        $userdata["uid"] = mb_convert_encoding($csvdata[0], 
                                USERNAME_DISP_ENCODING, READ_CSVFILE_ENCODING);
    }

    if (isset($csvdata[1])) {
        # ѥ
        $userdata["pass"] = $csvdata[1];

        # ƥѥ(ѥɤƱ)
        $userdata["re_pass"] = $csvdata[1];
    }

    # ᡼ܥå
    if (isset($csvdata[2])) {
        $userdata["quota"] = $csvdata[2];
    }

    # ᡼륨ꥢ
    if (isset($csvdata[3])) {
        $userdata["alias"] = $csvdata[3];
    }

    # ᡼žɥ쥹
    if (isset($csvdata[4])) {
        $userdata["transes"][0] = $csvdata[4];
    }

    # Ф˥᡼Ĥ/Ĥʤ
    if (isset($csvdata[5])) {
        $userdata["save"] = $csvdata[5];
    }

    // forwardconfonξϥȥƥ
    if ($web_conf[$url_data['script']]['forwardconf'] === FORWARD_ON) {
        // ¸ߤгǼ
        if (isset($csvdata[6])) {
            $userdata["order"] = $csvdata[6];
        }

        // ƥ뤬¸ߤгǼ
        if (isset($csvdata[7])) {
            $userdata["article"] = $csvdata[7];
        }
    }

    return $userdata;

}

/***********************************************************
 * fcheck_add_user_duplicate
 *
 * եåѥ桼ʣå
 *
 * []
 *        $userdata   CSVեΥǡǼƤϢ
 *        $fcheckuser եåϿ桼Ǽ
 *
 * [֤]
 *        TRUE        ̤Ͽ桼
 *        FALSE       ϿƤ桼
 *
 **********************************************************/
function fcheck_add_user_duplicate($userdata, $fcheckuser)
{
    global $msgarr;
    global $err_msg;
    global $log_msg;

    $max = count($fcheckuser);
    for ($i = 0; $i < $max; $i++) {
        /* 桼̾Υå */
        if ($fcheckuser[$i]["uid"] == $userdata["uid"] ||
            $fcheckuser[$i]["alias"] == $userdata["uid"]) {
            $err_msg = $msgarr['14001'][SCREEN_MSG];
            $log_msg = $msgarr['14001'][LOG_MSG];
            return FALSE;
        }

        /* ꥢνʣå */
        if ($userdata["alias"] != "") {
            if ($fcheckuser[$i]["uid"] == $userdata["alias"] ||
                $fcheckuser[$i]["alias"] == $userdata["alias"]) {
                $err_msg = $msgarr['14002'][SCREEN_MSG];
                $log_msg = $msgarr['14002'][LOG_MSG];
                return FALSE;
            }
        }
    }

    return TRUE;
}

/***********************************************************
 * is_fcheck_del_user
 *
 * եåѥ桼¸ߥå
 *
 * []
 *        $userdata   CSVեΥǡǼƤϢ
 *        $fcheckuser եåϿ桼Ǽ
 *
 * [֤]
 *        TRUE        Ƥʤ
 *        FALSE       ˺Ƥ
 *
 **********************************************************/
function is_fcheck_del_user($userdata, $fcheckuser)
{
    global $msgarr;
    global $err_msg;
    global $log_msg;

    $max = count($fcheckuser);
    for ($i = 0; $i < $max; $i++) {
        /* 桼̾Υå */
        if ($fcheckuser[$i]["uid"] == $userdata["uid"]) {
            $err_msg = $msgarr['14003'][SCREEN_MSG];
            $log_msg = $msgarr['14003'][LOG_MSG];
            return FALSE;
        }
    }
    return TRUE;

}
/***********************************************************
 * csv_add_user
 *
 * CSV桼ϿԤ
 *
 * []
 *        $userdata   CSVեΥǡǼƤϢ
 *        $ds         LDAPID
 *        $fcheckuser եåϿ桼Ǽ
 *        $logstr     Ϥ˻Ѥʸ
 *        $line       Կ
 *
 * [֤]
 *        CSV_BATCH_OK               
 *        CSV_BATCH_NG_ERR_IGNORE    顼̵
 *        CSV_BATCH_NG_END           λ
 *
 **********************************************************/
function csv_add_user($userdata, $ds, $fcheckuser, $logstr, $line)
{
    global $msgarr;
    global $err_msg;
    global $log_msg;
    global $web_conf;
    global $domain;
    global $userdn;
    global $url_data;
    global $ldapdata;

    $type = ADD_MODE;

    // CSVեηå
    if (check_userdata($userdata) === FALSE) {
        printf(CSV_NG_MSG, $line, htmlspecialchars($userdata["uid"]), $err_msg);
        ob_flush();
        flush();
        result_log($logstr . ":NG:" . $userdata["uid"] .
                   ":$log_msg(line ${line})");
        if (isset($_POST["err"])) {
            return CSV_BATCH_NG_ERR_IGNORE;
        } else {
            return CSV_BATCH_NG_END;
        }
    }

    /* եåѽʣå */
    if (isset($_POST["fcheck"])) {
        if (fcheck_add_user_duplicate($userdata, $fcheckuser) === FALSE) {
            printf(CSV_NG_MSG, $line, htmlspecialchars($userdata["uid"]),
                   $err_msg);
            ob_flush();
            flush();
            result_log($logstr . ":NG:" . $userdata["uid"] .
                       ":$log_msg(line ${line})");
            if (isset($_POST["err"])) {
                return CSV_BATCH_NG_ERR_IGNORE;
            } else {
                return CSV_BATCH_NG_END;
            }
        }
    }

    /* ᡼륢ɥ쥹 */
    $userdata["mail"] = $userdata["uid"] . "@" . $domain;

    $userdn = sprintf(ADD_DN, $userdata["mail"], $web_conf[$url_data["script"]]["ldapusersuffix"],
                      $web_conf[$url_data["script"]]["ldapbasedn"]);


    /* 桼νʣå */
    $ret = csv_check_duplicate($userdata["mail"], $ds);
    if ($ret == LDAP_ERRUSER) {
        printf(CSV_NG_MSG, $line, htmlspecialchars($userdata["uid"]), $err_msg);
        ob_flush();
        flush();
        result_log($logstr . ":NG:" . $userdata["uid"] .
                   ":$log_msg(line ${line})");
        if (isset($_POST["err"])) {
            return CSV_BATCH_NG_ERR_IGNORE;
        } else {
            return CSV_BATCH_NG_END;
        }
    }

    /* ʣǾ񤭤˥åϥǡѹ */
    if (isset($_POST["change"]) && $ret == LDAP_FOUNDUSER) {
        $type = MOD_MODE;
    }

    /* ʣƤϥ顼 */
    if (($type == ADD_MODE && $ret == LDAP_FOUNDUSER) ||
        $ret == LDAP_FOUNDALIAS || $ret == LDAP_FOUNDOTHER) {
        $err_msg = $msgarr['14001'][SCREEN_MSG];
        $log_msg = $msgarr['14001'][LOG_MSG];
        printf(CSV_NG_MSG, $line, htmlspecialchars($userdata["uid"]), $err_msg);
        ob_flush();
        flush();
        result_log($logstr . ":NG:" . $userdata["uid"] .
                   ":$log_msg(line ${line})");
        if (isset($_POST["err"])) {
            return CSV_BATCH_NG_ERR_IGNORE;
        } else {
            return CSV_BATCH_NG_END;
        }
    }

    /* ꥢνʣå */
    if ($userdata["alias"] != "") {
        $userdata["mailalias"] = $userdata["alias"] . "@" . $domain;
        $ret = csv_check_duplicate($userdata["mailalias"], $ds);
        if ($ret == LDAP_ERRUSER) {
            printf(CSV_NG_MSG, $line, htmlspecialchars($userdata["uid"]),
                   $err_msg);
            ob_flush();
            flush();
            result_log($logstr . ":NG:" . $userdata["uid"] .
                       ":$log_msg(line ${line})");
            if (isset($_POST["err"])) {
                return CSV_BATCH_NG_ERR_IGNORE;
            } else {
                return CSV_BATCH_NG_END;
            }
        }
        if ($ret == LDAP_FOUNDUSER || $ret == LDAP_FOUNDOTHER) {
            $err_msg = $msgarr['14002'][SCREEN_MSG];
            $log_msg = $msgarr['14002'][LOG_MSG];
            printf(CSV_NG_MSG, $line, htmlspecialchars($userdata["uid"]),
                   $err_msg);
            ob_flush();
            flush();
            result_log($logstr . ":NG:" . $userdata["uid"] .
                   ":$log_msg(line ${line})");
            if (isset($_POST["err"])) {
                return CSV_BATCH_NG_ERR_IGNORE;
            } else {
                return CSV_BATCH_NG_END;
            }
        }
    }

    /* ǥ̥å */
    $quotalen = strlen($userdata["quota"]);
    if ($quotalen > $web_conf[$url_data["script"]]["quotasize"]) {
        $err_msg = $msgarr['14004'][SCREEN_MSG];
        $log_msg = $msgarr['14004'][LOG_MSG];
        printf(CSV_NG_MSG, $line, htmlspecialchars($userdata["uid"]), $err_msg);
        ob_flush();
        flush();
        result_log($logstr . ":NG:" . $userdata["uid"] .
                   ":$log_msg(line ${line})");
        if (isset($_POST["err"])) {
            return CSV_BATCH_NG_ERR_IGNORE;
        } else {
            return CSV_BATCH_NG_END;
        }
    }

    /* žɥ쥹Υå */
    if (check_csv_trans($userdata) === FALSE) {
        printf(CSV_NG_MSG, $line, htmlspecialchars($userdata["uid"]), $err_msg);
        ob_flush();
        flush();
        result_log($logstr . ":NG:" . $userdata["uid"] .
                   ":$log_msg(line ${line})");
        if (isset($_POST["err"])) {
            return CSV_BATCH_NG_ERR_IGNORE;
        } else {
            return CSV_BATCH_NG_END;
        }
    }

    /* ɲû */
    if ($type == ADD_MODE) {
        /* LDAPɲ */
        if (isset($_POST["upload"])) {
            if (add_user_connect($userdata, $ds) === FALSE) {
                printf(CSV_NG_MSG, $line, htmlspecialchars($userdata["uid"]),
                       $err_msg);
                ob_flush();
                flush();
                result_log($logstr . ":NG:" .  $userdata["uid"] .
                           ":$log_msg(line ${line})");
                if (isset($_POST["err"])) {
                    return CSV_BATCH_NG_ERR_IGNORE;
                } else {
                    return CSV_BATCH_NG_END;
                }
            }
            $err_msg = $msgarr['14005'][SCREEN_MSG];
            $log_msg = $msgarr['14005'][LOG_MSG];

            // forwardconfonξsieveեκ
            if ($web_conf[$url_data['script']]['forwardconf'] === FORWARD_ON) {
                $ldapdata[0]['mailFilterArticle'] = explode(":", $userdata['article']);
                $ldapdata[0]['mailFilterOrder'][0] = $userdata['order'];
                $ldapdata[0]['mailDirectory'][0] = $web_conf[$url_data["script"]]["basemaildir"] . "/" . $userdata['uid'] . "/";

                // sieveե
                $ret = make_sievefile();
                // sieveեκ˼Ԥϲ̺ɽ
                if ($ret === FALSE) {
                    $err_msg = $msgarr['26011'][SCREEN_MSG];
                    printf(CSV_NG_MSG, $line, htmlspecialchars($userdata["uid"])                           , $err_msg);
                    ob_flush();
                    flush();
                    result_log($logstr . ":NG:" .  $userdata["uid"] .
                               ":$log_msg(line ${line})");
                    if (isset($_POST["err"])) {
                        return CSV_BATCH_NG_ERR_IGNORE;
                    } else {
                        return CSV_BATCH_NG_END;
                    }
                }
            }
        /* եå */
        } else {
            $err_msg = $msgarr['14014'][SCREEN_MSG];
            $log_msg = $msgarr['14014'][LOG_MSG];
        }
        printf(CSV_OK_MSG, $line, htmlspecialchars($userdata["uid"]), $err_msg);
        ob_flush();
        flush();
        result_log($logstr . ":OK:" . $userdata["uid"] .
                   ":$log_msg(line ${line})");
    /* ѹ */
    } else {
        // LDAPѹ
        if (isset($_POST["upload"])) {
            if (mod_user_connect($userdata, $ds) === FALSE) {
                printf(CSV_NG_MSG, $line, htmlspecialchars($userdata["uid"]),
                       $err_msg);
                ob_flush();
                flush();
                result_log($logstr . ":NG:" .  $userdata["uid"] .
                           ":$log_msg(line ${line})");
                if (isset($_POST["err"])) {
                    return CSV_BATCH_NG_ERR_IGNORE;
                } else {
                    return CSV_BATCH_NG_END;
                }
            }
            $err_msg = $msgarr['14006'][SCREEN_MSG];
            $log_msg = $msgarr['14006'][LOG_MSG];

            // forwardconfonξsieveեκ
            if ($web_conf[$url_data['script']]['forwardconf'] === FORWARD_ON) {
                $ldapdata[0]['mailFilterArticle'] = explode(":", $userdata['article']);
                $ldapdata[0]['mailFilterOrder'][0] = $userdata['order'];
                $ldapdata[0]['mailDirectory'][0] = $web_conf[$url_data["script"]]["basemaildir"] . "/" . $userdata['uid'] . "/";

                // sieveե
                $ret = make_sievefile();
                // sieveեκ˼Ԥϲ̺ɽ
                if ($ret === FALSE) {
                    $err_msg = $msgarr['26011'][SCREEN_MSG];
                    if (isset($_POST["err"])) {
                        return CSV_BATCH_NG_ERR_IGNORE;
                    } else {
                        return CSV_BATCH_NG_END;
                    }
                }
            }
        /* եå */
        } else {
            $err_msg = $msgarr['14015'][SCREEN_MSG];
            $log_msg = $msgarr['14015'][LOG_MSG];
        }
        printf(CSV_OK_MSG, $line, htmlspecialchars($userdata["uid"]), $err_msg);
        ob_flush();
        flush();
        result_log($logstr . ":OK:" . $userdata["uid"] .
                   ":$log_msg(line ${line})");
    }
    return CSV_BATCH_OK;

}

/***********************************************************
 * csv_del_user
 *
 * CSV桼Ԥ
 *
 * []
 *        $userdata   CSVեΥǡǼƤϢ
 *        $ds         LDAPID
 *        $fcheckuser եåϿ桼Ǽ
 *        $logstr     Ϥ˻Ѥʸ
 *        $line      Կ
 *
 * [֤]
 *        CSV_BATCH_OK               
 *        CSV_BATCH_NG_ERR_IGNORE    顼̵
 *        CSV_BATCH_NG_END           λ
 *
 **********************************************************/
function csv_del_user($userdata, $ds, $fcheckuser, $logstr, $line)
{
    global $msgarr;
    global $err_msg;
    global $log_msg;
    global $domain;
    global $web_conf;
    global $userdn;
    global $url_data;

    /* CSVηå */
    if ($userdata["uid"] == "") {
        $err_msg = $msgarr['14007'][SCREEN_MSG];
        $log_msg = $msgarr['14007'][LOG_MSG];
        printf(CSV_NG_MSG, $line, htmlspecialchars($userdata["uid"]), $err_msg);
        ob_flush();
        flush();
        result_log($logstr . ":NG:" . $userdata["uid"] .
                   ":$log_msg(line ${line})");
        if (isset($_POST["err"])) {
            return CSV_BATCH_NG_ERR_IGNORE;
        } else {
            return CSV_BATCH_NG_END;
        }
    }

    /* եå¸ߥå */
    if (isset($_POST["fcheck"])) {
        if (is_fcheck_del_user($userdata, $fcheckuser) === FALSE) {
            printf(CSV_NG_MSG, $line, htmlspecialchars($userdata["uid"]),
                   $err_msg);
            ob_flush();
            flush();
            result_log($logstr . ":NG:" . $userdata["uid"] .
                       ":$log_msg(line ${line})");
            if (isset($_POST["err"])) {
                return CSV_BATCH_NG_ERR_IGNORE;
            } else {
                return CSV_BATCH_NG_END;
            }
        }
    }

    /* оݤȤʤDNʸ */
    $userdn = sprintf(ADD_DN, $userdata["uid"] . "@" .  $domain,
                      $web_conf[$url_data["script"]]["ldapusersuffix"], 
                      $web_conf[$url_data["script"]]["ldapbasedn"]);

    /* 桼̾¸ߥå */
    if (get_userdata_connect($userdn, $ds) === FALSE) {
        $err_msg = $msgarr['14003'][SCREEN_MSG];
        $log_msg = $msgarr['14003'][LOG_MSG];
        printf(CSV_NG_MSG, $line, htmlspecialchars($userdata["uid"]), $err_msg);
        ob_flush();
        flush();
        result_log($logstr . ":NG:" . $userdata["uid"] .
                   ":$log_msg(line ${line})");
        if (isset($_POST["err"])) {
            return CSV_BATCH_NG_ERR_IGNORE;
        } else {
            return CSV_BATCH_NG_END;
        }
    }

    /* LDAP */
    if (isset($_POST["upload"])) {
        if (del_user_connect($userdata["uid"], $ds) === FALSE) {
            printf(CSV_NG_MSG, $line, htmlspecialchars($userdata["uid"]),
                   $err_msg);
            ob_flush();
            flush();
            result_log($logstr . ":NG:" . $userdata["uid"] .
                       ":$log_msg(line ${line})");
            if (isset($_POST["err"])) {
                return CSV_BATCH_NG_ERR_IGNORE;
            } else {
                return CSV_BATCH_NG_END;
            }
        }
        $err_msg = $msgarr['14008'][SCREEN_MSG];
        $log_msg = $msgarr['14008'][LOG_MSG];
    /* å */
    } else {
        $err_msg = $msgarr['14016'][SCREEN_MSG];
        $log_msg = $msgarr['14016'][LOG_MSG];
    }

    /*  */
    printf(CSV_OK_MSG, $line, htmlspecialchars($userdata["uid"]), $err_msg);
    ob_flush();
    flush();
    result_log($logstr . ":OK:" . $userdata["uid"] . ":$log_msg(line ${line})");

    return CSV_BATCH_OK;

}

/***********************************************************
 * csv_column_check
 *
 * CSVΥå
 *
 * []
 *        $csvdata    CSVեʬΥǡ
 *        $num        Ĥ륫κ
 *        $line       Կʥѡ
 *        $logstr     ʸ
 *
 * [֤]
 *        CSV_BATCH_OK               
 *        CSV_BATCH_NG_ERR_IGNORE    顼̵
 *        CSV_BATCH_NG_END           λ
 *
 **********************************************************/
function csv_column_check($csvdata, $num, $line, $logstr)
{
    global $msgarr;
    global $err_msg;
    global $log_msg;

    if (count($csvdata) < $num) {
        $err_msg = $msgarr['14009'][SCREEN_MSG];
        $log_msg = $msgarr['14009'][LOG_MSG];
        printf(CSV_NG_MSG, $line, "", $err_msg);
        ob_flush();
        flush();
        result_log($logstr . ":NG:******:$log_msg(line ${line})");
        if (isset($_POST["err"])) {
            return CSV_BATCH_NG_ERR_IGNORE;
        } else {
            return CSV_BATCH_NG_END;
        }
    }
    return CSV_BATCH_OK;
}

/***********************************************************
 * read_csvfile
 *
 * CSVեɤ߹
 *
 * []
 *        $fp         եݥ
 *        $logstr     Ϥ˻Ѥʸ
 *
 * [֤]
 *        TRUE              
 *        FALSE             ۾ 
 *
 **********************************************************/
function read_csvfile($fp, $logstr)
{
    global $msgarr;
    global $err_msg;
    global $log_msg;
    global $web_conf;
    global $url_data;

    $line = 0;
    $fchecknum = 0;
    $fcheckuser = array();

    /* LDAP³ */
    $ds = LDAP_connect_server();
    if ($ds == LDAP_ERR_BIND) {
        return FALSE;
    }

    while (($tmpline = fgets($fp)) !== FALSE) {

        /* ޤǶڤ */
        $tmpline = rtrim($tmpline);
        $csvdata = parse_csv($tmpline);

        /* ͤν */
        $err_msg = "";
        $userdata = array();
        $dupuser = FALSE;

        /* ԿΥ */
        $line++;

        $colum_num = CSV_ADDCOLUMN_MAX;
        // 
        if ($web_conf[$url_data['script']]['forwardconf'] === FORWARD_ON) {
            $colum_num = CSV_ADDCOLUMN_FORWARD_MAX;
        }

        /* Υå */
        if ($_POST["runtype"] == "add") {
            $ret = csv_column_check($csvdata, $colum_num, $line,
                                    $logstr);
            if ($ret === CSV_BATCH_NG_END) {
                break;
            } elseif ($ret === CSV_BATCH_NG_ERR_IGNORE) {
                continue;
            }
        }

        // LDAPϿѴ
        $userdata = mk_ldap_array($csvdata);

        if ($_POST["runtype"] == "add") {
            // ȰϿʷåԤäƤ
            $ret = csv_add_user($userdata, $ds, $fcheckuser, $logstr, $line);
            if ($ret === CSV_BATCH_NG_END) {
                break;
            } elseif ($ret === CSV_BATCH_OK && isset($_POST["fcheck"])) {
                /* եåѲϿ桼Υǡ */
                $fcheckuser[$fchecknum]["uid"] = $userdata["uid"];
                $fcheckuser[$fchecknum]["alias"] = $userdata["alias"];
                $fchecknum++;
            }
        } elseif ($_POST["runtype"] == "del") {
            /* Ȱ */
            $ret = csv_del_user($userdata, $ds, $fcheckuser, $logstr, $line);
            if ($ret === CSV_BATCH_NG_END) {
                break;
            } elseif ($ret === CSV_BATCH_OK && isset($_POST["fcheck"])) {
                /* եåѲ桼Υǡ */
                $fcheckuser[$fchecknum]["uid"] = $userdata["uid"];
                $fchecknum++;
            }
        }
    }

    /*  */
    ldap_unbind($ds);

    /* եξ票顼 */
    if ($line == 0) {
        $err_msg = $msgarr['14010'][SCREEN_MSG];
        $log_msg = $msgarr['14010'][LOG_MSG];
        return FALSE;
    }

    return TRUE;
}

/***********************************************************
 * parse_csv
 *
 * csv
 *
 * []
 *        $line        csv1
 *
 * []
 *        $parse[1]    
 *
 **********************************************************/
function parse_csv($line)
{
    $parse = array();
    $rep_str = array();

    // "",,
    preg_match_all('/("[^"]*(""[^"]*)*"|[^,]*),?/', $line, $parse);

    // 
    array_pop($parse[1]);

    // "",
    foreach($parse[1] as $key => $value) {
        // "("")"
        if(preg_match('/^"(.*)"$/', $value, $rep_str)) {
            $parse[1][$key] = preg_replace('/""/', '"', $rep_str[1]);
        }
    }
    return $parse[1];
}

/***********************************************************
 * print_csv_result
 *
 * CSV̤η̲̤ɽ
 *
 * []
 *        $postdata   POSTϤ줿ǡϢ
 *        $filedata   եǡϢ
 *
 * [֤]
 *        ʤ
 *
 **********************************************************/
function print_csv_result()
{
    global $web_conf;
    global $domain;
    global $msgarr;
    global $err_msg;
    global $log_msg;
    global $admkey_file;
    global $userdn;
    global $basedir;
    global $url_data;

    /***********************************************************
     * 
     **********************************************************/
    /* إå */
    output_http_header();
    display_header();

    /* $basedir$topdirΥå */
    url_search();

    /* åå */
    if (isset($_POST["sk"])) {
        $sesskey = $_POST["sk"];
    }

    /* ɥᥤ */
    $domain = $_SERVER['DOMAIN'];

    /* եɹ */
    $ret = read_web_conf($url_data["script"]);
    if ($ret === FALSE) {
        print($err_msg);
        display_footer();
        exit(1);    
    }

    /* ֥եɹ */
    $ret = read_tab_conf(ADMINTABCONF);
    if ($ret === FALSE) {
        print($err_msg);
        display_footer();
        exit(1);    
    }

    /* åեɹ */
    $ret = make_msgarr(MESSAGEFILE);
    if ($ret === FALSE) {
        print($err_msg);
        display_footer();
        exit(1);    
    }

    /* å */
    if (isset($sesskey) === FALSE) {
        print("ˡǤ");
        display_footer();
        exit(1);    
    }

    /* åå */
    if (is_sysadm($sesskey) !== TRUE) {
        print("å̵Ǥ");
        display_footer();
        exit(1);    
    }

    /* 顼å */
    $err_msg = "";

    /***********************************************************
     * main
     **********************************************************/
    if (isset($_POST["fcheck"]) || isset($_POST["upload"])) {
        /* ʸ */
        $logstr = OPERATION;

        /* ưפꤵƤ뤫å */
        if (isset($_POST["runtype"]) === FALSE) {
            $err_msg = $msgarr['14013'][SCREEN_MSG];
            $log_msg = $msgarr['14013'][LOG_MSG];
            print($err_msg);
            display_footer();
            result_log($logstr . ":NG:" .  $log_msg);
            exit(1);    
        }

        /* CSVե뤬ꤵƤ뤫ɤå */
        if (($_FILES["uploadfile"]["tmp_name"]) == "") {
            $err_msg = $msgarr['14011'][SCREEN_MSG];
            $log_msg = $msgarr['14011'][LOG_MSG];
            print($err_msg);
            display_footer();
            result_log($logstr . ":NG:" .  $log_msg);
            exit(1);    
        } else {
            /* åץɥե륪ץ */
            $fp = fopen($_FILES["uploadfile"]["tmp_name"], 'r');
            if ($fp === FALSE) {
                $err_msg = $msgarr['14012'][SCREEN_MSG];
                $log_msg = $msgarr['14012'][LOG_MSG];
                print($err_msg);
                display_footer();
                result_log($logstr . ":NG:" .  $log_msg);
                exit(1);    
            } else {
                /* CSVեɹ */
                if (read_csvfile($fp, $logstr) === FALSE) {
                    fclose($fp);
                    print($err_msg);
                    display_footer();
                    result_log($logstr . ":NG:" .  $log_msg);
                    exit(1);    
                }
                fclose($fp);
            }
        }
    }
    display_footer();
}
/***********************************************************
 * ɽ
 **********************************************************/

print_csv_result();
