# prime/engine/engine-alphabet.rb
# $Id: engine-alphabet.rb,v 1.5 2003/12/09 07:49:51 komatsu Exp $
#
# Copyright (C) 2002 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.
#

require 'prime/engine/engine'
$engine_class_name = 'PrimeEngineAlphabet'

class PrimeEngineAlphabet < PrimeEngine
  def initialize
    super

    @name = "Alphabet engine"
    @id   = "alphabet"
    @description = "Alphabet engine"
  end

  private
  def lookup (input, method = :prefix)
    results = PrimeResult.new

    if input.original == input.original.upcase then
      results << PrimeCandidate.new(input.original.downcase, input.original,
				    17000, "̤θ") # ñ(ʸ)
    else
      results << PrimeCandidate.new(input.original.downcase, input.original,
				    9999, "̤θ") # ñ
    end
    ### FIXME: 㤦󥸥Ѥ.
    results << PrimeCandidate.new(input.base.downcase, input.base.katakana,
				  9999, "̤θ") # 
    results << PrimeCandidate.new(input.base.downcase, input.base,
				  9999, "̤θ") # Ҥ餬ʤʤ
    return results
  end
end
