/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menu;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.Menu;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.component.submenu.Submenu;
import org.primefaces.renderkit.CoreRenderer;

public class MenuRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Menu menu = (Menu)component;
        this.encodeScript(facesContext, menu);
        this.encodeMarkup(facesContext, menu);
    }

    private void encodeScript(FacesContext facesContext, Menu menu) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = menu.getClientId(facesContext);
        String menuVar = this.createUniqueWidgetVar(facesContext, (UIComponent)menu);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write(menuVar + " = new YAHOO.widget.Menu('" + clientId + "', {");
        if (menu.getPosition().equalsIgnoreCase("static")) {
            writer.write("position:'static'");
        } else if (menu.getPosition().equalsIgnoreCase("dynamic")) {
            writer.write("position:'dynamic'");
            if (menu.isVisible()) {
                writer.write(",visible:true");
            }
            if (!menu.isClickToHide()) {
                writer.write(",clicktohide:false");
            }
            if (menu.isKeepOpen()) {
                writer.write(",keepopen:true");
            }
            if (menu.getX() != -1) {
                writer.write(",x:" + menu.getX());
            }
            if (menu.getY() != -1) {
                writer.write(",y:" + menu.getY());
            }
            if (menu.isFixedCenter()) {
                writer.write(",fixedcenter:true");
            }
            if (!menu.isConstraintToViewport()) {
                writer.write(",constrainttoviewport:false");
            }
            if (menu.getShowDelay() != 250) {
                writer.write(",showdelay:" + menu.getShowDelay());
            }
            if (menu.getHideDelay() != 0) {
                writer.write(",hidedelay:" + menu.getHideDelay());
            }
            if (menu.getSubmenuHideDelay() != 250) {
                writer.write(",submenuhidedelay:" + menu.getSubmenuHideDelay());
            }
            if (menu.getContext() != null) {
                writer.write(",context:[" + menu.getContext() + "]");
            }
        }
        if (!menu.isAutoSubmenuDisplay()) {
            writer.write(",autosubmenudisplay:false");
        }
        if (!menu.getEffect().equals("NONE")) {
            writer.write(",effect: {effect: YAHOO.widget.ContainerEffect." + menu.getEffect());
            if (menu.getEffectDuration() != 0.25) {
                writer.write(",duration:" + menu.getEffectDuration() + "}");
            } else {
                writer.write(",duration: 0.25}");
            }
        }
        writer.write("});\n");
        writer.write(menuVar + ".render();\n");
        writer.write("});\n");
        writer.endElement("script");
    }

    private void encodeMarkup(FacesContext facesContext, Menu menu) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = menu.getClientId(facesContext);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)"yuimenu", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"bd", null);
        if (menu.isTiered()) {
            this.renderTieredMenu(facesContext, menu);
        } else {
            this.renderRegularMenu(facesContext, menu);
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    private void renderTieredMenu(FacesContext facesContext, Menu menu) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        List submenus = menu.getChildren();
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"first-of-type", null);
        for (int i = 0; i < submenus.size(); ++i) {
            Submenu submenu = (Submenu)((Object)submenus.get(i));
            this.encodeTieredSubmenu(facesContext, submenu);
        }
        writer.endElement("ul");
    }

    private void renderRegularMenu(FacesContext facesContext, Menu menu) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        List submenus = menu.getChildren();
        for (int i = 0; i < submenus.size(); ++i) {
            String defaultTitleStyleClass;
            Submenu submenu = (Submenu)((Object)submenus.get(i));
            if (!submenu.isRendered()) continue;
            writer.startElement("h6", null);
            String string = defaultTitleStyleClass = i == 0 ? "first-of-type" : null;
            if (submenu.getStyleClass() != null) {
                if (defaultTitleStyleClass != null) {
                    writer.writeAttribute("class", (Object)(defaultTitleStyleClass + " " + submenu.getStyleClass()), null);
                } else {
                    writer.writeAttribute("class", (Object)submenu.getStyleClass(), null);
                }
            } else if (defaultTitleStyleClass != null) {
                writer.writeAttribute("class", (Object)defaultTitleStyleClass, null);
            }
            if (submenu.getStyle() != null) {
                writer.writeAttribute("style", (Object)submenu.getStyle(), null);
            }
            if (submenu.getLabel() != null) {
                writer.write(submenu.getLabel());
            }
            writer.endElement("h6");
            writer.startElement("ul", null);
            if (i == 0) {
                writer.writeAttribute("class", (Object)"first-of-type", null);
            }
            this.encodeSubmenuItems(facesContext, submenu);
            writer.endElement("ul");
        }
    }

    private void encodeTieredSubmenu(FacesContext facesContext, Submenu submenu) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String styleClass = submenu.getStyleClass() == null ? "yuimenuitemlabel" : "yuimenuitemlabel " + submenu.getStyleClass();
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)"yuimenuitem", null);
        writer.startElement("a", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (submenu.getLabel() != null) {
            writer.write(submenu.getLabel());
        }
        writer.endElement("a");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"yuimenu", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"bd", null);
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"first-of-type", null);
        this.encodeSubmenuItems(facesContext, submenu);
        writer.endElement("ul");
        writer.endElement("li");
    }

    private void encodeSubmenuItems(FacesContext facesContext, Submenu submenu) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (UIComponent child : submenu.getChildren()) {
            if (child instanceof MenuItem && child.isRendered()) {
                MenuItem menuItem = (MenuItem)child;
                String styleClass = menuItem.getStyleClass() == null ? "yuimenuitem" : "yuimenuitem " + menuItem.getStyleClass();
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"yuimenuitem", null);
                writer.startElement("a", null);
                writer.writeAttribute("href", (Object)menuItem.getUrl(), null);
                writer.writeAttribute("class", (Object)styleClass, null);
                if (menuItem.getStyle() != null) {
                    writer.writeAttribute("style", (Object)menuItem.getStyle(), null);
                }
                if (menuItem.getTarget() != null) {
                    writer.writeAttribute("target", (Object)menuItem.getTarget(), null);
                }
                if (menuItem.getOnclick() != null) {
                    writer.writeAttribute("onclick", (Object)menuItem.getOnclick(), null);
                }
                if (menuItem.getLabel() != null) {
                    writer.write(menuItem.getLabel());
                }
                writer.endElement("a");
                writer.endElement("li");
                continue;
            }
            if (!(child instanceof Submenu) || !child.isRendered()) continue;
            this.encodeTieredSubmenu(facesContext, (Submenu)child);
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

