/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.message;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.message.Message;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class MessageRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Message message = (Message)component;
        String forComponentClientId = ComponentUtils.findComponentById(facesContext, (UIComponent)facesContext.getViewRoot(), message.getFor()).getClientId(facesContext);
        Iterator msgs = facesContext.getMessages(forComponentClientId);
        FacesMessage msg = msgs.hasNext() ? (FacesMessage)msgs.next() : null;
        writer.startElement("span", (UIComponent)message);
        writer.writeAttribute("id", (Object)message.getClientId(facesContext), null);
        if (msg != null) {
            FacesMessage.Severity severity = msg.getSeverity();
            String severityKey = null;
            if (severity.equals(FacesMessage.SEVERITY_ERROR)) {
                severityKey = "error";
            } else if (severity.equals(FacesMessage.SEVERITY_INFO)) {
                severityKey = "info";
            } else if (severity.equals(FacesMessage.SEVERITY_WARN)) {
                severityKey = "warn";
            } else if (severity.equals(FacesMessage.SEVERITY_FATAL)) {
                severityKey = "fatal";
            }
            writer.writeAttribute("class", (Object)("pf-message-" + severityKey), null);
            if (message.isShowSummary()) {
                this.encodeMessageText(writer, msg.getSummary(), severityKey + "-summary");
            }
            if (message.isShowDetail()) {
                this.encodeMessageText(writer, msg.getDetail(), severityKey + "-detail");
            }
        }
        writer.endElement("span");
    }

    private void encodeMessageText(ResponseWriter writer, String text, String severity) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("pf-message-" + severity), null);
        writer.write(text);
        writer.endElement("span");
    }
}

