/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.password;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.password.Password;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class PasswordRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        Password password = (Password)component;
        String clientId = password.getClientId(facesContext);
        String submittedValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(clientId);
        password.setSubmittedValue(submittedValue);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Password password = (Password)component;
        this.encodeScript(facesContext, password);
        this.encodeMarkup(facesContext, password);
    }

    private void encodeScript(FacesContext facesContext, Password password) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = password.getClientId(facesContext);
        String var = this.createUniqueWidgetVar(facesContext, (UIComponent)password);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write(var + " = new PrimeFaces.widget.Password('" + clientId + "', {");
        writer.write("length:" + password.getMinLength());
        if (password.isInline()) {
            writer.write(",flat:true");
        }
        if (password.getLevel() != 1) {
            writer.write(",type: " + password.getLevel());
        }
        if (password.getPromptLabel() != null) {
            writer.write(",promptLabel:'" + password.getPromptLabel() + "'");
        }
        if (password.getWeakLabel() != null) {
            writer.write(",weakLabel:'" + password.getWeakLabel() + "'");
        }
        if (password.getGoodLabel() != null) {
            writer.write(",goodLabel:'" + password.getGoodLabel() + "'");
        }
        if (password.getStrongLabel() != null) {
            writer.write(",strongLabel:'" + password.getStrongLabel() + "'");
        }
        if (password.getOnshow() != null) {
            writer.write(",onShow:" + password.getOnshow());
        }
        if (password.getOnhide() != null) {
            writer.write(",onHide:" + password.getOnhide());
        }
        writer.write("});});");
        writer.endElement("script");
    }

    private void encodeMarkup(FacesContext facesContext, Password password) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = password.getClientId(facesContext);
        writer.startElement("input", (UIComponent)password);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)"password", null);
        writer.writeAttribute("value", (Object)ComponentUtils.getStringValueToRender(facesContext, (UIComponent)password), null);
        this.renderPassThruAttributes(facesContext, (UIComponent)password, HTML.INPUT_TEXT_ATTRS);
        writer.endElement("input");
    }
}

