/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.stack;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.stack.Stack;
import org.primefaces.component.stack.StackItem;
import org.primefaces.renderkit.CoreRenderer;

public class StackRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Stack stack = (Stack)component;
        this.encodeScript(facesContext, stack);
        this.encodeMarkup(facesContext, stack);
    }

    private void encodeScript(FacesContext facesContext, Stack stack) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = stack.getClientId(facesContext);
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)stack);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write(widgetVar + " = new PrimeFaces.widget.Stack('" + clientId + "', {");
        writer.write("openSpeed:" + stack.getOpenSpeed());
        writer.write(",closeSpeed:" + stack.getCloseSpeed());
        writer.write("});\n");
        writer.write("});");
        writer.endElement("script");
    }

    private void encodeMarkup(FacesContext facesContext, Stack stack) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = stack.getClientId(facesContext);
        writer.startElement("div", (UIComponent)stack);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)"pf-stack", null);
        writer.startElement("img", null);
        writer.writeAttribute("src", (Object)this.getResourceURL(facesContext, stack.getIcon()), null);
        writer.endElement("img");
        writer.startElement("ul", null);
        writer.writeAttribute("id", (Object)(clientId + "_stack"), "id");
        for (UIComponent child : stack.getChildren()) {
            if (!child.isRendered()) continue;
            StackItem item = (StackItem)child;
            writer.startElement("li", null);
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)item.getUrl(), null);
            if (item.getOnclick() != null) {
                writer.writeAttribute("onclick", (Object)item.getOnclick(), null);
            }
            writer.startElement("span", null);
            writer.write(item.getLabel());
            writer.endElement("span");
            writer.startElement("img", null);
            writer.writeAttribute("src", (Object)this.getResourceURL(facesContext, item.getIcon()), null);
            writer.endElement("img");
            writer.endElement("a");
            writer.endElement("li");
            writer.write("\n");
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

