/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tooltip;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.tooltip.Tooltip;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ArrayUtils;
import org.primefaces.util.ComponentUtils;

public class TooltipRenderer
extends CoreRenderer {
    private static String[] definedStyles = new String[]{"cream", "dark", "green", "light", "red", "blue"};

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Tooltip tooltip = (Tooltip)component;
        this.encodeScript(facesContext, tooltip);
    }

    private void encodeScript(FacesContext facesContext, Tooltip tooltip) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String var = this.createUniqueWidgetVar(facesContext, (UIComponent)tooltip);
        boolean global = tooltip.isGlobal();
        String forComponent = null;
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        if (!global) {
            forComponent = tooltip.getParent().getClientId(facesContext);
            writer.write("PrimeFaces.onContentReady('" + forComponent + "', function() {\n");
        }
        writer.write(var + " = new PrimeFaces.widget.Tooltip({");
        writer.write("global:" + global);
        if (!global) {
            writer.write(",forComponent:'" + forComponent + "'");
            writer.write(",content:'");
            if (tooltip.getValue() == null) {
                this.renderChildren(facesContext, (UIComponent)tooltip);
            } else {
                writer.write(ComponentUtils.getStringValueToRender(facesContext, (UIComponent)tooltip).replaceAll("'", "\\\\'"));
            }
            writer.write("'");
        }
        writer.write(",show:{when:{event:'" + tooltip.getShowEvent() + "'}, delay:" + tooltip.getShowDelay() + ", effect:{length:" + tooltip.getShowEffectLength() + ", type: '" + tooltip.getShowEffect() + "'}}");
        writer.write(",hide:{when:{event:'" + tooltip.getHideEvent() + "'}, delay:" + tooltip.getHideDelay() + ", effect:{length:" + tooltip.getHideEffectLength() + ", type: '" + tooltip.getHideEffect() + "'}}");
        writer.write(",position: {corner:{");
        writer.write("target:'" + tooltip.getTargetPosition() + "'");
        writer.write(",tooltip:'" + tooltip.getPosition() + "'");
        writer.write("}}");
        String style = tooltip.getStyle();
        if (ArrayUtils.contains(definedStyles, style)) {
            writer.write(",style:{name:'" + style + "'}");
        } else {
            writer.write(",style:" + style + "\n");
        }
        writer.write("});\n");
        if (!global) {
            writer.write("});\n");
        }
        writer.endElement("script");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

