/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.rating;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.rating.Rating;
import org.primefaces.event.RateEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class RatingRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        Rating rating = (Rating)component;
        String clientId = rating.getClientId(facesContext);
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        boolean isRateEvent = params.containsKey(clientId);
        if (isRateEvent) {
            String rateValue = (String)params.get("rating");
            if (rateValue.equals("")) {
                rating.queueEvent(new RateEvent((UIComponent)rating, null));
            } else {
                rating.queueEvent(new RateEvent((UIComponent)rating, Double.valueOf(rateValue)));
            }
        } else {
            String regularValue = (String)params.get(clientId + "_input");
            rating.setSubmittedValue(regularValue);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Rating rating = (Rating)component;
        this.encodeScript(facesContext, rating);
        this.encodeMarkup(facesContext, rating);
    }

    private void encodeScript(FacesContext facesContext, Rating rating) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = rating.getClientId(facesContext);
        String ratingVar = this.createUniqueWidgetVar(facesContext, (UIComponent)rating);
        String formClientId = null;
        UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)rating);
        if (form == null) {
            throw new FacesException("Rating:" + clientId + " needs to be enclosed in a form when using an rateListener");
        }
        formClientId = form.getClientId(facesContext);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write(ratingVar + " = new PrimeFaces.widget.Rating('" + clientId + "'");
        writer.write(",{");
        if (rating.getRateListener() != null) {
            writer.write("hasRateListener:true");
            writer.write(",formClientId:'" + formClientId + "'");
            writer.write(",actionURL:'" + this.getActionURL(facesContext) + "'");
            if (rating.getUpdate() != null) {
                writer.write(",update:'" + rating.getUpdate() + "'");
            }
        }
        writer.write("});\n");
        writer.write("});");
        writer.endElement("script");
    }

    private void encodeMarkup(FacesContext facesContext, Rating rating) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = rating.getClientId(facesContext);
        Object value = rating.getValue();
        if (value != null && !(value instanceof Double)) {
            throw new FacesException("Rating component('" + clientId + "')'s value must be of type java.lang.Double");
        }
        Double ratingValue = (Double)value;
        writer.startElement("span", (UIComponent)rating);
        writer.writeAttribute("id", (Object)clientId, "id");
        for (int i = 1; i <= rating.getStars(); ++i) {
            writer.startElement("input", null);
            writer.writeAttribute("name", (Object)(clientId + "_input"), null);
            writer.writeAttribute("type", (Object)"radio", null);
            writer.writeAttribute("value", (Object)i, null);
            writer.writeAttribute("class", (Object)"pf-rating-star", null);
            if (ratingValue != null && ratingValue.intValue() == i) {
                writer.writeAttribute("checked", (Object)"checked", null);
            }
            if (rating.isDisabled()) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            writer.endElement("input");
        }
        writer.endElement("span");
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        String value = (String)submittedValue;
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException exception) {
            FacesMessage msg = new FacesMessage(FacesMessage.SEVERITY_ERROR, "Conversion error", submittedValue + " is not a valid value for " + component.getClientId(facesContext));
            throw new ConverterException(msg);
        }
    }
}

