/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tree;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletResponse;
import org.primefaces.component.tree.Tree;
import org.primefaces.event.NodeCollapseEvent;
import org.primefaces.event.NodeExpandEvent;
import org.primefaces.event.NodeSelectEvent;
import org.primefaces.model.TreeExplorer;
import org.primefaces.model.TreeExplorerImpl;
import org.primefaces.model.TreeModel;
import org.primefaces.model.TreeNode;
import org.primefaces.model.TreeNodeEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.util.ComponentUtils;

public class TreeRenderer
extends CoreRenderer
implements PartialRenderer {
    private TreeExplorer treeExplorer = new TreeExplorerImpl();

    public void decode(FacesContext facesContext, UIComponent component) {
        Tree tree = (Tree)component;
        String clientId = tree.getClientId(facesContext);
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId)) {
            String rowKey = (String)params.get(clientId + "_rowKey");
            String event = (String)params.get(clientId + "_event");
            TreeNode root = (TreeNode)tree.getValue();
            TreeNode currentNode = this.treeExplorer.findTreeNode(rowKey, new TreeModel(root));
            switch (TreeNodeEvent.valueOf(event)) {
                case SELECT: {
                    tree.queueEvent(new NodeSelectEvent((UIComponent)tree, currentNode));
                    break;
                }
                case EXPAND: {
                    currentNode.setExpanded(true);
                    tree.queueEvent(new NodeExpandEvent((UIComponent)tree, currentNode));
                    break;
                }
                case COLLAPSE: {
                    currentNode.setExpanded(false);
                    tree.queueEvent(new NodeCollapseEvent((UIComponent)tree, currentNode));
                }
            }
        }
    }

    public void encodePartially(FacesContext facesContext, UIComponent component) throws IOException {
        Tree tree = (Tree)component;
        ResponseWriter writer = facesContext.getResponseWriter();
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = tree.getClientId(facesContext);
        TreeNode root = (TreeNode)tree.getValue();
        String rowKey = (String)params.get(clientId + "_rowKey");
        TreeNode currentNode = this.treeExplorer.findTreeNode(rowKey, new TreeModel(root));
        int rowIndex = 0;
        ServletResponse response = (ServletResponse)facesContext.getExternalContext().getResponse();
        response.setContentType("text/xml");
        writer.write("<nodes>");
        for (TreeNode child : currentNode.getChildren()) {
            writer.write("<node>");
            writer.write("<label>" + child.toString() + "</label>");
            writer.write("<rowKey>" + rowKey + "." + rowIndex + "</rowKey>");
            writer.write("<isLeaf>" + child.isLeaf() + "</isLeaf>");
            writer.write("</node>");
            ++rowIndex;
        }
        writer.write("</nodes>");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Tree tree = (Tree)component;
        this.encodeTreeWidget(facesContext, tree);
        this.encodeTreeMarkup(facesContext, tree);
    }

    protected void encodeTreeWidget(FacesContext facesContext, Tree tree) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = tree.getClientId(facesContext);
        String formClientId = null;
        String treeVar = this.createUniqueWidgetVar(facesContext, (UIComponent)tree);
        TreeNode root = (TreeNode)tree.getValue();
        UIComponent parentForm = ComponentUtils.findParentForm(facesContext, (UIComponent)tree);
        if (parentForm == null) {
            throw new FacesException("Tree:" + clientId + " needs to be enclosed in a form");
        }
        formClientId = parentForm.getClientId(facesContext);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write(treeVar + " = new PrimeFaces.widget.TreeView('" + clientId + "_container', [\n");
        int rowIndex = 0;
        Iterator<TreeNode> iterator = root.getChildren().iterator();
        while (iterator.hasNext()) {
            this.encodeTreeNode(facesContext, tree, iterator.next(), String.valueOf(rowIndex));
            ++rowIndex;
            if (!iterator.hasNext()) continue;
            writer.write(",");
        }
        writer.write("],{\n");
        writer.write("toggleMode:'" + tree.getToggleMode() + "'");
        if (!this.isClientToggling(tree)) {
            writer.write(",clientId:'" + clientId + "'");
            writer.write(",actionURL:'" + this.getActionURL(facesContext) + "'");
            writer.write(",rowKeyFieldId:'" + clientId + "_rowKey'");
            writer.write(",eventFieldId:'" + clientId + "_event'");
            writer.write(",formClientId:'" + formClientId + "'");
            writer.write(",cache:" + tree.isCache());
        }
        if (tree.getOnNodeClick() != null) {
            writer.write(",onNodeClick:" + tree.getOnNodeClick());
        }
        writer.write("\n});\n");
        if (tree.getExpandAnim() != null) {
            writer.write(treeVar + ".setExpandAnim(YAHOO.widget.TVAnim." + tree.getExpandAnim() + ");\n");
        }
        if (tree.getCollapseAnim() != null) {
            writer.write(treeVar + ".setCollapseAnim(YAHOO.widget.TVAnim." + tree.getCollapseAnim() + ");\n");
        }
        writer.write(treeVar + ".render();\n");
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeTreeNode(FacesContext facesContext, Tree tree, TreeNode node, String rowKey) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        int rowIndex = 0;
        if (!this.isPostBack() && tree.isExpanded()) {
            node.setExpanded(true);
        }
        writer.write("{type:'text', label:'" + node.toString() + "', rowKey:'" + rowKey + "'");
        if (node.isLeaf()) {
            writer.write(",isLeaf:true");
        }
        if (node.isExpanded()) {
            writer.write(",expanded:true");
        }
        if (this.isClientToggling(tree) && !node.isLeaf()) {
            writer.write(",children:[");
            Iterator<TreeNode> iterator = node.getChildren().iterator();
            while (iterator.hasNext()) {
                String childRowKey = rowKey + "." + rowIndex;
                this.encodeTreeNode(facesContext, tree, iterator.next(), childRowKey);
                ++rowIndex;
                if (!iterator.hasNext()) continue;
                writer.write(",");
            }
            writer.write("]");
        }
        writer.write("}");
    }

    protected void encodeTreeMarkup(FacesContext facesContext, Tree tree) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = tree.getClientId(facesContext);
        writer.startElement("div", (UIComponent)tree);
        writer.writeAttribute("id", (Object)clientId, null);
        this.encodeHiddenInput(facesContext, clientId + "_rowKey");
        this.encodeHiddenInput(facesContext, clientId + "_event");
        writer.startElement("div", (UIComponent)tree);
        writer.writeAttribute("id", (Object)(clientId + "_container"), null);
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeHiddenInput(FacesContext facesContext, String id) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.endElement("input");
    }

    protected boolean isClientToggling(Tree tree) {
        String toggleMode = tree.getToggleMode();
        if (toggleMode == null) {
            return true;
        }
        return toggleMode.equalsIgnoreCase("client");
    }
}

