/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.resource.stream;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.primefaces.resource.stream.ResourceStreamer;

public class CSSResourceStreamer
implements ResourceStreamer {
    public boolean isAppropriateStreamer(String mimeType) {
        return mimeType != null && mimeType.equals("text/css");
    }

    public void stream(HttpServletRequest request, HttpServletResponse response, InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
        String line = null;
        while (null != (line = reader.readLine())) {
            String parsedLine = this.replaceRelativeUrl(request.getContextPath(), line);
            writer.write(parsedLine + "\n");
        }
        writer.flush();
        writer.close();
    }

    public String replaceRelativeUrl(String contextPath, String input) {
        String replacement = contextPath + "/primefaces_resource/1.0.0.RC";
        Pattern pattern = Pattern.compile("primefaces_resource:url:");
        Matcher matcher = pattern.matcher(input);
        return matcher.replaceAll(replacement);
    }
}

