/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.touch.component.rowitem;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.touch.component.rowitem.RowItem;
import org.primefaces.util.ComponentUtils;

public class RowItemRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        RowItem rowItem;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.get((rowItem = (RowItem)component).getClientId(facesContext)) != null) {
            rowItem.queueEvent((FacesEvent)new ActionEvent((UIComponent)rowItem));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        RowItem rowItem = (RowItem)component;
        boolean isNavigation = rowItem.getView() != null;
        boolean isDynamic = rowItem.getUpdate() != null;
        writer.startElement("li", null);
        if (isNavigation) {
            writer.writeAttribute("class", (Object)"arrow", null);
        }
        if (rowItem.getValue() == null) {
            this.renderChildren(facesContext, (UIComponent)rowItem);
        } else {
            String href = isNavigation ? "javascript:none" : (rowItem.getUrl() != null ? rowItem.getUrl() : "#");
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)href, null);
            if (rowItem.getUrl() != null) {
                writer.writeAttribute("target", (Object)"_blank", null);
            }
            if (isNavigation) {
                if (isDynamic) {
                    UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)rowItem);
                    String ajaxRequest = this.getAjaxRequest(facesContext, rowItem, form.getClientId(facesContext));
                    writer.writeAttribute("onclick", (Object)ajaxRequest, null);
                } else {
                    writer.writeAttribute("onclick", (Object)("TouchFaces.goTo('" + rowItem.getView() + "','slide')"), null);
                }
            }
            if (rowItem.getValue() != null) {
                writer.write(rowItem.getValue().toString());
            }
            writer.endElement("a");
        }
        writer.endElement("li");
    }

    private String getAjaxRequest(FacesContext facesContext, RowItem item, String formClientId) {
        String clientId = item.getClientId(facesContext);
        StringBuilder req = new StringBuilder();
        req.append("PrimeFaces.ajax.AjaxRequest('");
        req.append(this.getActionURL(facesContext));
        req.append("',{");
        req.append("formClientId:'");
        req.append(formClientId);
        req.append("',");
        req.append("oncomplete:function(){");
        req.append("TouchFaces.goTo('");
        req.append(item.getView());
        req.append("','slide');}");
        req.append("},");
        req.append("'update=");
        if (item.getUpdate() != null) {
            req.append(item.getUpdate());
        } else {
            req.append(formClientId);
        }
        for (UIComponent component : item.getChildren()) {
            if (!(component instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)component;
            req.append("&");
            req.append(parameter.getName());
            req.append("=");
            req.append(parameter.getValue());
        }
        req.append("&");
        req.append(clientId);
        req.append("=");
        req.append(clientId);
        req.append("');");
        return req.toString();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

