/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.autocomplete;

import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.el.ValueExpression;
import javax.el.MethodExpression;
import javax.faces.render.Renderer;
import java.io.IOException;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.component.api.AjaxComponent;
import org.primefaces.resource.ResourceHolder;


public class AutoComplete extends UIInput implements AjaxComponent {


	public static final String COMPONENT_TYPE = "org.primefaces.component.AutoComplete";
	public static final String COMPONENT_FAMILY = "org.primefaces.component";
	private static final String DEFAULT_RENDERER = "org.primefaces.component.AutoCompleteRenderer";

	private java.lang.String _widgetVar;
	private javax.el.MethodExpression _completeMethod;
	private java.lang.String _var;
	private java.lang.String _itemLabel;
	private java.lang.Object _itemValue;
	private java.lang.Boolean _animHoriz;
	private java.lang.Boolean _animVert;
	private java.lang.Double _animSpeed;
	private java.lang.Integer _maxResults;
	private java.lang.Integer _minQueryLength;
	private java.lang.Double _queryDelay;
	private java.lang.Boolean _autoHighlight;
	private java.lang.Boolean _useShadow;
	private java.lang.Boolean _typeAhead;
	private java.lang.Double _typeAheadDelay;
	public AutoComplete() {
		setRendererType(DEFAULT_RENDERER);
		ResourceHolder resourceHolder = getResourceHolder();
		if(resourceHolder != null) {
			resourceHolder.addResource("/yui/autocomplete/assets/skins/sam/autocomplete.css");
			resourceHolder.addResource("/yui/utilities/utilities.js");
			resourceHolder.addResource("/yui/datasource/datasource-min.js");
			resourceHolder.addResource("/yui/autocomplete/autocomplete-min.js");
			resourceHolder.addResource("/primefaces/core/core.js");
			resourceHolder.addResource("/primefaces/autocomplete/autocomplete.js");
		}
	}

	public String getFamily() {
		return COMPONENT_FAMILY;
	}

	public java.lang.String getWidgetVar() {
		if(_widgetVar != null )
			return _widgetVar;

		ValueExpression ve = getValueExpression("widgetVar");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setWidgetVar(java.lang.String _widgetVar) {
		this._widgetVar = _widgetVar;
	}

	public javax.el.MethodExpression getCompleteMethod() {
		return this._completeMethod;
	}

	public void setCompleteMethod(javax.el.MethodExpression _completeMethod) {
		this._completeMethod = _completeMethod;
	}
	public java.lang.String getVar() {
		if(_var != null )
			return _var;

		ValueExpression ve = getValueExpression("var");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setVar(java.lang.String _var) {
		this._var = _var;
	}

	public java.lang.String getItemLabel() {
		if(_itemLabel != null )
			return _itemLabel;

		ValueExpression ve = getValueExpression("itemLabel");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setItemLabel(java.lang.String _itemLabel) {
		this._itemLabel = _itemLabel;
	}

	public java.lang.Object getItemValue() {
		if(_itemValue != null )
			return _itemValue;

		ValueExpression ve = getValueExpression("itemValue");
		return ve != null ? (java.lang.Object) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setItemValue(java.lang.Object _itemValue) {
		this._itemValue = _itemValue;
	}

	public boolean isAnimHoriz() {
		if(_animHoriz != null )
			return _animHoriz;

		ValueExpression ve = getValueExpression("animHoriz");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setAnimHoriz(boolean _animHoriz) {
		this._animHoriz = _animHoriz;
	}

	public boolean isAnimVert() {
		if(_animVert != null )
			return _animVert;

		ValueExpression ve = getValueExpression("animVert");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : true;
	}
	public void setAnimVert(boolean _animVert) {
		this._animVert = _animVert;
	}

	public double getAnimSpeed() {
		if(_animSpeed != null )
			return _animSpeed;

		ValueExpression ve = getValueExpression("animSpeed");
		return ve != null ? (java.lang.Double) ve.getValue(getFacesContext().getELContext())  : 0.3;
	}
	public void setAnimSpeed(double _animSpeed) {
		this._animSpeed = _animSpeed;
	}

	public int getMaxResults() {
		if(_maxResults != null )
			return _maxResults;

		ValueExpression ve = getValueExpression("maxResults");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 10;
	}
	public void setMaxResults(int _maxResults) {
		this._maxResults = _maxResults;
	}

	public int getMinQueryLength() {
		if(_minQueryLength != null )
			return _minQueryLength;

		ValueExpression ve = getValueExpression("minQueryLength");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 1;
	}
	public void setMinQueryLength(int _minQueryLength) {
		this._minQueryLength = _minQueryLength;
	}

	public double getQueryDelay() {
		if(_queryDelay != null )
			return _queryDelay;

		ValueExpression ve = getValueExpression("queryDelay");
		return ve != null ? (java.lang.Double) ve.getValue(getFacesContext().getELContext())  : 0.2;
	}
	public void setQueryDelay(double _queryDelay) {
		this._queryDelay = _queryDelay;
	}

	public boolean isAutoHighlight() {
		if(_autoHighlight != null )
			return _autoHighlight;

		ValueExpression ve = getValueExpression("autoHighlight");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : true;
	}
	public void setAutoHighlight(boolean _autoHighlight) {
		this._autoHighlight = _autoHighlight;
	}

	public boolean isUseShadow() {
		if(_useShadow != null )
			return _useShadow;

		ValueExpression ve = getValueExpression("useShadow");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setUseShadow(boolean _useShadow) {
		this._useShadow = _useShadow;
	}

	public boolean isTypeAhead() {
		if(_typeAhead != null )
			return _typeAhead;

		ValueExpression ve = getValueExpression("typeAhead");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setTypeAhead(boolean _typeAhead) {
		this._typeAhead = _typeAhead;
	}

	public double getTypeAheadDelay() {
		if(_typeAheadDelay != null )
			return _typeAheadDelay;

		ValueExpression ve = getValueExpression("typeAheadDelay");
		return ve != null ? (java.lang.Double) ve.getValue(getFacesContext().getELContext())  : 0.5;
	}
	public void setTypeAheadDelay(double _typeAheadDelay) {
		this._typeAheadDelay = _typeAheadDelay;
	}


	protected FacesContext getFacesContext() {
		return FacesContext.getCurrentInstance();
	}

	public void encodePartially(FacesContext facesContext) throws IOException {
		Renderer renderer = getRenderer(facesContext);

		if(renderer instanceof PartialRenderer) {
			((PartialRenderer)renderer).encodePartially(facesContext, this);
		}
	}
	public Object saveState(FacesContext context) {
		Object values[] = new Object[16];
		values[0] = super.saveState(context);
		values[1] = _widgetVar;
		values[2] = _completeMethod;
		values[3] = _var;
		values[4] = _itemLabel;
		values[5] = _itemValue;
		values[6] = _animHoriz;
		values[7] = _animVert;
		values[8] = _animSpeed;
		values[9] = _maxResults;
		values[10] = _minQueryLength;
		values[11] = _queryDelay;
		values[12] = _autoHighlight;
		values[13] = _useShadow;
		values[14] = _typeAhead;
		values[15] = _typeAheadDelay;
		return ((Object) values);
	}
	public void restoreState(FacesContext context, Object state) {
		Object values[] = (Object[]) state;
		super.restoreState(context, values[0]);
		_widgetVar = (java.lang.String) values[1];
		_completeMethod = (javax.el.MethodExpression) values[2];
		_var = (java.lang.String) values[3];
		_itemLabel = (java.lang.String) values[4];
		_itemValue = (java.lang.Object) values[5];
		_animHoriz = (java.lang.Boolean) values[6];
		_animVert = (java.lang.Boolean) values[7];
		_animSpeed = (java.lang.Double) values[8];
		_maxResults = (java.lang.Integer) values[9];
		_minQueryLength = (java.lang.Integer) values[10];
		_queryDelay = (java.lang.Double) values[11];
		_autoHighlight = (java.lang.Boolean) values[12];
		_useShadow = (java.lang.Boolean) values[13];
		_typeAhead = (java.lang.Boolean) values[14];
		_typeAheadDelay = (java.lang.Double) values[15];
	}

	protected ResourceHolder getResourceHolder() {
		FacesContext facesContext = getFacesContext();
		if(facesContext == null)
			return null;

		ValueExpression ve = facesContext.getApplication().getExpressionFactory().createValueExpression(facesContext.getELContext(), "#{primeFacesResourceHolder}", ResourceHolder.class);

		return (ResourceHolder) ve.getValue(facesContext.getELContext());
	}
}