/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.wizard;

import javax.faces.webapp.UIComponentELTag;
import javax.faces.component.UIComponent;

public class WizardTag extends UIComponentELTag {

	private javax.el.ValueExpression _widgetVar;
	private javax.el.ValueExpression _step;
	private javax.el.ValueExpression _effect;
	private javax.el.ValueExpression _width;
	private javax.el.ValueExpression _height;
	private javax.el.ValueExpression _style;
	private javax.el.ValueExpression _styleClass;
	private javax.el.ValueExpression _speed;
	private javax.el.ValueExpression _customUI;

	public void release(){
		super.release();
		this._widgetVar = null;
		this._step = null;
		this._effect = null;
		this._width = null;
		this._height = null;
		this._style = null;
		this._styleClass = null;
		this._speed = null;
		this._customUI = null;
	}

	protected void setProperties(UIComponent comp){
		super.setProperties(comp);

		org.primefaces.component.wizard.Wizard component = null;
		try {
			component = (org.primefaces.component.wizard.Wizard) comp;
		} catch(ClassCastException cce) {
			throw new IllegalStateException("Component " + component.toString() + " not expected type.");
		}

		if(_widgetVar != null) {
			component.setValueExpression("widgetVar", _widgetVar);
		}
		if(_step != null) {
			component.setValueExpression("step", _step);
		}
		if(_effect != null) {
			component.setValueExpression("effect", _effect);
		}
		if(_width != null) {
			component.setValueExpression("width", _width);
		}
		if(_height != null) {
			component.setValueExpression("height", _height);
		}
		if(_style != null) {
			component.setValueExpression("style", _style);
		}
		if(_styleClass != null) {
			component.setValueExpression("styleClass", _styleClass);
		}
		if(_speed != null) {
			component.setValueExpression("speed", _speed);
		}
		if(_customUI != null) {
			component.setValueExpression("customUI", _customUI);
		}
	}

	public String getComponentType() {
		return Wizard.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return "org.primefaces.component.WizardRenderer";
	}

	public void setWidgetVar(javax.el.ValueExpression expression){
		this._widgetVar = expression;
	}

	public void setStep(javax.el.ValueExpression expression){
		this._step = expression;
	}

	public void setEffect(javax.el.ValueExpression expression){
		this._effect = expression;
	}

	public void setWidth(javax.el.ValueExpression expression){
		this._width = expression;
	}

	public void setHeight(javax.el.ValueExpression expression){
		this._height = expression;
	}

	public void setStyle(javax.el.ValueExpression expression){
		this._style = expression;
	}

	public void setStyleClass(javax.el.ValueExpression expression){
		this._styleClass = expression;
	}

	public void setSpeed(javax.el.ValueExpression expression){
		this._speed = expression;
	}

	public void setCustomUI(javax.el.ValueExpression expression){
		this._customUI = expression;
	}

}