/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.confirmdialog;

import javax.faces.webapp.UIComponentELTag;
import javax.faces.component.UIComponent;

public class ConfirmDialogTag extends UIComponentELTag {

	private javax.el.ValueExpression _message;
	private javax.el.ValueExpression _header;
	private javax.el.ValueExpression _yesLabel;
	private javax.el.ValueExpression _noLabel;
	private javax.el.ValueExpression _severity;
	private javax.el.ValueExpression _close;
	private javax.el.ValueExpression _draggable;
	private javax.el.ValueExpression _underlay;
	private javax.el.ValueExpression _modal;
	private javax.el.ValueExpression _visible;
	private javax.el.ValueExpression _constrainToViewport;
	private javax.el.ValueExpression _x;
	private javax.el.ValueExpression _y;
	private javax.el.ValueExpression _fixedCenter;
	private javax.el.ValueExpression _width;
	private javax.el.ValueExpression _height;
	private javax.el.ValueExpression _effect;
	private javax.el.ValueExpression _effectDuration;

	public void release(){
		super.release();
		this._message = null;
		this._header = null;
		this._yesLabel = null;
		this._noLabel = null;
		this._severity = null;
		this._close = null;
		this._draggable = null;
		this._underlay = null;
		this._modal = null;
		this._visible = null;
		this._constrainToViewport = null;
		this._x = null;
		this._y = null;
		this._fixedCenter = null;
		this._width = null;
		this._height = null;
		this._effect = null;
		this._effectDuration = null;
	}

	protected void setProperties(UIComponent comp){
		super.setProperties(comp);

		org.primefaces.component.confirmdialog.ConfirmDialog component = null;
		try {
			component = (org.primefaces.component.confirmdialog.ConfirmDialog) comp;
		} catch(ClassCastException cce) {
			throw new IllegalStateException("Component " + component.toString() + " not expected type.");
		}

		if(_message != null) {
			component.setValueExpression("message", _message);
		}
		if(_header != null) {
			component.setValueExpression("header", _header);
		}
		if(_yesLabel != null) {
			component.setValueExpression("yesLabel", _yesLabel);
		}
		if(_noLabel != null) {
			component.setValueExpression("noLabel", _noLabel);
		}
		if(_severity != null) {
			component.setValueExpression("severity", _severity);
		}
		if(_close != null) {
			component.setValueExpression("close", _close);
		}
		if(_draggable != null) {
			component.setValueExpression("draggable", _draggable);
		}
		if(_underlay != null) {
			component.setValueExpression("underlay", _underlay);
		}
		if(_modal != null) {
			component.setValueExpression("modal", _modal);
		}
		if(_visible != null) {
			component.setValueExpression("visible", _visible);
		}
		if(_constrainToViewport != null) {
			component.setValueExpression("constrainToViewport", _constrainToViewport);
		}
		if(_x != null) {
			component.setValueExpression("x", _x);
		}
		if(_y != null) {
			component.setValueExpression("y", _y);
		}
		if(_fixedCenter != null) {
			component.setValueExpression("fixedCenter", _fixedCenter);
		}
		if(_width != null) {
			component.setValueExpression("width", _width);
		}
		if(_height != null) {
			component.setValueExpression("height", _height);
		}
		if(_effect != null) {
			component.setValueExpression("effect", _effect);
		}
		if(_effectDuration != null) {
			component.setValueExpression("effectDuration", _effectDuration);
		}
	}

	public String getComponentType() {
		return ConfirmDialog.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return null;
	}

	public void setMessage(javax.el.ValueExpression expression){
		this._message = expression;
	}

	public void setHeader(javax.el.ValueExpression expression){
		this._header = expression;
	}

	public void setYesLabel(javax.el.ValueExpression expression){
		this._yesLabel = expression;
	}

	public void setNoLabel(javax.el.ValueExpression expression){
		this._noLabel = expression;
	}

	public void setSeverity(javax.el.ValueExpression expression){
		this._severity = expression;
	}

	public void setClose(javax.el.ValueExpression expression){
		this._close = expression;
	}

	public void setDraggable(javax.el.ValueExpression expression){
		this._draggable = expression;
	}

	public void setUnderlay(javax.el.ValueExpression expression){
		this._underlay = expression;
	}

	public void setModal(javax.el.ValueExpression expression){
		this._modal = expression;
	}

	public void setVisible(javax.el.ValueExpression expression){
		this._visible = expression;
	}

	public void setConstrainToViewport(javax.el.ValueExpression expression){
		this._constrainToViewport = expression;
	}

	public void setX(javax.el.ValueExpression expression){
		this._x = expression;
	}

	public void setY(javax.el.ValueExpression expression){
		this._y = expression;
	}

	public void setFixedCenter(javax.el.ValueExpression expression){
		this._fixedCenter = expression;
	}

	public void setWidth(javax.el.ValueExpression expression){
		this._width = expression;
	}

	public void setHeight(javax.el.ValueExpression expression){
		this._height = expression;
	}

	public void setEffect(javax.el.ValueExpression expression){
		this._effect = expression;
	}

	public void setEffectDuration(javax.el.ValueExpression expression){
		this._effectDuration = expression;
	}

}