/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.panel;

import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.el.ValueExpression;
import javax.el.MethodExpression;
import javax.faces.render.Renderer;
import java.io.IOException;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.resource.ResourceHolder;


public class Panel extends UIPanel {


	public static final String COMPONENT_TYPE = "org.primefaces.component.Panel";
	public static final String COMPONENT_FAMILY = "org.primefaces.component";
	private static final String DEFAULT_RENDERER = "org.primefaces.component.PanelRenderer";

	private java.lang.String _widgetVar;
	private java.lang.String _header;
	private java.lang.String _footer;
	private java.lang.Boolean _toggleable;
	private java.lang.Integer _toggleSpeed;
	private java.lang.String _style;
	private java.lang.String _styleClass;
	private java.lang.Boolean _collapsed;
	public Panel() {
		setRendererType(DEFAULT_RENDERER);
		ResourceHolder resourceHolder = getResourceHolder();
		if(resourceHolder != null) {
			resourceHolder.addResource("/primefaces/panel/panel.css");
			resourceHolder.addResource("/yui/utilities/utilities.js");
			resourceHolder.addResource("/jquery/jquery.js");
			resourceHolder.addResource("/primefaces/core/core.js");
			resourceHolder.addResource("/primefaces/panel/panel.js");
		}
	}

	public String getFamily() {
		return COMPONENT_FAMILY;
	}

	public java.lang.String getWidgetVar() {
		if(_widgetVar != null )
			return _widgetVar;

		ValueExpression ve = getValueExpression("widgetVar");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setWidgetVar(java.lang.String _widgetVar) {
		this._widgetVar = _widgetVar;
	}

	public java.lang.String getHeader() {
		if(_header != null )
			return _header;

		ValueExpression ve = getValueExpression("header");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setHeader(java.lang.String _header) {
		this._header = _header;
	}

	public java.lang.String getFooter() {
		if(_footer != null )
			return _footer;

		ValueExpression ve = getValueExpression("footer");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setFooter(java.lang.String _footer) {
		this._footer = _footer;
	}

	public boolean isToggleable() {
		if(_toggleable != null )
			return _toggleable;

		ValueExpression ve = getValueExpression("toggleable");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setToggleable(boolean _toggleable) {
		this._toggleable = _toggleable;
	}

	public int getToggleSpeed() {
		if(_toggleSpeed != null )
			return _toggleSpeed;

		ValueExpression ve = getValueExpression("toggleSpeed");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 1000;
	}
	public void setToggleSpeed(int _toggleSpeed) {
		this._toggleSpeed = _toggleSpeed;
	}

	public java.lang.String getStyle() {
		if(_style != null )
			return _style;

		ValueExpression ve = getValueExpression("style");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setStyle(java.lang.String _style) {
		this._style = _style;
	}

	public java.lang.String getStyleClass() {
		if(_styleClass != null )
			return _styleClass;

		ValueExpression ve = getValueExpression("styleClass");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setStyleClass(java.lang.String _styleClass) {
		this._styleClass = _styleClass;
	}

	public boolean isCollapsed() {
		if(_collapsed != null )
			return _collapsed;

		ValueExpression ve = getValueExpression("collapsed");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setCollapsed(boolean _collapsed) {
		this._collapsed = _collapsed;
	}

	public static final String PANEL_CLASS = "pf-panel";
	public static final String PANEL_HEADER_CLASS = "pf-panel-hd";
	public static final String PANEL_TOGGLEABLE_HEADER_CLASS = "pf-panel-hd-toggleable";
	public static final String PANEL_BODY_CLASS = "pf-panel-bd";
	public static final String PANEL_FOOTER_CLASS = "pf-panel-ft";
	public static final String PANEL_TOGGLER_EXPANDED_CLASS = "pf-panel-toggler-expanded";
	public static final String PANEL_TOGGLER_COLLAPSED_CLASS = "pf-panel-toggler-collapsed";

	protected FacesContext getFacesContext() {
		return FacesContext.getCurrentInstance();
	}
	public Object saveState(FacesContext context) {
		Object values[] = new Object[9];
		values[0] = super.saveState(context);
		values[1] = _widgetVar;
		values[2] = _header;
		values[3] = _footer;
		values[4] = _toggleable;
		values[5] = _toggleSpeed;
		values[6] = _style;
		values[7] = _styleClass;
		values[8] = _collapsed;
		return ((Object) values);
	}
	public void restoreState(FacesContext context, Object state) {
		Object values[] = (Object[]) state;
		super.restoreState(context, values[0]);
		_widgetVar = (java.lang.String) values[1];
		_header = (java.lang.String) values[2];
		_footer = (java.lang.String) values[3];
		_toggleable = (java.lang.Boolean) values[4];
		_toggleSpeed = (java.lang.Integer) values[5];
		_style = (java.lang.String) values[6];
		_styleClass = (java.lang.String) values[7];
		_collapsed = (java.lang.Boolean) values[8];
	}

	protected ResourceHolder getResourceHolder() {
		FacesContext facesContext = getFacesContext();
		if(facesContext == null)
			return null;

		ValueExpression ve = facesContext.getApplication().getExpressionFactory().createValueExpression(facesContext.getELContext(), "#{primeFacesResourceHolder}", ResourceHolder.class);

		return (ResourceHolder) ve.getValue(facesContext.getELContext());
	}
}