/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.slider;

import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.el.ValueExpression;
import javax.el.MethodExpression;
import javax.faces.render.Renderer;
import java.io.IOException;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.resource.ResourceHolder;


public class Slider extends UIComponentBase {


	public static final String COMPONENT_TYPE = "org.primefaces.component.Slider";
	public static final String COMPONENT_FAMILY = "org.primefaces.component";
	private static final String DEFAULT_RENDERER = "org.primefaces.component.SliderRenderer";

	private java.lang.String _widgetVar;
	private java.lang.String _for;
	private java.lang.Integer _minValue;
	private java.lang.Integer _maxValue;
	private java.lang.String _thumbImage;
	private java.lang.Integer _tickMarks;
	private java.lang.Integer _size;
	private java.lang.Boolean _animate;
	private java.lang.String _type;
	public Slider() {
		setRendererType(DEFAULT_RENDERER);
		ResourceHolder resourceHolder = getResourceHolder();
		if(resourceHolder != null) {
			resourceHolder.addResource("/yui/slider/assets/skins/sam/slider.css");
			resourceHolder.addResource("/yui/utilities/utilities.js");
			resourceHolder.addResource("/yui/slider/slider-min.js");
			resourceHolder.addResource("/primefaces/core/core.js");
			resourceHolder.addResource("/primefaces/slider/slider.js");
		}
	}

	public String getFamily() {
		return COMPONENT_FAMILY;
	}

	public java.lang.String getWidgetVar() {
		if(_widgetVar != null )
			return _widgetVar;

		ValueExpression ve = getValueExpression("widgetVar");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setWidgetVar(java.lang.String _widgetVar) {
		this._widgetVar = _widgetVar;
	}

	public java.lang.String getFor() {
		if(_for != null )
			return _for;

		ValueExpression ve = getValueExpression("for");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setFor(java.lang.String _for) {
		this._for = _for;
	}

	public int getMinValue() {
		if(_minValue != null )
			return _minValue;

		ValueExpression ve = getValueExpression("minValue");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setMinValue(int _minValue) {
		this._minValue = _minValue;
	}

	public int getMaxValue() {
		if(_maxValue != null )
			return _maxValue;

		ValueExpression ve = getValueExpression("maxValue");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setMaxValue(int _maxValue) {
		this._maxValue = _maxValue;
	}

	public java.lang.String getThumbImage() {
		if(_thumbImage != null )
			return _thumbImage;

		ValueExpression ve = getValueExpression("thumbImage");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setThumbImage(java.lang.String _thumbImage) {
		this._thumbImage = _thumbImage;
	}

	public int getTickMarks() {
		if(_tickMarks != null )
			return _tickMarks;

		ValueExpression ve = getValueExpression("tickMarks");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 1;
	}
	public void setTickMarks(int _tickMarks) {
		this._tickMarks = _tickMarks;
	}

	public int getSize() {
		if(_size != null )
			return _size;

		ValueExpression ve = getValueExpression("size");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 200;
	}
	public void setSize(int _size) {
		this._size = _size;
	}

	public boolean isAnimate() {
		if(_animate != null )
			return _animate;

		ValueExpression ve = getValueExpression("animate");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : true;
	}
	public void setAnimate(boolean _animate) {
		this._animate = _animate;
	}

	public java.lang.String getType() {
		if(_type != null )
			return _type;

		ValueExpression ve = getValueExpression("type");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : "horizontal";
	}
	public void setType(java.lang.String _type) {
		this._type = _type;
	}


	protected FacesContext getFacesContext() {
		return FacesContext.getCurrentInstance();
	}
	public Object saveState(FacesContext context) {
		Object values[] = new Object[10];
		values[0] = super.saveState(context);
		values[1] = _widgetVar;
		values[2] = _for;
		values[3] = _minValue;
		values[4] = _maxValue;
		values[5] = _thumbImage;
		values[6] = _tickMarks;
		values[7] = _size;
		values[8] = _animate;
		values[9] = _type;
		return ((Object) values);
	}
	public void restoreState(FacesContext context, Object state) {
		Object values[] = (Object[]) state;
		super.restoreState(context, values[0]);
		_widgetVar = (java.lang.String) values[1];
		_for = (java.lang.String) values[2];
		_minValue = (java.lang.Integer) values[3];
		_maxValue = (java.lang.Integer) values[4];
		_thumbImage = (java.lang.String) values[5];
		_tickMarks = (java.lang.Integer) values[6];
		_size = (java.lang.Integer) values[7];
		_animate = (java.lang.Boolean) values[8];
		_type = (java.lang.String) values[9];
	}

	protected ResourceHolder getResourceHolder() {
		FacesContext facesContext = getFacesContext();
		if(facesContext == null)
			return null;

		ValueExpression ve = facesContext.getApplication().getExpressionFactory().createValueExpression(facesContext.getELContext(), "#{primeFacesResourceHolder}", ResourceHolder.class);

		return (ResourceHolder) ve.getValue(facesContext.getELContext());
	}
}