/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.calendar;

import javax.faces.webapp.UIComponentELTag;
import javax.faces.component.UIComponent;

public class CalendarTag extends UIComponentELTag {

	private javax.el.ValueExpression _value;
	private javax.el.ValueExpression _converter;
	private javax.el.ValueExpression _immediate;
	private javax.el.ValueExpression _required;
	private javax.el.MethodExpression _validator;
	private javax.el.MethodExpression _valueChangeListener;
	private javax.el.ValueExpression _requiredMessage;
	private javax.el.ValueExpression _converterMessage;
	private javax.el.ValueExpression _validatorMessage;
	private javax.el.ValueExpression _widgetVar;
	private javax.el.ValueExpression _title;
	private javax.el.ValueExpression _mindate;
	private javax.el.ValueExpression _maxdate;
	private javax.el.ValueExpression _selection;
	private javax.el.ValueExpression _pages;
	private javax.el.ValueExpression _close;
	private javax.el.ValueExpression _mode;
	private javax.el.ValueExpression _pattern;
	private javax.el.ValueExpression _locale;
	private javax.el.ValueExpression _showWeekdays;
	private javax.el.ValueExpression _monthFormat;
	private javax.el.ValueExpression _weekdayFormat;
	private javax.el.ValueExpression _startWeekday;
	private javax.el.ValueExpression _popupIcon;
	private javax.el.ValueExpression _navigator;
	private javax.el.ValueExpression _pagedate;
	private javax.el.ValueExpression _timeZone;
	private javax.el.ValueExpression _showWeekHeader;
	private javax.el.ValueExpression _showWeekFooter;
	private javax.el.ValueExpression _readOnlyInputText;

	public void release(){
		super.release();
		this._value = null;
		this._converter = null;
		this._immediate = null;
		this._required = null;
		this._validator = null;
		this._valueChangeListener = null;
		this._requiredMessage = null;
		this._converterMessage = null;
		this._validatorMessage = null;
		this._widgetVar = null;
		this._title = null;
		this._mindate = null;
		this._maxdate = null;
		this._selection = null;
		this._pages = null;
		this._close = null;
		this._mode = null;
		this._pattern = null;
		this._locale = null;
		this._showWeekdays = null;
		this._monthFormat = null;
		this._weekdayFormat = null;
		this._startWeekday = null;
		this._popupIcon = null;
		this._navigator = null;
		this._pagedate = null;
		this._timeZone = null;
		this._showWeekHeader = null;
		this._showWeekFooter = null;
		this._readOnlyInputText = null;
	}

	protected void setProperties(UIComponent comp){
		super.setProperties(comp);

		org.primefaces.component.calendar.Calendar component = null;
		try {
			component = (org.primefaces.component.calendar.Calendar) comp;
		} catch(ClassCastException cce) {
			throw new IllegalStateException("Component " + component.toString() + " not expected type.");
		}

		if(_value != null) {
			component.setValueExpression("value", _value);
		}
		if(_converter != null) {
			component.setValueExpression("converter", _converter);
		}
		if(_immediate != null) {
			component.setValueExpression("immediate", _immediate);
		}
		if(_required != null) {
			component.setValueExpression("required", _required);
		}
		if(_validator != null) {
			component.addValidator(new javax.faces.validator.MethodExpressionValidator(_validator));
		}
		if(_valueChangeListener != null) {
			component.addValueChangeListener(new javax.faces.event.MethodExpressionValueChangeListener(_valueChangeListener));
		}
		if(_requiredMessage != null) {
			component.setValueExpression("requiredMessage", _requiredMessage);
		}
		if(_converterMessage != null) {
			component.setValueExpression("converterMessage", _converterMessage);
		}
		if(_validatorMessage != null) {
			component.setValueExpression("validatorMessage", _validatorMessage);
		}
		if(_widgetVar != null) {
			component.setValueExpression("widgetVar", _widgetVar);
		}
		if(_title != null) {
			component.setValueExpression("title", _title);
		}
		if(_mindate != null) {
			component.setValueExpression("mindate", _mindate);
		}
		if(_maxdate != null) {
			component.setValueExpression("maxdate", _maxdate);
		}
		if(_selection != null) {
			component.setValueExpression("selection", _selection);
		}
		if(_pages != null) {
			component.setValueExpression("pages", _pages);
		}
		if(_close != null) {
			component.setValueExpression("close", _close);
		}
		if(_mode != null) {
			component.setValueExpression("mode", _mode);
		}
		if(_pattern != null) {
			component.setValueExpression("pattern", _pattern);
		}
		if(_locale != null) {
			component.setValueExpression("locale", _locale);
		}
		if(_showWeekdays != null) {
			component.setValueExpression("showWeekdays", _showWeekdays);
		}
		if(_monthFormat != null) {
			component.setValueExpression("monthFormat", _monthFormat);
		}
		if(_weekdayFormat != null) {
			component.setValueExpression("weekdayFormat", _weekdayFormat);
		}
		if(_startWeekday != null) {
			component.setValueExpression("startWeekday", _startWeekday);
		}
		if(_popupIcon != null) {
			component.setValueExpression("popupIcon", _popupIcon);
		}
		if(_navigator != null) {
			component.setValueExpression("navigator", _navigator);
		}
		if(_pagedate != null) {
			component.setValueExpression("pagedate", _pagedate);
		}
		if(_timeZone != null) {
			component.setValueExpression("timeZone", _timeZone);
		}
		if(_showWeekHeader != null) {
			component.setValueExpression("showWeekHeader", _showWeekHeader);
		}
		if(_showWeekFooter != null) {
			component.setValueExpression("showWeekFooter", _showWeekFooter);
		}
		if(_readOnlyInputText != null) {
			component.setValueExpression("readOnlyInputText", _readOnlyInputText);
		}
	}

	public String getComponentType() {
		return Calendar.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return "org.primefaces.component.CalendarRenderer";
	}

	public void setValue(javax.el.ValueExpression expression){
		this._value = expression;
	}

	public void setConverter(javax.el.ValueExpression expression){
		this._converter = expression;
	}

	public void setImmediate(javax.el.ValueExpression expression){
		this._immediate = expression;
	}

	public void setRequired(javax.el.ValueExpression expression){
		this._required = expression;
	}

	public void setValidator(javax.el.MethodExpression expression){
		this._validator = expression;
	}

	public void setValueChangeListener(javax.el.MethodExpression expression){
		this._valueChangeListener = expression;
	}

	public void setRequiredMessage(javax.el.ValueExpression expression){
		this._requiredMessage = expression;
	}

	public void setConverterMessage(javax.el.ValueExpression expression){
		this._converterMessage = expression;
	}

	public void setValidatorMessage(javax.el.ValueExpression expression){
		this._validatorMessage = expression;
	}

	public void setWidgetVar(javax.el.ValueExpression expression){
		this._widgetVar = expression;
	}

	public void setTitle(javax.el.ValueExpression expression){
		this._title = expression;
	}

	public void setMindate(javax.el.ValueExpression expression){
		this._mindate = expression;
	}

	public void setMaxdate(javax.el.ValueExpression expression){
		this._maxdate = expression;
	}

	public void setSelection(javax.el.ValueExpression expression){
		this._selection = expression;
	}

	public void setPages(javax.el.ValueExpression expression){
		this._pages = expression;
	}

	public void setClose(javax.el.ValueExpression expression){
		this._close = expression;
	}

	public void setMode(javax.el.ValueExpression expression){
		this._mode = expression;
	}

	public void setPattern(javax.el.ValueExpression expression){
		this._pattern = expression;
	}

	public void setLocale(javax.el.ValueExpression expression){
		this._locale = expression;
	}

	public void setShowWeekdays(javax.el.ValueExpression expression){
		this._showWeekdays = expression;
	}

	public void setMonthFormat(javax.el.ValueExpression expression){
		this._monthFormat = expression;
	}

	public void setWeekdayFormat(javax.el.ValueExpression expression){
		this._weekdayFormat = expression;
	}

	public void setStartWeekday(javax.el.ValueExpression expression){
		this._startWeekday = expression;
	}

	public void setPopupIcon(javax.el.ValueExpression expression){
		this._popupIcon = expression;
	}

	public void setNavigator(javax.el.ValueExpression expression){
		this._navigator = expression;
	}

	public void setPagedate(javax.el.ValueExpression expression){
		this._pagedate = expression;
	}

	public void setTimeZone(javax.el.ValueExpression expression){
		this._timeZone = expression;
	}

	public void setShowWeekHeader(javax.el.ValueExpression expression){
		this._showWeekHeader = expression;
	}

	public void setShowWeekFooter(javax.el.ValueExpression expression){
		this._showWeekFooter = expression;
	}

	public void setReadOnlyInputText(javax.el.ValueExpression expression){
		this._readOnlyInputText = expression;
	}

}