/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.schedule;

import javax.faces.webapp.UIComponentELTag;
import javax.faces.component.UIComponent;

public class ScheduleTag extends UIComponentELTag {

	private javax.el.ValueExpression _widgetVar;
	private javax.el.ValueExpression _value;
	private javax.el.ValueExpression _locale;
	private javax.el.ValueExpression _aspectRatio;
	private javax.el.ValueExpression _view;
	private javax.el.ValueExpression _initialDate;
	private javax.el.ValueExpression _theme;
	private javax.el.ValueExpression _showWeekends;
	private javax.el.ValueExpression _style;
	private javax.el.ValueExpression _styleClass;
	private javax.el.ValueExpression _editable;
	private javax.el.ValueExpression _draggable;
	private javax.el.ValueExpression _resizable;
	private javax.el.MethodExpression _eventSelectListener;
	private javax.el.MethodExpression _dateSelectListener;

	public void release(){
		super.release();
		this._widgetVar = null;
		this._value = null;
		this._locale = null;
		this._aspectRatio = null;
		this._view = null;
		this._initialDate = null;
		this._theme = null;
		this._showWeekends = null;
		this._style = null;
		this._styleClass = null;
		this._editable = null;
		this._draggable = null;
		this._resizable = null;
		this._eventSelectListener = null;
		this._dateSelectListener = null;
	}

	protected void setProperties(UIComponent comp){
		super.setProperties(comp);

		org.primefaces.component.schedule.Schedule component = null;
		try {
			component = (org.primefaces.component.schedule.Schedule) comp;
		} catch(ClassCastException cce) {
			throw new IllegalStateException("Component " + component.toString() + " not expected type.");
		}

		if(_widgetVar != null) {
			component.setValueExpression("widgetVar", _widgetVar);
		}
		if(_value != null) {
			component.setValueExpression("value", _value);
		}
		if(_locale != null) {
			component.setValueExpression("locale", _locale);
		}
		if(_aspectRatio != null) {
			component.setValueExpression("aspectRatio", _aspectRatio);
		}
		if(_view != null) {
			component.setValueExpression("view", _view);
		}
		if(_initialDate != null) {
			component.setValueExpression("initialDate", _initialDate);
		}
		if(_theme != null) {
			component.setValueExpression("theme", _theme);
		}
		if(_showWeekends != null) {
			component.setValueExpression("showWeekends", _showWeekends);
		}
		if(_style != null) {
			component.setValueExpression("style", _style);
		}
		if(_styleClass != null) {
			component.setValueExpression("styleClass", _styleClass);
		}
		if(_editable != null) {
			component.setValueExpression("editable", _editable);
		}
		if(_draggable != null) {
			component.setValueExpression("draggable", _draggable);
		}
		if(_resizable != null) {
			component.setValueExpression("resizable", _resizable);
		}
		if(_eventSelectListener != null) {
			component.setEventSelectListener(_eventSelectListener);
		}
		if(_dateSelectListener != null) {
			component.setDateSelectListener(_dateSelectListener);
		}
	}

	public String getComponentType() {
		return Schedule.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return "org.primefaces.component.ScheduleRenderer";
	}

	public void setWidgetVar(javax.el.ValueExpression expression){
		this._widgetVar = expression;
	}

	public void setValue(javax.el.ValueExpression expression){
		this._value = expression;
	}

	public void setLocale(javax.el.ValueExpression expression){
		this._locale = expression;
	}

	public void setAspectRatio(javax.el.ValueExpression expression){
		this._aspectRatio = expression;
	}

	public void setView(javax.el.ValueExpression expression){
		this._view = expression;
	}

	public void setInitialDate(javax.el.ValueExpression expression){
		this._initialDate = expression;
	}

	public void setTheme(javax.el.ValueExpression expression){
		this._theme = expression;
	}

	public void setShowWeekends(javax.el.ValueExpression expression){
		this._showWeekends = expression;
	}

	public void setStyle(javax.el.ValueExpression expression){
		this._style = expression;
	}

	public void setStyleClass(javax.el.ValueExpression expression){
		this._styleClass = expression;
	}

	public void setEditable(javax.el.ValueExpression expression){
		this._editable = expression;
	}

	public void setDraggable(javax.el.ValueExpression expression){
		this._draggable = expression;
	}

	public void setResizable(javax.el.ValueExpression expression){
		this._resizable = expression;
	}

	public void setEventSelectListener(javax.el.MethodExpression expression){
		this._eventSelectListener = expression;
	}

	public void setDateSelectListener(javax.el.MethodExpression expression){
		this._dateSelectListener = expression;
	}

}