/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.wizard;

import org.primefaces.component.wizard.UIWizard;
import javax.faces.context.FacesContext;
import javax.el.ValueExpression;
import javax.el.MethodExpression;
import javax.faces.render.Renderer;
import java.io.IOException;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.component.api.AjaxComponent;
import org.primefaces.resource.ResourceHolder;
import org.primefaces.component.tabview.Tab;


public class Wizard extends UIWizard implements AjaxComponent {


	public static final String COMPONENT_TYPE = "org.primefaces.component.Wizard";
	public static final String COMPONENT_FAMILY = "org.primefaces.component";
	private static final String DEFAULT_RENDERER = "org.primefaces.component.WizardRenderer";

	private java.lang.String _widgetVar;
	private java.lang.Integer _step;
	private java.lang.String _effect;
	private java.lang.Integer _width;
	private java.lang.Integer _height;
	private java.lang.String _style;
	private java.lang.String _styleClass;
	private java.lang.Integer _speed;
	private java.lang.Boolean _customUI;
	public Wizard() {
		setRendererType(DEFAULT_RENDERER);
		ResourceHolder resourceHolder = getResourceHolder();
		if(resourceHolder != null) {
			resourceHolder.addResource("/primefaces/wizard/assets/wizard.css");
			resourceHolder.addResource("/yui/utilities/utilities.js");
			resourceHolder.addResource("/jquery/jquery.js");
			resourceHolder.addResource("/jquery/plugins/tabswitch/tabswitch.js");
			resourceHolder.addResource("/primefaces/core/core.js");
			resourceHolder.addResource("/primefaces/wizard/wizard.js");
		}
	}

	public String getFamily() {
		return COMPONENT_FAMILY;
	}

	public java.lang.String getWidgetVar() {
		if(_widgetVar != null )
			return _widgetVar;

		ValueExpression ve = getValueExpression("widgetVar");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setWidgetVar(java.lang.String _widgetVar) {
		this._widgetVar = _widgetVar;
	}

	public int getStep() {
		if(_step != null )
			return _step;

		ValueExpression ve = getValueExpression("step");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 0;
	}
	public void setStep(int _step) {
		this._step = _step;
	}

	public java.lang.String getEffect() {
		if(_effect != null )
			return _effect;

		ValueExpression ve = getValueExpression("effect");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : "slide";
	}
	public void setEffect(java.lang.String _effect) {
		this._effect = _effect;
	}

	public int getWidth() {
		if(_width != null )
			return _width;

		ValueExpression ve = getValueExpression("width");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 400;
	}
	public void setWidth(int _width) {
		this._width = _width;
	}

	public int getHeight() {
		if(_height != null )
			return _height;

		ValueExpression ve = getValueExpression("height");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 400;
	}
	public void setHeight(int _height) {
		this._height = _height;
	}

	public java.lang.String getStyle() {
		if(_style != null )
			return _style;

		ValueExpression ve = getValueExpression("style");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setStyle(java.lang.String _style) {
		this._style = _style;
	}

	public java.lang.String getStyleClass() {
		if(_styleClass != null )
			return _styleClass;

		ValueExpression ve = getValueExpression("styleClass");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setStyleClass(java.lang.String _styleClass) {
		this._styleClass = _styleClass;
	}

	public int getSpeed() {
		if(_speed != null )
			return _speed;

		ValueExpression ve = getValueExpression("speed");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 500;
	}
	public void setSpeed(int _speed) {
		this._speed = _speed;
	}

	public boolean isCustomUI() {
		if(_customUI != null )
			return _customUI;

		ValueExpression ve = getValueExpression("customUI");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setCustomUI(boolean _customUI) {
		this._customUI = _customUI;
	}


	public void processDecodes(FacesContext facesContext) {
		String stepToGoParam = facesContext.getExternalContext().getRequestParameterMap().get("stepToGo");
		String currentStepParam = facesContext.getExternalContext().getRequestParameterMap().get("currentStep");
		
		if(stepToGoParam != null && currentStepParam != null) {
			int stepToGo = Integer.valueOf(facesContext.getExternalContext().getRequestParameterMap().get("stepToGo")).intValue();
			int currentStep = Integer.valueOf(facesContext.getExternalContext().getRequestParameterMap().get("currentStep")).intValue();
			
			if(stepToGo < currentStep) {
				facesContext.renderResponse();
			} else if(stepToGo > currentStep) {
				Tab tabToProcess = (Tab) getChildren().get(currentStep);
				
				tabToProcess.processDecodes(facesContext);
			}
		} else {
			super.processDecodes(facesContext);
		}
    }

	protected FacesContext getFacesContext() {
		return FacesContext.getCurrentInstance();
	}

	public void encodePartially(FacesContext facesContext) throws IOException {
		Renderer renderer = getRenderer(facesContext);

		if(renderer instanceof PartialRenderer) {
			((PartialRenderer)renderer).encodePartially(facesContext, this);
		}
	}
	public Object saveState(FacesContext context) {
		Object values[] = new Object[10];
		values[0] = super.saveState(context);
		values[1] = _widgetVar;
		values[2] = _step;
		values[3] = _effect;
		values[4] = _width;
		values[5] = _height;
		values[6] = _style;
		values[7] = _styleClass;
		values[8] = _speed;
		values[9] = _customUI;
		return ((Object) values);
	}
	public void restoreState(FacesContext context, Object state) {
		Object values[] = (Object[]) state;
		super.restoreState(context, values[0]);
		_widgetVar = (java.lang.String) values[1];
		_step = (java.lang.Integer) values[2];
		_effect = (java.lang.String) values[3];
		_width = (java.lang.Integer) values[4];
		_height = (java.lang.Integer) values[5];
		_style = (java.lang.String) values[6];
		_styleClass = (java.lang.String) values[7];
		_speed = (java.lang.Integer) values[8];
		_customUI = (java.lang.Boolean) values[9];
	}

	protected ResourceHolder getResourceHolder() {
		FacesContext facesContext = getFacesContext();
		if(facesContext == null)
			return null;

		ValueExpression ve = facesContext.getApplication().getExpressionFactory().createValueExpression(facesContext.getELContext(), "#{primeFacesResourceHolder}", ResourceHolder.class);

		return (ResourceHolder) ve.getValue(facesContext.getELContext());
	}
}