/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.confirmdialog;

import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.el.ValueExpression;
import javax.el.MethodExpression;
import javax.faces.render.Renderer;
import java.io.IOException;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.resource.ResourceHolder;


public class ConfirmDialog extends UIPanel {


	public static final String COMPONENT_TYPE = "org.primefaces.component.ConfirmDialog";
	public static final String COMPONENT_FAMILY = "org.primefaces.component";

	private java.lang.String _message;
	private java.lang.String _header;
	private java.lang.String _yesLabel;
	private java.lang.String _noLabel;
	private java.lang.String _severity;
	private java.lang.Boolean _close;
	private java.lang.Boolean _draggable;
	private java.lang.String _underlay;
	private java.lang.Boolean _modal;
	private java.lang.Boolean _visible;
	private java.lang.Boolean _constrainToViewport;
	private java.lang.Integer _x;
	private java.lang.Integer _y;
	private java.lang.Boolean _fixedCenter;
	private java.lang.String _width;
	private java.lang.String _height;
	private java.lang.String _effect;
	private java.lang.Double _effectDuration;
	public ConfirmDialog() {
		setRendererType(null);
		ResourceHolder resourceHolder = getResourceHolder();
		if(resourceHolder != null) {
			resourceHolder.addResource("/yui/container/assets/skins/sam/container.css");
			resourceHolder.addResource("/yui/utilities/utilities.js");
			resourceHolder.addResource("/yui/container/container-min.js");
		}
	}

	public String getFamily() {
		return COMPONENT_FAMILY;
	}

	public java.lang.String getMessage() {
		if(_message != null )
			return _message;

		ValueExpression ve = getValueExpression("message");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setMessage(java.lang.String _message) {
		this._message = _message;
	}

	public java.lang.String getHeader() {
		if(_header != null )
			return _header;

		ValueExpression ve = getValueExpression("header");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setHeader(java.lang.String _header) {
		this._header = _header;
	}

	public java.lang.String getYesLabel() {
		if(_yesLabel != null )
			return _yesLabel;

		ValueExpression ve = getValueExpression("yesLabel");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : "Yes";
	}
	public void setYesLabel(java.lang.String _yesLabel) {
		this._yesLabel = _yesLabel;
	}

	public java.lang.String getNoLabel() {
		if(_noLabel != null )
			return _noLabel;

		ValueExpression ve = getValueExpression("noLabel");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : "No";
	}
	public void setNoLabel(java.lang.String _noLabel) {
		this._noLabel = _noLabel;
	}

	public java.lang.String getSeverity() {
		if(_severity != null )
			return _severity;

		ValueExpression ve = getValueExpression("severity");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : "warn";
	}
	public void setSeverity(java.lang.String _severity) {
		this._severity = _severity;
	}

	public boolean isClose() {
		if(_close != null )
			return _close;

		ValueExpression ve = getValueExpression("close");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : true;
	}
	public void setClose(boolean _close) {
		this._close = _close;
	}

	public boolean isDraggable() {
		if(_draggable != null )
			return _draggable;

		ValueExpression ve = getValueExpression("draggable");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : true;
	}
	public void setDraggable(boolean _draggable) {
		this._draggable = _draggable;
	}

	public java.lang.String getUnderlay() {
		if(_underlay != null )
			return _underlay;

		ValueExpression ve = getValueExpression("underlay");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : "shadow";
	}
	public void setUnderlay(java.lang.String _underlay) {
		this._underlay = _underlay;
	}

	public boolean isModal() {
		if(_modal != null )
			return _modal;

		ValueExpression ve = getValueExpression("modal");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setModal(boolean _modal) {
		this._modal = _modal;
	}

	public boolean isVisible() {
		if(_visible != null )
			return _visible;

		ValueExpression ve = getValueExpression("visible");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setVisible(boolean _visible) {
		this._visible = _visible;
	}

	public boolean isConstrainToViewport() {
		if(_constrainToViewport != null )
			return _constrainToViewport;

		ValueExpression ve = getValueExpression("constrainToViewport");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setConstrainToViewport(boolean _constrainToViewport) {
		this._constrainToViewport = _constrainToViewport;
	}

	public int getX() {
		if(_x != null )
			return _x;

		ValueExpression ve = getValueExpression("x");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : -1;
	}
	public void setX(int _x) {
		this._x = _x;
	}

	public int getY() {
		if(_y != null )
			return _y;

		ValueExpression ve = getValueExpression("y");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : -1;
	}
	public void setY(int _y) {
		this._y = _y;
	}

	public boolean isFixedCenter() {
		if(_fixedCenter != null )
			return _fixedCenter;

		ValueExpression ve = getValueExpression("fixedCenter");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setFixedCenter(boolean _fixedCenter) {
		this._fixedCenter = _fixedCenter;
	}

	public java.lang.String getWidth() {
		if(_width != null )
			return _width;

		ValueExpression ve = getValueExpression("width");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setWidth(java.lang.String _width) {
		this._width = _width;
	}

	public java.lang.String getHeight() {
		if(_height != null )
			return _height;

		ValueExpression ve = getValueExpression("height");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setHeight(java.lang.String _height) {
		this._height = _height;
	}

	public java.lang.String getEffect() {
		if(_effect != null )
			return _effect;

		ValueExpression ve = getValueExpression("effect");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setEffect(java.lang.String _effect) {
		this._effect = _effect;
	}

	public double getEffectDuration() {
		if(_effectDuration != null )
			return _effectDuration;

		ValueExpression ve = getValueExpression("effectDuration");
		return ve != null ? (java.lang.Double) ve.getValue(getFacesContext().getELContext())  : 1;
	}
	public void setEffectDuration(double _effectDuration) {
		this._effectDuration = _effectDuration;
	}


	protected FacesContext getFacesContext() {
		return FacesContext.getCurrentInstance();
	}
	public Object saveState(FacesContext context) {
		Object values[] = new Object[19];
		values[0] = super.saveState(context);
		values[1] = _message;
		values[2] = _header;
		values[3] = _yesLabel;
		values[4] = _noLabel;
		values[5] = _severity;
		values[6] = _close;
		values[7] = _draggable;
		values[8] = _underlay;
		values[9] = _modal;
		values[10] = _visible;
		values[11] = _constrainToViewport;
		values[12] = _x;
		values[13] = _y;
		values[14] = _fixedCenter;
		values[15] = _width;
		values[16] = _height;
		values[17] = _effect;
		values[18] = _effectDuration;
		return ((Object) values);
	}
	public void restoreState(FacesContext context, Object state) {
		Object values[] = (Object[]) state;
		super.restoreState(context, values[0]);
		_message = (java.lang.String) values[1];
		_header = (java.lang.String) values[2];
		_yesLabel = (java.lang.String) values[3];
		_noLabel = (java.lang.String) values[4];
		_severity = (java.lang.String) values[5];
		_close = (java.lang.Boolean) values[6];
		_draggable = (java.lang.Boolean) values[7];
		_underlay = (java.lang.String) values[8];
		_modal = (java.lang.Boolean) values[9];
		_visible = (java.lang.Boolean) values[10];
		_constrainToViewport = (java.lang.Boolean) values[11];
		_x = (java.lang.Integer) values[12];
		_y = (java.lang.Integer) values[13];
		_fixedCenter = (java.lang.Boolean) values[14];
		_width = (java.lang.String) values[15];
		_height = (java.lang.String) values[16];
		_effect = (java.lang.String) values[17];
		_effectDuration = (java.lang.Double) values[18];
	}

	protected ResourceHolder getResourceHolder() {
		FacesContext facesContext = getFacesContext();
		if(facesContext == null)
			return null;

		ValueExpression ve = facesContext.getApplication().getExpressionFactory().createValueExpression(facesContext.getELContext(), "#{primeFacesResourceHolder}", ResourceHolder.class);

		return (ResourceHolder) ve.getValue(facesContext.getELContext());
	}
}