/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.propdev.editors;

import java.util.ArrayList;
import jp.sf.propdev.model.PropertiesNode;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class PropertiesEditorCompletionProcessor
implements IContentAssistProcessor {
    private char[] autoActivationChars = null;
    private String errorMessage;
    private PropertiesNode propertiesModel;

    public PropertiesEditorCompletionProcessor(PropertiesNode model) {
        this.propertiesModel = model;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        return this.computeCompletionProposals(viewer.getDocument(), offset);
    }

    private ICompletionProposal[] computeCompletionProposals(IDocument document, int offset) {
        CompletionProposal[] result = null;
        try {
            IRegion region = document.getLineInformationOfOffset(offset);
            String content = document.get(region.getOffset(), region.getLength());
            int index = offset - region.getOffset() - 1;
            while (index >= 0 && (Character.isJavaIdentifierPart(content.charAt(index)) || ".-/\\".indexOf(content.charAt(index)) >= 0)) {
                --index;
            }
            int start = region.getOffset() + index + 1;
            String candidate = content.substring(index + 1, offset - region.getOffset());
            String[] proposalStrings = this.getProposals(candidate);
            result = new CompletionProposal[proposalStrings.length];
            int proposal = 0;
            while (proposal < result.length) {
                result[proposal] = new CompletionProposal(proposalStrings[proposal], start, candidate.length(), proposalStrings[proposal].length());
                ++proposal;
            }
        }
        catch (BadLocationException exception) {
            this.errorMessage = result == null ? exception.getLocalizedMessage() : null;
        }
        return result;
    }

    private String[] getProposals(String candidate) {
        String[] keys = this.propertiesModel.getKeys();
        candidate = candidate.toLowerCase();
        ArrayList<String> proposalList = new ArrayList<String>(keys.length);
        int i = 0;
        while (i < keys.length) {
            if (keys[i].startsWith(candidate)) {
                proposalList.add(keys[i]);
            }
            ++i;
        }
        String[] proposals = new String[proposalList.size()];
        return proposalList.toArray(proposals);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.autoActivationChars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] cs) {
        this.autoActivationChars = cs;
    }
}

