/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.propdev.editors.text;

import jp.sf.propdev.editors.text.IProblem;
import org.eclipse.jface.text.Region;

public class PropertiesProblem
extends Region
implements IProblem {
    private String fMessage;
    private String fEscapedMessage;
    private int fSeverity;
    private int fAdjustedLength = -1;
    private int fLineNumber = -1;

    public PropertiesProblem(String message, int severity, int offset, int length, int lineNumber) {
        super(offset, length);
        this.fMessage = message;
        this.fEscapedMessage = this.getEscaped(message);
        this.fSeverity = severity;
        this.fLineNumber = lineNumber;
    }

    public String getMessage() {
        return this.fEscapedMessage;
    }

    public boolean isError() {
        return this.fSeverity == 1 || this.fSeverity == 2;
    }

    public boolean isWarning() {
        return this.fSeverity == 0;
    }

    public int getLength() {
        if (this.fAdjustedLength != -1) {
            return this.fAdjustedLength;
        }
        return super.getLength();
    }

    public void setLength(int adjustedLength) {
        this.fAdjustedLength = adjustedLength;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    private void appendEscapedChar(StringBuffer buffer, char c) {
        String replacement = this.getReplacement(c);
        if (replacement != null) {
            buffer.append(replacement);
        } else {
            buffer.append(c);
        }
    }

    private String getEscaped(String s) {
        StringBuffer result = new StringBuffer(s.length() + 10);
        int i = 0;
        while (i < s.length()) {
            this.appendEscapedChar(result, s.charAt(i));
            ++i;
        }
        return result.toString();
    }

    private String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }

    public String getUnmodifiedMessage() {
        return this.fMessage;
    }

    public static int getSeverity(String preferenceKey) {
        return -1;
    }

    public boolean equals(Object o) {
        boolean equal = super.equals(o);
        if (equal) {
            return ((PropertiesProblem)o).getUnmodifiedMessage().equals(this.getUnmodifiedMessage());
        }
        return false;
    }
}

