/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.propdev.editors.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.sf.propdev.editors.text.IProblem;
import jp.sf.propdev.editors.text.IProblemRequestor;
import jp.sf.propdev.editors.text.LocationProvider;
import jp.sf.propdev.editors.text.PropertiesDocumentSetupParticipant;
import jp.sf.propdev.editors.text.PropertiesProblemAnnotation;
import jp.sf.propdev.editors.text.PropertiesStorageDocumentProvider;
import jp.sf.propdev.model.PropertiesEditorMarkerUpdater;
import jp.sf.propdev.model.PropertiesNode;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationMap;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class PropertiesTextFileDocumentProvider
extends TextFileDocumentProvider {
    public static final int ASCII2NATIVE_MODE = 1;
    public static final int NORMAL_MODE = 0;
    private int mode;

    public PropertiesTextFileDocumentProvider() {
        this(0);
    }

    public PropertiesTextFileDocumentProvider(int mode) {
        this.mode = mode;
        PropertiesStorageDocumentProvider provider = new PropertiesStorageDocumentProvider();
        provider = new TextFileDocumentProvider((IDocumentProvider)provider);
        provider = new ForwardingDocumentProvider("__dftl_partition_content_type", (IDocumentSetupParticipant)new PropertiesDocumentSetupParticipant(), (IDocumentProvider)provider);
        this.setParentDocumentProvider((IDocumentProvider)provider);
    }

    public void connect(Object element) throws CoreException {
        super.connect(element);
        this.getParentProvider().connect(element);
    }

    public void disconnect(Object element) {
        this.getParentProvider().disconnect(element);
        super.disconnect(element);
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new PropertiesAnnotationModel(file);
    }

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new PropertiesFileInfo();
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        TextFileDocumentProvider.FileInfo info = super.createFileInfo(element);
        if (!(info instanceof PropertiesFileInfo)) {
            return null;
        }
        PropertiesFileInfo propInfo = (PropertiesFileInfo)info;
        IAnnotationModel model = propInfo.fModel;
        PropertiesNode propModel = this.createPropertiesModel(element, propInfo.fTextFileBuffer.getDocument(), model);
        propModel.install();
        propInfo.fPropertiesModel = propModel;
        this.setUpSynchronization(propInfo);
        return propInfo;
    }

    private PropertiesNode createPropertiesModel(Object element, IDocument document, IAnnotationModel model) {
        IProblemRequestor requestor = model instanceof IProblemRequestor ? (IProblemRequestor)model : null;
        LocationProvider locationProvider = new LocationProvider(element instanceof IEditorInput ? (IEditorInput)element : null);
        return new PropertiesNode(document, requestor, locationProvider);
    }

    protected void disposeFileInfo(Object element, TextFileDocumentProvider.FileInfo info) {
        if (info instanceof PropertiesFileInfo) {
            PropertiesFileInfo xmlInfo = (PropertiesFileInfo)info;
            if (xmlInfo.fPropertiesModel != null) {
                xmlInfo.fPropertiesModel.dispose();
            }
        }
        super.disposeFileInfo(element, info);
    }

    public PropertiesNode getPropertiesModel(Object element) {
        TextFileDocumentProvider.FileInfo info = this.getFileInfo(element);
        if (info instanceof PropertiesFileInfo) {
            PropertiesFileInfo xmlInfo = (PropertiesFileInfo)info;
            return xmlInfo.fPropertiesModel;
        }
        return null;
    }

    private void setUpSynchronization(PropertiesFileInfo propInfo) {
        IDocument document = propInfo.fTextFileBuffer.getDocument();
        IAnnotationModel model = propInfo.fModel;
        if (document instanceof ISynchronizable && model instanceof ISynchronizable) {
            Object lock = ((ISynchronizable)document).getLockObject();
            ((ISynchronizable)model).setLockObject(lock);
        }
    }

    protected class PropertiesAnnotationModel
    extends ResourceMarkerAnnotationModel
    implements IProblemRequestor {
        private List fCollectedProblems = new ArrayList();
        private List fGeneratedAnnotations = new ArrayList();
        private ReverseMap fReverseMap = new ReverseMap();

        public PropertiesAnnotationModel(IFile file) {
            super((IResource)file);
        }

        public void acceptProblem(IProblem problem) {
            this.fCollectedProblems.add(problem);
        }

        protected void addAnnotation(Annotation annotation, Position position, boolean fireModelChanged) throws BadLocationException {
            super.addAnnotation(annotation, position, fireModelChanged);
            Object cached = this.fReverseMap.get(position);
            if (cached == null) {
                this.fReverseMap.put(position, annotation);
            } else if (cached instanceof List) {
                List list = (List)cached;
                list.add(annotation);
            } else if (cached instanceof Annotation) {
                ArrayList<Object> list = new ArrayList<Object>(2);
                list.add(cached);
                list.add(annotation);
                this.fReverseMap.put(position, list);
            }
        }

        public void beginReporting() {
        }

        protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
            String markerType = MarkerUtilities.getMarkerType((IMarker)marker);
            if (PropertiesEditorMarkerUpdater.BUILDFILE_PROBLEM_MARKER.equals(markerType)) {
                return null;
            }
            return new MarkerAnnotation(EditorsUI.getAnnotationTypeLookup().getAnnotationType(marker), marker);
        }

        protected Position createPositionFromProblem(IProblem problem) {
            int length;
            int start = problem.getOffset();
            if (start >= 0 && (length = problem.getLength()) >= 0) {
                return new Position(start, length);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endReporting() {
            boolean temporaryProblemsChanged = false;
            IAnnotationMap iAnnotationMap = this.getAnnotationMap();
            synchronized (iAnnotationMap) {
                if (this.fGeneratedAnnotations.size() > 0) {
                    temporaryProblemsChanged = true;
                    this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                    this.fGeneratedAnnotations.clear();
                }
                if (this.fCollectedProblems != null && this.fCollectedProblems.size() > 0) {
                    Iterator e = this.fCollectedProblems.iterator();
                    while (e.hasNext()) {
                        IProblem problem = (IProblem)e.next();
                        Position position = this.createPositionFromProblem(problem);
                        if (position == null) continue;
                        PropertiesProblemAnnotation annotation = new PropertiesProblemAnnotation(problem);
                        this.fGeneratedAnnotations.add(annotation);
                        try {
                            this.addAnnotation(annotation, position, false);
                        }
                        catch (BadLocationException ex) {
                            ex.printStackTrace();
                        }
                        temporaryProblemsChanged = true;
                    }
                    this.fCollectedProblems.clear();
                }
            }
            if (temporaryProblemsChanged) {
                this.fireModelChanged(new AnnotationModelEvent((IAnnotationModel)this));
            }
        }

        protected void removeAllAnnotations(boolean fireModelChanged) {
            super.removeAllAnnotations(fireModelChanged);
            this.fReverseMap.clear();
        }

        protected void removeAnnotation(Annotation annotation, boolean fireModelChanged) {
            Position position = this.getPosition(annotation);
            Object cached = this.fReverseMap.get(position);
            if (cached instanceof List) {
                List list = (List)cached;
                list.remove(annotation);
                if (list.size() == 1) {
                    this.fReverseMap.put(position, list.get(0));
                    list.clear();
                }
            } else if (cached instanceof Annotation) {
                this.fReverseMap.remove(position);
            }
            super.removeAnnotation(annotation, fireModelChanged);
        }
    }

    protected class PropertiesFileInfo
    extends TextFileDocumentProvider.FileInfo {
        public PropertiesNode fPropertiesModel;
    }

    protected static class ReverseMap {
        private int fAnchor = 0;
        private List fList = new ArrayList(2);

        public void clear() {
            this.fList.clear();
        }

        public Object get(Position position) {
            Entry entry;
            int length = this.fList.size();
            int i = this.fAnchor;
            while (i < length) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            i = 0;
            while (i < this.fAnchor) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            return null;
        }

        private int getIndex(Position position) {
            int length = this.fList.size();
            int i = 0;
            while (i < length) {
                Entry entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void put(Position position, Object value) {
            int index = this.getIndex(position);
            if (index == -1) {
                Entry entry = new Entry();
                entry.fPosition = position;
                entry.fValue = value;
                this.fList.add(entry);
            } else {
                Entry entry = (Entry)this.fList.get(index);
                entry.fValue = value;
            }
        }

        public void remove(Position position) {
            int index = this.getIndex(position);
            if (index > -1) {
                this.fList.remove(index);
            }
        }

        static class Entry {
            Position fPosition;
            Object fValue;

            Entry() {
            }
        }
    }
}

