/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class LockableFileOutputStream
extends OutputStream {
    private final int LOCK_FLG = 1;
    private final int TRY_LOCK_FLG = 0;
    private FileOutputStream fOut;
    private FileChannel fc;
    private FileLock fl;

    public LockableFileOutputStream(FileOutputStream fileOutputStream) {
        this.fOut = fileOutputStream;
        this.fc = fileOutputStream.getChannel();
    }

    public void close() throws IOException {
        this.fOut.close();
    }

    protected void finalize() throws IOException {
        this.unlock();
    }

    public void flush() throws IOException {
        this.fOut.flush();
    }

    public FileChannel getChannel() {
        return this.fc;
    }

    public boolean lock() {
        return this.lock(1);
    }

    private boolean lock(int n) {
        try {
            if (this.fc != null) {
                if (n == 0) {
                    this.fl = this.fc.tryLock();
                } else if (n == 1) {
                    this.fl = this.fc.lock();
                }
                return this.fl != null;
            }
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            try {
                this.fl.release();
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
            }
            return false;
        }
    }

    public boolean tryLock() {
        return this.lock(0);
    }

    /*
     * Loose catch block
     */
    public boolean unlock() throws IOException {
        block14: {
            if (this.fl == null) break block14;
            this.fl.release();
            boolean bl = true;
            try {
                if (this.fl != null) {
                    this.fl.release();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return bl;
        }
        boolean bl = false;
        try {
            if (this.fl != null) {
                this.fl.release();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
        catch (IOException iOException) {
            try {
                throw iOException;
            }
            catch (Throwable throwable) {
                try {
                    if (this.fl != null) {
                        this.fl.release();
                    }
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.fOut.write(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.fOut.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.fOut.write(byArray);
    }
}

