/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.PropertiesEditorPlugin;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.checker.CheckAndMarkDuplicateKey;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.PropertiesPartitionScanner;
import jp.gr.java_conf.ussiy.app.propedit.util.EncodeChanger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class PropertiesDocumentProvider
extends FileDocumentProvider {
    protected IDocument createDocument(Object object) throws CoreException {
        String string = PropertiesEditorPlugin.getDefault().getPreferenceStore().getString("readEncode");
        if (string == null || string.equals("")) {
            string = this.getDefaultEncoding();
        }
        IDocument iDocument = null;
        if (object instanceof IEditorInput && !this.setDocumentContent(iDocument = this.createEmptyDocument(), (IEditorInput)object, string)) {
            iDocument = null;
        }
        iDocument.set(EncodeChanger.unicodeEsc2Unicode(iDocument.get()));
        if (iDocument != null) {
            DefaultPartitioner defaultPartitioner = new DefaultPartitioner((IPartitionTokenScanner)new PropertiesPartitionScanner(), new String[]{"__properties_comment", "__properties_separator", "__properties_key"});
            defaultPartitioner.connect(iDocument);
            iDocument.setDocumentPartitioner((IDocumentPartitioner)defaultPartitioner);
        }
        return iDocument;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doSaveDocument(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
        if (object instanceof IFileEditorInput) {
            CheckAndMarkDuplicateKey checkAndMarkDuplicateKey = new CheckAndMarkDuplicateKey();
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            checkAndMarkDuplicateKey.checkAndMarkDuplicateKeyInString(iDocument.get(), iFileEditorInput);
            try {
                String string = PropertiesEditorPlugin.getDefault().getPreferenceStore().getString("readEncode");
                if (string == null || string.equals("")) {
                    string = this.getDefaultEncoding();
                }
                String string2 = null;
                string2 = PropertiesEditorPlugin.getDefault().getPreferenceStore().getBoolean("notConvertComment") ? EncodeChanger.unicode2UnicodeEscWithoutComment(iDocument.get()) : EncodeChanger.unicode2UnicodeEsc(iDocument.get());
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.toString().getBytes(string));
                IFile iFile = iFileEditorInput.getFile();
                if (iFile.exists()) {
                    FileDocumentProvider.FileInfo fileInfo = (FileDocumentProvider.FileInfo)this.getElementInfo(object);
                    if (fileInfo != null && !bl) {
                        this.checkSynchronizationState(fileInfo.fModificationStamp, (IResource)iFile);
                    }
                    this.fireElementStateChanging(object);
                    try {
                        iFile.setContents((InputStream)byteArrayInputStream, bl, true, iProgressMonitor);
                    }
                    catch (CoreException coreException) {
                        this.fireElementStateChangeFailed(object);
                        throw coreException;
                    }
                    catch (RuntimeException runtimeException) {
                        this.fireElementStateChangeFailed(object);
                        throw runtimeException;
                    }
                    if (fileInfo == null) return;
                    ResourceMarkerAnnotationModel resourceMarkerAnnotationModel = (ResourceMarkerAnnotationModel)fileInfo.fModel;
                    resourceMarkerAnnotationModel.updateMarkers(fileInfo.fDocument);
                    fileInfo.fModificationStamp = this.computeModificationStamp((IResource)iFile);
                    return;
                }
                super.doSaveDocument(iProgressMonitor, object, iDocument, bl);
                return;
            }
            catch (IOException iOException) {
                Status status = new Status(4, "org.eclipse.ui", 0, iOException.getMessage(), (Throwable)iOException);
                throw new CoreException((IStatus)status);
            }
        }
        super.doSaveDocument(iProgressMonitor, object, iDocument, bl);
    }
}

