/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;

public class PropertiesDoubleClickStrategy
implements ITextDoubleClickStrategy {
    protected ITextViewer fText;

    public void doubleClicked(ITextViewer part) {
        int pos = part.getSelectedRange().x;
        if (pos < 0) {
            return;
        }
        this.fText = part;
        if (this.isSelectKey(pos)) {
            this.selectKey(pos);
        } else {
            this.selectWord(pos);
        }
    }

    protected boolean isSelectKey(int pos) {
        IDocument doc = this.fText.getDocument();
        try {
            ITypedRegion[] partitionType = doc.computePartitioning(pos, 1);
            if (partitionType.length > 0 && partitionType[0].getType().equals("__dftl_partition_content_type")) {
                return true;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void selectKey(int pos) {
        IDocument doc = this.fText.getDocument();
        int lineNum = 0;
        int startPos = 0;
        int length = 0;
        String targetLine = null;
        try {
            lineNum = doc.getLineOfOffset(pos);
            startPos = doc.getLineOffset(lineNum);
            length = doc.getLineLength(lineNum);
            targetLine = doc.get(startPos, length);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return;
        }
        if (targetLine.equals("")) {
            return;
        }
        String line = targetLine;
        boolean escapeFlg = false;
        boolean flg = true;
        int spcnt = 0;
        int i = 0;
        while (i < line.length()) {
            char achar = line.charAt(i);
            if (flg && (achar == ' ' || achar == '\t')) {
                ++spcnt;
            } else {
                String tmp;
                if (flg) {
                    flg = false;
                }
                if (achar == '\\') {
                    if (escapeFlg) {
                        tmp = line;
                        line = "";
                        line = tmp.substring(0, i);
                        line = line + tmp.substring(i + 1, tmp.length());
                        escapeFlg = false;
                        --i;
                    } else {
                        escapeFlg = true;
                    }
                } else if (achar == '=' || achar == '\t' || achar == ':' || achar == ' ') {
                    if (!escapeFlg) {
                        this.selectRange2(startPos + spcnt, i - spcnt);
                        return;
                    }
                    tmp = line;
                    line = "";
                    line = tmp.substring(0, i - 1);
                    line = line + tmp.substring(i, tmp.length());
                    escapeFlg = false;
                    --i;
                } else {
                    if (escapeFlg) {
                        tmp = line;
                        line = "";
                        line = tmp.substring(0, i - 1);
                        line = line + tmp.substring(i, tmp.length());
                        --i;
                    }
                    escapeFlg = false;
                }
            }
            ++i;
        }
        if (targetLine.endsWith("\\\n")) {
            this.selectRange2(startPos + spcnt, i - spcnt - 1);
            return;
        }
        if (targetLine.endsWith("\\")) {
            this.selectRange2(startPos + spcnt, i - spcnt - 1);
            return;
        }
        this.selectRange2(startPos + spcnt, i - spcnt);
    }

    private void selectRange(int startPos, int stopPos) {
        int offset = startPos + 1;
        int length = stopPos - offset;
        this.fText.setSelectedRange(offset, length);
    }

    private void selectRange2(int startPos, int length) {
        this.fText.setSelectedRange(startPos, length);
    }

    protected boolean selectWord(int caretPos) {
        IDocument doc = this.fText.getDocument();
        try {
            char c;
            int pos = caretPos;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            int startPos = pos;
            pos = caretPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            int endPos = pos;
            this.selectRange(startPos, endPos);
            return true;
        }
        catch (BadLocationException x) {
            return false;
        }
    }
}

