/*
 * Decompiled with CFR 0.152.
 */
package com.gon.midp2.http;

import com.gon.midp2.http.RequestAction;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class HttpRequestManager {
    public static final int DEFAULT_NUMBER_TRANSFER_CAPACITY_UP = 3000;
    public static final int DEFAULT_NUMBER_TRANSFER_CAPACITY_DOWN = 10000;
    private int transferCapacityUp = 3000;
    private int transferCapacityDown = 10000;
    private static HttpRequestManager instance = null;

    private HttpRequestManager() {
    }

    public static synchronized HttpRequestManager getInstance() {
        if (instance == null) {
            instance = new HttpRequestManager();
        }
        return instance;
    }

    public String requestPost(String uri, String postData) throws Exception, IOException {
        HttpConnection hc = null;
        OutputStreamWriter osw = null;
        try {
            hc = (HttpConnection)Connector.open((String)uri);
            hc.setRequestMethod("POST");
            hc.setRequestProperty("Content-Type", "text/plain");
            osw = new OutputStreamWriter(hc.openOutputStream());
            osw.write(postData, 0, postData.length());
            osw.flush();
            return this.getResponse(hc);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public String requestGet(String uri) throws Exception {
        HttpConnection hc = null;
        hc = (HttpConnection)Connector.open((String)uri);
        hc.setRequestMethod("GET");
        return this.getResponse(hc);
    }

    public void requestPostDrivenByCommandAction(String uri, String postData, RequestAction requestAction) {
        final String URI = uri;
        final String PD = postData;
        final RequestAction RA = requestAction;
        Thread httpThread = new Thread(){

            public void run() {
                try {
                    RA.requestActionPost(HttpRequestManager.this.requestPost(URI, PD));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        httpThread.start();
    }

    public void requestGetDrivenByCommandAction(String uri, RequestAction requestAction) {
        final String URI = uri;
        final RequestAction RA = requestAction;
        Thread httpThread = new Thread(){

            public void run() {
                try {
                    RA.requestActionGet(HttpRequestManager.this.requestGet(URI));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        httpThread.start();
    }

    private String getResponse(HttpConnection hc) throws Exception {
        int c;
        int i = 0;
        InputStreamReader isr = null;
        char[] responseChar = new char[Integer.parseInt(hc.getHeaderField("Content-Length"))];
        isr = new InputStreamReader(hc.openInputStream());
        while ((c = isr.read()) != -1) {
            responseChar[i] = (char)c;
            ++i;
        }
        return new String(responseChar);
    }

    public void setTransferCapacityUp(int transferCapacity) {
        this.transferCapacityUp = transferCapacity;
    }

    public int getTransferCapacityUp() {
        return this.transferCapacityUp;
    }

    public void setTransferCapacityDown(int transferCapacity) {
        this.transferCapacityDown = transferCapacity;
    }

    public int getTransferCapacityDown() {
        return this.transferCapacityDown;
    }
}

