/*	Rice Golomb Codings	*/
/*	encode example		*/
#include <stdio.h>
#include <string.h>
#include "_bitio.h"
#include "_bitio.c"
#define k 0x0b //	k:0x09 to 0x0b?		


//	
//	encoding processes
//	1. sign(1 for positive, 0 for negative)
//	2. n/(2^k) 0's
//	3. terminating "1"
//	4. k least significant bits of n
//


void encode(long int n){
	int zero_shift = 0;
	
	if(n < 0){
		putbit(0);					// sign (put 0:if n as negative)
		n = -n;						// n = abs(n)
		//printf("\t 0");
	}
	else{ 
		putbit(1);					// sign (put 1:if n as positive)
		//printf("\t 1");
	}
	zero_shift = (n >> (k));
	//printf("\t shift= %d",zero_shift);
	while(zero_shift > 0){

		zero_shift--;
		putbit(0);
	}	// put n/(2^k) 0's
	
	putbit(1);						// terminating "1"
	putbits(k,rightbits(k,n));
	//printf("\t finish= %d \r\n",(n & ((1U<<k)-1)));
}



void decode(void){
	long int decode_buff;
	long int diff,diff2;
	unsigned int buff_sign,zero_shift;
	char flag;

	diff = 0;
	diff2 = 0;
	// get sign(1 for positive, 0 for negative)
	while(1){
		
		if((buff_sign = getbit())==OVERRUN)break;
		zero_shift = 0;
		while(getbit()==0)zero_shift++;
		
		decode_buff = (signed int)((1U << k)*zero_shift);
		decode_buff += (getbits(k));
		
		if(!buff_sign)decode_buff =- decode_buff;
		/* return decode_buff; */
		diff =(diff + decode_buff);
		fwrite(&diff, sizeof(short int), 1, outfp);
		
		
		//diff2 = diff; //for test
		
		if((buff_sign = getbit())==OVERRUN)break;
		zero_shift = 0;
		while(getbit()==0)zero_shift++;
		
		decode_buff = (signed int)((1U << k)*zero_shift);
		decode_buff += (getbits(k));
		
		if(!buff_sign)decode_buff =- decode_buff;
		/* return decode_buff; */
		diff2 =(diff2 + decode_buff);
		fwrite(&diff2, sizeof(short int), 1, outfp);
		
		//diff = diff2; // for test
 		
	}
}

int main() {
	
	long int diff,diff2;
	signed short int old,old2;
    signed short int s[2];
	int i;
	char endcr='\0';
	
    init_bit_o();
	init_bit_i();
	old = 0;
	old2 = 0;
	
	/* encode */
    if ( NULL == (infp = fopen( "test.wav", "rb" )) ) {
        printf( "\r\nError: The message file cannot be accessed\r\n" );
        return -1;
    }
	
	if ( NULL == (outfp = fopen( "test.rgm", "wb" )) ) {
        printf( "\r\nError: The message file cannot be accessed\r\n" );
        return -1;
    }
	
	
	while((fread(&s, sizeof(short int), 2/*10*/, infp)) > 0){
		//for(i=0;i<10;i++){
		
		diff = (s[0] - old);
		encode(diff);
		old = s[0];
		
		//old2 = old; //for test
		
		//fread(&s,sizeof(short int),1,infp);
		   
		diff2 = (s[1] - old2);
		encode(diff2);
		old2 = s[1];
		
		//old = old2;  //for test
		//}
	}
	
	fclose( infp );
	fclose( outfp ); 
	
	printf("\tencode finish\r\n");
	/* decode */
	if ( NULL == (infp = fopen( "test.rgm", "rb" )) ) {
        printf( "\r\nError: The message file cannot be accessed\r\n" );
        return -1;
    }
	
	if ( NULL == (outfp = fopen( "decode.wav", "wb" )) ) {
        printf( "\r\nError: The message file cannot be accessed\r\n" );
        return -1;
    }

	
	decode();
		
	
	
	
	fclose( infp );
	fclose( outfp ); 
	
	
}



