/*
	File:			UserKernelShared.h

	Description:	Definitions shared between SimpleUserClient (kernel) and SimpleUserClientTool (userland).

	Copyright:		Copyright © 2001-2008 Apple Inc. All rights reserved.
	
	Disclaimer:		IMPORTANT:  This Apple software is supplied to you by Apple Computer, Inc.
					("Apple") in consideration of your agreement to the following terms, and your
					use, installation, modification or redistribution of this Apple software
					constitutes acceptance of these terms.  If you do not agree with these terms,
					please do not use, install, modify or redistribute this Apple software.
					
					In consideration of your agreement to abide by the following terms, and subject
					to these terms, Apple grants you a personal, non-exclusive license, under Apple’s
					copyrights in this original Apple software (the "Apple Software"), to use,
					reproduce, modify and redistribute the Apple Software, with or without
					modifications, in source and/or binary forms; provided that if you redistribute
					the Apple Software in its entirety and without modifications, you must retain
					this notice and the following text and disclaimers in all such redistributions of
					the Apple Software.  Neither the name, trademarks, service marks or logos of
					Apple Computer, Inc. may be used to endorse or promote products derived from the
					Apple Software without specific prior written permission from Apple.  Except as
					expressly stated in this notice, no other rights or licenses, express or implied,
					are granted by Apple herein, including but not limited to any patent rights that
					may be infringed by your derivative works or by other works in which the Apple
					Software may be incorporated.
					
					The Apple Software is provided by Apple on an "AS IS" basis.  APPLE MAKES NO
					WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
					WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
					PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN
					COMBINATION WITH YOUR PRODUCTS.
					
					IN NO EVENT SHALL APPLE BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR
					CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
					GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
					ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, MODIFICATION AND/OR DISTRIBUTION
					OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT
					(INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN
					ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
				
	Change History (most recent first):

            2.0			08/13/2008			Add Leopard user client API for supporting 64-bit user processes.
											Now requires Xcode 3.0 or later to build.
			
            1.1			05/22/2007			Perform endian swapping when called from a user process running
											under Rosetta. Updated to produce a universal binary. Now requires
											Xcode 2.2.1 or later to build.
			
			1.0d3	 	01/14/2003			New sample.

*/

/*
#if MAC_OS_X_VERSION_MIN_REQUIRED <= MAC_OS_X_VERSION_10_4
#define PT1Device		com_apple_dts_driver_SimpleDriver_10_4
#else
#define PT1Device		com_apple_dts_driver_SimpleDriver
#endif
*/
#define kPT1Device    "PT1Device"
//#define kPT1Device_10_4	"com_apple_dts_driver_SimpleDriver_10_4"

// User client method dispatch selectors.
enum {
    kMethodGetDeviceInfo,

    kMethodOpen,
    kMethodClose,
    kMethodGetPciClockCounter,
    kMethodSetPciLatencyTimer,
    kMethodGetPciLatencyTimer,
    kMethodSetLnbPower,
    kMethodGetLnbPower,
    kMethodSetLnbPowerWhenClose,
    kMethodGetLnbPowerWhenClose,
    kMethodSetTunerPowerReset,
    kMethodGetTunerPowerReset,
    kMethodInitTuner,
    kMethodSetTunerSleep,
    kMethodGetTunerSleep,
    kMethodSetFrequency,
    kMethodGetFrequency,
    kMethodGetFrequencyOffset,
    kMethodGetCnAgc,
    kMethodSetIdS,
    kMethodGetIdS,
    kMethodGetCorrectedErrorRate,
    kMethodResetCorrectedErrorCount,
    kMethodGetErrorCount,
    kMethodGetTmccS,
    kMethodGetLayerS,
    kMethodGetTmccT,
    kMethodGetLockedT,
    kMethodSetLayerEnable,
    kMethodGetLayerEnable,
    kMethodSetBufferInfo,
    kMethodGetBufferInfo,
    kMethodResetTransferCounter,
    kMethodIncrementTransferCounter,
    kMethodSetStreamEnable,
    kMethodGetStreamEnable,
    kMethodSetStreamGray,
    kMethodGetStreamGray,
    kMethodSetTransferEnable,
    kMethodGetTransferEnable,
    kMethodGetTransferInfo,

    kNumberOfMethods // Must be last 
};

enum {
    kStatusSuccess,

    kStatusIOError,
    kStatusParamError,

    kStatusConfigRevisionError,
    kStatusPCIBusError,
    kStatusPCIBaseAddressError,
    kStatusInternalError,
    kStatusDcmLockTimeoutError,
    kStatusDcmShiftTimeoutError,

    kStatusNotImplemented
};

// デバイス情報
typedef struct DeviceInfo
{
    uint32_t Bus;
    uint32_t Slot;
    uint32_t Function;      // PCI バス上の位置
    uint32_t BadBitCount;           // PCI バスのビット化け数
} DeviceInfo;

// LNB 電源
typedef enum LnbPower {
    LNB_POWER_OFF,	// オフ
    LNB_POWER_15V,	// 15V 出力
    LNB_POWER_11V	// 11V 出力 (正確には PCI スロットの +12V から 0.6V 程度を引いた値)
} LnbPower;

typedef enum TunerPowerReset {
    kTunerPowerOff,
    kTunerPowerOnResetEnable,
    kTunerPowerOnResetDisable
} TunerPowerReset;

// 受信方式
typedef enum ISDB {
    ISDB_S,
    ISDB_T,
    ISDB_COUNT
} ISDB;

// 階層インデックス
typedef enum LayerIndex {
    // ISDB-S
    LAYER_INDEX_L = 0,	// 低階層
    LAYER_INDEX_H,		// 高階層

    // ISDB-T
    LAYER_INDEX_A = 0,	// A 階層
    LAYER_INDEX_B,		// B 階層
    LAYER_INDEX_C		// C 階層
} LayerIndex;

// 階層数
enum LayerCount {
    // ISDB-S
    LAYER_COUNT_S = LAYER_INDEX_H + 1,

    // ISDB-T
	LAYER_COUNT_T = LAYER_INDEX_C + 1
};

typedef struct ErrorRate {
    uint32_t Numerator;
    uint32_t Denominator;
} ErrorRate;

// ISDB-S TMCC 情報
// (参考) STD-B20 2.9 TMCC情報の構成 〜 2.11 TMCC情報の更新
typedef struct TmccS {
    uint32_t Indicator;     // 変更指示 (5ビット)
    uint32_t Mode[4];       // 伝送モードn (4ビット)
    uint32_t Slot[4];       // 伝送モードnへの割当スロット数 (6ビット)
                            // [相対TS／スロット情報は取得できません]
    uint32_t Id[8];         // 相対TS番号nに対するTS ID (16ビット)
    uint32_t Emergency;     // 起動制御信号 (1ビット)
    uint32_t UpLink;        // アップリンク制御情報 (4ビット)
    uint32_t ExtFlag;       // 拡張フラグ (1ビット)
    uint32_t ExtData[2];    // 拡張領域 (61ビット)
} TmccS;

// ISDB-S 階層情報
typedef struct LayerS {
    uint32_t Mode [LAYER_COUNT_S];  // 伝送モード (3ビット) 
    uint32_t Count[LAYER_COUNT_S];  // ダミースロットを含めた割当スロット数 (6ビット)
} LayerS;

// ISDB-T TMCC 情報
// (参考) STD-B31 3.15.6 TMCC情報 〜 3.15.6.8 セグメント数
typedef struct TmccT {
    uint32_t System;                    // システム識別 (2ビット)
    uint32_t Indicator;                 // 伝送パラメータ切り替え指標 (4ビット)
    uint32_t Emergency;                 // 緊急警報放送用起動フラグ (1ビット)
                                        // カレント情報
    uint32_t Partial;                   // 部分受信フラグ (1ビット)
                                        // 階層情報
    uint32_t Mode      [LAYER_COUNT_T]; // キャリア変調方式 (3ビット)
    uint32_t Rate      [LAYER_COUNT_T]; // 畳込み符号化率 (3ビット)
    uint32_t Interleave[LAYER_COUNT_T]; // インターリーブ長 (3ビット)
    uint32_t Segment   [LAYER_COUNT_T]; // セグメント数 (4ビット)
                                        // [ネクスト情報は取得できません]
    uint32_t Phase;                     // 連結送信位相補正量 (3ビット)
    uint32_t Reserved;                  // リザーブ (12ビット)
} TmccT;

// 受信階層
typedef enum LayerMask {
    LAYER_MASK_NONE,

    // ISDB-S
    LAYER_MASK_L = 1 << LAYER_INDEX_L,
    LAYER_MASK_H = 1 << LAYER_INDEX_H,

    // ISDB-T
    LAYER_MASK_A = 1 << LAYER_INDEX_A,
    LAYER_MASK_B = 1 << LAYER_INDEX_B,
    LAYER_MASK_C = 1 << LAYER_INDEX_C
} LayerMask;    

typedef struct TransferInfo {
    bool TransferCounter0;  // 転送カウンタが 0 であるのを検出した
    bool TransferCounter1;  // 転送カウンタが 1 以下であるのを検出した
    bool BufferOverflow;    // PCI バスを長期に渡り確保できなかったため、ボード上の FIFO(サイズ=8MB) が溢れた
} TransferInfo;             // (これらのフラグは、一度でも条件成立を検出すると DMA 転送を再開するまでクリアされません)

// バッファ情報
typedef struct BufferInfo {
    uint VirtualSize;
    uint VirtualCount;
    uint LockSize;
} BufferInfo;
// バッファはドライバ内部で VirtualAlloc(4096*BUFFER_PAGE_COUNT*VirtualSize) を VirtualCount 回呼び出すことにより確保されます。
// VirtualCount が 2 以上の場合はバッファが分割されるため、アドレスが不連続になることにご注意ください。
// LockSize はドライバ内部でメモリをロックする単位です。
// 
// VirtualSize の範囲は 0 以外の任意の数値です。
// (VirtualSize * VirtualCount) は転送カウンタのビット長による制限を受けるため、範囲は 1〜4095 です。
// (VirtualSize % LockSize) は 0 でなければなりません。
// 
// DMA バッファは CPU 側から見てキャッシュ禁止になっています。このため、バッファの内容をバイト単位で複数回
// 読み出す場合などに速度低下が発生します。これを避けるにはデータをキャッシュ可能なメモリにコピーして、
// コピーされたデータにアクセスします。


#define BIT_1(                                                    b0)	static_cast<uint>((b0 )<< 0                                                            )
#define BIT_2(                                                 b1,b0)	static_cast<uint>((b1 )<< 1 | BIT_1 (                                               b0))
#define BIT_3(                                              b2,b1,b0)	static_cast<uint>((b2 )<< 2 | BIT_2 (                                            b1,b0))
#define BIT_4(                                           b3,b2,b1,b0)	static_cast<uint>((b3 )<< 3 | BIT_3 (                                         b2,b1,b0))
#define BIT_5(                                        b4,b3,b2,b1,b0)	static_cast<uint>((b4 )<< 4 | BIT_4 (                                      b3,b2,b1,b0))
#define BIT_6(                                     b5,b4,b3,b2,b1,b0)	static_cast<uint>((b5 )<< 5 | BIT_5 (                                   b4,b3,b2,b1,b0))
#define BIT_7(                                  b6,b5,b4,b3,b2,b1,b0)	static_cast<uint>((b6 )<< 6 | BIT_6 (                                b5,b4,b3,b2,b1,b0))
#define BIT_8(                               b7,b6,b5,b4,b3,b2,b1,b0)	static_cast<uint>((b7 )<< 7 | BIT_7 (                             b6,b5,b4,b3,b2,b1,b0))
#define BIT_9(                            b8,b7,b6,b5,b4,b3,b2,b1,b0)	static_cast<uint>((b8 )<< 8 | BIT_8 (                          b7,b6,b5,b4,b3,b2,b1,b0))
#define BIT_10(                        b9,b8,b7,b6,b5,b4,b3,b2,b1,b0)	static_cast<uint>((b9 )<< 9 | BIT_9 (                       b8,b7,b6,b5,b4,b3,b2,b1,b0))
#define BIT_11(                    b10,b9,b8,b7,b6,b5,b4,b3,b2,b1,b0)	static_cast<uint>((b10)<<10 | BIT_10(                    b9,b8,b7,b6,b5,b4,b3,b2,b1,b0))
#define BIT_12(                b11,b10,b9,b8,b7,b6,b5,b4,b3,b2,b1,b0)	static_cast<uint>((b11)<<11 | BIT_11(                b10,b9,b8,b7,b6,b5,b4,b3,b2,b1,b0))
#define BIT_13(            b12,b11,b10,b9,b8,b7,b6,b5,b4,b3,b2,b1,b0)	static_cast<uint>((b12)<<12 | BIT_12(            b11,b10,b9,b8,b7,b6,b5,b4,b3,b2,b1,b0))
#define BIT_14(        b13,b12,b11,b10,b9,b8,b7,b6,b5,b4,b3,b2,b1,b0)	static_cast<uint>((b13)<<13 | BIT_13(        b12,b11,b10,b9,b8,b7,b6,b5,b4,b3,b2,b1,b0))
#define BIT_15(    b14,b13,b12,b11,b10,b9,b8,b7,b6,b5,b4,b3,b2,b1,b0)	static_cast<uint>((b14)<<14 | BIT_14(    b13,b12,b11,b10,b9,b8,b7,b6,b5,b4,b3,b2,b1,b0))
#define BIT_16(b15,b14,b13,b12,b11,b10,b9,b8,b7,b6,b5,b4,b3,b2,b1,b0)	static_cast<uint>((b15)<<15 | BIT_15(b14,b13,b12,b11,b10,b9,b8,b7,b6,b5,b4,b3,b2,b1,b0))

#define BIT_SHIFT_MASK(value, shift, mask) (((value) >> (shift)) & ((1<<(mask))-1))


