//
//  SampleStream.m
//

#import "SampleStream.h"

#import <sys/stat.h>

@implementation SampleStream

- (id)initWithTuner:(uint)tuner isdb:(uint)isdb
{
    if ((self = [super init]) != nil)
    {
        char tmp[256];
        sprintf(tmp, "./tuner%d_ISDB_%c.ts", tuner, isdb == 0 ? 'S' : 'T');
        if ((_fp = fopen(tmp, "w")) == NULL)
        {
            NSLog(@"file open ng. %s", tmp);
            _fp = NULL;
        }
        else
        {
            _fd = fileno(_fp);
        }
        [self reset];
    }
    return self;
}

- (id)initWithTuner:(uint)tuner isdb:(uint)isdb fifo:(BOOL)fifo
{
    if ((self = [super init]) != nil)
    {
        _fp = NULL;

        char fifo[256];
        fifo[255] = '\0';
        snprintf(fifo, 255, "./tuner%d_ISDB_%c.ts", tuner, isdb == 0 ? 'S' : 'T');
        NSLog(@"FIFO: %s", fifo);

        BOOL success = NO;
        while (YES)
        {
            struct stat buf;
            if (stat(fifo, &buf) == 0)
            {
                if ((buf.st_mode & S_IFIFO) != S_IFIFO)
                {
                    NSLog(@"%s already exists. but is not FIFO.", fifo);
                    break;
                }
                // FIFOのフラッシュ必要？
                success = YES;
            }
            else if (errno == ENOENT)
            {
                if (mkfifo(fifo, S_IRWXU | S_IRWXG | S_IRWXG) < 0)
                {
                    NSLog(@"mkfifo ng.");
                    break;
                }

                success = YES;
            }
            break;
        }

        if (success)
        {
            if (fork() == 0)
            {
                char command[256];
                sprintf(command, "./mplayer %s", fifo);
                system(command);
                exit(0);
            }
            if ((_fd = open(fifo, O_WRONLY)) < 0)
            {
                NSLog(@"fifo open ng.");
            }
        }
        [self reset];
    }
    return self;
}

- (void)dealloc
{
    if (_fp)
    {
        fclose(_fp);
    }
    [super dealloc];
}

- (void)reset
{
    _count = 0;
    _packetCount = 0;
    _packetOffset = 0;
}

- (void)addPacket:(uint)packet
{
    uint packetCounter = BIT_SHIFT_MASK(packet, 26,  3);
    uint packetStart   = BIT_SHIFT_MASK(packet, 25,  1);
    uint packetData    = BIT_SHIFT_MASK(packet,  0, 24);

    // カウンタ値を確認
    uint count = BIT_SHIFT_MASK(_count, 0, 3);
    _count++;

    if (packetCounter != count)
    {
        NSLog(@"カウンタ値が異常です。");
    }

    // パケット開始位置フラグを確認
    if (packetStart)
    {
        if (BIT_SHIFT_MASK(packetData, 15, 1))
        {
//            NSLog(@"リードソロモン復号で訂正しきれなかったエラーがあります。");
        }
        else
        {
            // 同期バイトを確認
            if (BIT_SHIFT_MASK(packetData, 16, 8) != 0x47)
            {
                NSLog(@"パケットの先頭バイトが 0x47 になっていません。");
            }
        }

        if (_packetOffset != 0)
        {
            NSLog(@"前のパケットが完了しませんでした。");
        }
        _packetOffset = 0;
    }

    // データをコピー
    uint i;
    for (i = 0; i < 3; ++i)
    {
        if (_packetOffset < kPacketSize)
        {
            _buffer[kPacketSize * _packetCount + _packetOffset] = BIT_SHIFT_MASK(packetData, 8*(2-i), 8);
            _packetOffset++;
        }
    }

    if (kPacketSize <= _packetOffset)
    {
        // ひとつのパケットが完成
        _packetOffset = 0;

        if (kPageSize * kPageCount / kPacketSize <= ++_packetCount)
        {
            _packetCount = 0;
            write(_fd, _buffer, kPageSize * kPageCount);            
        }
    }
}

@end
