<?
// batch.php
// パブログバッチ処理スクリプト

// $argv[1] : バッチ処理タイプ: 'publog_batch'　←決め打ち
// $argv[2] : バッチ処理ID

$batch_type = $argv[1];	// バッチ処理タイプ: 'publog_batch'　←決め打ち
$batch_id = $argv[2];		// バッチ処理ID

if($batch_type != 'publog_batch')
{
	exit;
}

// ユーザー設定ファイル
$conf=parse_ini_file('publog_conf.ini',TRUE);
// 設定ファイル def 系
require_once("publog_def.ini");
// Smarty
// Smartyライブラリを読み込む
if(!file_exists(SMARTY_CLASS_FILE))
{
	require_once('Smarty.class.php');
}else{
	require_once(SMARTY_CLASS_FILE);
}
require_once("class/smarty.class.php");

// PUBLOG システム関数
require_once("func/mod.func.php");
require_once("func/error.func.php");
require_once("func/login.func.php");
require_once("func/project.func.php");
require_once("func/staff.func.php");
require_once("func/trip.func.php");
require_once("func/file.func.php");
require_once("func/html.func.php");
require_once("func/std.func.php");
require_once("func/publog.func.php");
require_once("func/ini.func.php");
require_once("func/base.func.php");

// include 配列
require_once('tpl/project/staff/authority.inc.php');

//////////
// global な変数たち

// login データセット
// user --- handle, email, authority, tripkey
// prj --- cd, name, exp, cat, status, homeurl
$logindat=array();
$prjdat=array();
$userdat=array();
// system データセット
$sysdat=array();
init_sysdat();

// メッセージデータ(言語メッセージ)
$smes=array();	// system message
$pmes=array();	// mod message

// ユーザーに戻す出力画面のデータ
// ret - title, body, header
$retvars=array();
$retvars['print']=true;
$retvars['body']="";
$retvars['usetpl']=true;
$retvars['tpl_enc']=PUBLOG_TPL_ENCODING;

// Smarty
$systpl = new Publog_Smarty;

// バッチ処理ファイルを読み込み
require_once(HIDDEN_BATCH_DIR.$batch_id.'.php');

// モジュール
if (!empty($vars['mod'])) {
	if (!exist_mod_action($vars['lv'],$vars['mod'])) {
		$s_mod = htmlspecialchars($vars['mod']);
		$msg = "mod=$s_mod is not implemented.";
		error_exit($msg);
	} else {
		$ret = do_mod_action($vars['lv'],$vars['mod']);
		if ($ret !== FALSE) {
			$base = array_key_exists('refer',$vars) ? $vars['refer'] : '';
		}
	}
}

header('Content-Type: text/html; charset='.PUBLOG_MIME_CHARSET);

// 画面作成
if($retvars['usetpl'])
{
	fetch_mod_tpl();

}
// 画面出力
file_put_contents('test_disp_out.txt',$retvars['body']);

unlink(HIDDEN_BATCH_DIR.$batch_id.'.php');	// バッチ処理ファイル削除

exit;

?>
