<?php
/*
 * $Id: publogdata.class.php,v 1.3 2004/10/25 21:55:01 fukami Exp $
 */
require_once('class/projectdata.class.php');

class PublogData
{
	var $baselist;
	var $base;
	var $projectlist;
	var $project;
	var $threadlist;
	var $thread;
	var $conf = array();
/*
	var $conf = array(
				'base' => array(
					'id' => null		// ex.) 'www.example.com/home/'
				),
				'project' => array(
					'cd' => null
				),
				'thread' => array(
					'id' => null
				)
			);
*/

	function PublogData($generator_conf = null)
	{
		$this->set_conf($generator_conf);
	}
	function set_conf($generator_conf)
	{
		if(empty($generator_conf)){
			return false;
		}
		$this->conf = array_merge($this->conf,$generator_conf);
	}
	function &create($name)
	{
		$ClassName = ucfirst($name).'Data';
		$this->$name =& new $ClassName($this->data_conf);
		$this->gen_data_conf($name);
		return $this->$name;
	}
	function &load($name,$generator_conf = null)
	{
		if(!empty($generator_conf))
		{
			$this->set_conf($generator_conf);
		}
		if(empty($this->$name))
		{
			$this->create($name);
		}else{
			$this->gen_data_conf($name);
		}
		$this->$name->load();

		return $this->$name;
	}

	function gen_data_conf($name)
	{
		$xpath = null;	// xml file path
		$tpath = null;	// template file path
		$sd =& $this->conf['xml_file']['sys_dir'];
		$bd =& $this->conf['xml_file']['base_dir'];
		$scd =& $this->conf['xml_file']['script_dir'];
		switch ($name)
		{
			case 'baselist':
				$xpath = 'node-x.org/baselist.xml';
			break;
			case 'base':
				$xpath = $sd.'base.xml';
			break;
			case 'projectlist':
				$xpath = $sd.'projectlist.xml';
			break;
			case 'project':
				$xpath = $bd.$this->conf['project']['cd'].'/sys/data/project/project.xml';
				$tpath = $scd.'mod/project/project/xml_templates/project_xml.tpl';
			break;
			case 'threadlist':
				$xpath = $bd.$this->conf['project']['cd'].'/data/threadlist.xml';
				$tpath = $scd.'mod/project/thread/xml_templates/threadlist_xml.tpl';
			break;
			case 'thread':
				$xpath = $bd.$this->conf['project']['cd'].'/data/'.$this->conf['thread']['type'].'/'.$this->conf['thread']['id'].'/thread.xml';
				$tpath = $scd.'mod/project/thread/xml_templates/thread_xml.tpl';
			break;
		}
		$data_conf = array(
			'xml_file' => array(
				'full_path' =>  $xpath
			),
			'data_template' => array(
				'full_path' => $tpath
			)
		);
		// set conf data
		$this->$name->set_conf($data_conf);
	}

}

?>
