<?php
/*
 * $Id: publogxmldata.class.php,v 1.11 2005/05/16 16:40:58 fukami Exp $
 * XML データの読み込み、書き出し基本処理クラス
 */
class PublogXMLData
{
	var $xml_parse_method = 'pxml';	// dom,pxml,sxml
// データ定義 ----------------------------------
	var $dom = null;	// DOM
	var $pxml = null; // PublogXMLParser object
	var $sxml = null; // SimpleXML

	var $xml_data_tpl = null;	// for Smarty object
	var $xml_data_string = null;

	var $page_tpl = null; // for Smarty object
	var $page_string = null; // page string date generated by Smarty
	var $conf = array(
		'xml_file' => array(
			'full_path' =>  null
		),
		'data_template' => array(
			'full_path' => null
		)
	);
// コンストラクタ ----------------------------------
	function PublogXMLData($conf = null)
	{
		$this->set_conf($conf);
	}
// 設定 ----------------------------------
	function set_conf($conf)
	{
		if(is_array($conf))
		{
			$this->conf = array_merge($this->conf,$conf);
		}else{
			return false;
		}
		return true;
	}
// データ操作 ----------------------------------

	function &merge($arr)
	{
		$this->pxml->node_data =& array_merge($this->pxml->node_data,$arr);
		return $this->pxml->node_data;
	}
// ファイル操作 ----------------------------------
	function new_xml_file($init_data = null)
	{
		if(file_exists($this->conf['xml_file']['full_path']))
		{
			return false;	// スレッド名重複
		}
		if(!file_exists($this->conf['data_template']['full_path']))
		{
			return false;	// 新規XMLデータ生成用のtemplateファイルが存在しない
		}
		$this->xml_data_tpl =& new Publog_Smarty;
		$init_data = array_phtmlenc($init_data);
		$this->xml_data_tpl->assign_by_ref('ini',$init_data);
		$this->xml_data_string = $this->xml_data_tpl->fetch($this->conf['data_template']['full_path']);
		$this->_save_string();
	}
	function _remove_xml_file()
	{
		if(empty($this->conf['xml_file']['full_path']))
		{
			return false;
		}
		if(!is_writable($this->conf['xml_file']['full_path']))
		{
			return false;
		}
		if(!unlink($this->conf['xml_file']['full_path']))
		{
			return false;
		}
		return true;
	}
// XMLファイルからXMLデータを読み込み ----------------------------------
	/*
	* load XML format string data from file.
	* file_get_contents [PHP5]
	* loadXML [PHP5]
	* saveXML [PHP5]
	*/
	function load()
	{
		if(empty($this->conf['xml_file']['full_path']))
		{
			return false;
		}
		if(!file_exists($this->conf['xml_file']['full_path']))
		{
			return false;	// データファイルが存在しない
		}
		if($this->xml_parse_method=='dom'){
			$this->dom = new domdocument();
			$this->dom->loadXML(file_get_contents($this->conf['xml_file']['full_path']));	//load XML String
		}elseif($this->xml_parse_method=='pxml'){
			$this->pxml = new PublogXMLParser;
			$this->pxml->load($this->conf['xml_file']['full_path']);
		}elseif($this->xml_parse_method=='sxml'){
	    $this->sxml = simplexml_load_file($this->conf['xml_file']['full_path']);
		}
		return true;
	}
	function &get_data()
	{
		return $this->pxml->node_data;
	}
// データ出力 ----------------------------------
	/*
	* XMLオブジェクト から XMLファイルへ出力
	* file_put_contents [PHP5]
	*/
	function check_dir()
	{
		return check_dir($this->conf['xml_file']['full_path']);
	}
	function _save($mode="add")
	{
		if($this->xml_parse_method=='dom'){
			if(empty($this->dom))
			{
				return false;
			}
			$this->xml_data_string =& $this->dom->saveXML();
		}elseif($this->xml_parse_method=='pxml'){
			if(empty($this->pxml))
			{
				return false;
			}
			$this->xml_data_string =& $this->pxml->xml2str();
		}elseif($this->xml_parse_method=='sxml'){
			if(empty($this->sxml))
			{
				return false;
			}
			$this->xml_data_string =& $this->sxml->asXML();
		}
		if(empty($this->xml_data_string))
		{
			return false;
		}
		if(!$this->check_dir())
		{
			return false;
		}
//		print_r($this->conf['xml_file']['full_path']);
		rename($this->conf['xml_file']['full_path'],$this->conf['xml_file']['full_path'].'.bak');
		file_put_contents($this->conf['xml_file']['full_path'],$this->xml_data_string);
		if($mode == "add")
		{
			if(filesize($this->conf['xml_file']['full_path']) < filesize($this->conf['xml_file']['full_path'].'.bak'))
			{
				rename($this->conf['xml_file']['full_path'],$this->conf['xml_file']['full_path'].'.err');
				rename($this->conf['xml_file']['full_path'].'.bak',$this->conf['xml_file']['full_path']);
			}
		}
	}
//		chmod($this->conf['xml_file']['full_path'],0707);
 /*
	* string からファイルへダイレクトに出力。内部処理用
	* file_put_contents [PHP5]
	*/
	function _save_string()
	{
		if(empty($this->xml_data_string))
		{
			return false;
		}
		if(!$this->check_dir())
		{
			return false;
		}
//		print_r($this->conf['xml_file']['full_path']);
		file_put_contents($this->conf['xml_file']['full_path'],$this->xml_data_string);
		chmod($this->conf['xml_file']['full_path'],0707);
	}
// サブファンクション ----------------------------------
	function create_dir($dirname)
	{
		if(is_writable($dirname))
		{
			return false;
		}
		if(!mkdir($dirname))
		{
			return false;
		}
		return true;
	}
	function gen_id()
	{
		return base_convert(time(),10,36);
	}
	
// デバッグ ----------------------------------
	function testprint($data)	// for DEBUG
	{
		print("<p><pre>");
		print(htmlspecialchars($data));
		print("</pre></p>");
	}
	function testprint_r($data)	// for DEBUG
	{
		print("<p><pre>");
		print_r($data);
		print("</pre></p>");
	}
}


?>
