<?php
// スレッドデータ共通処理クラス
class ThreadData extends PublogXMLData
{
var $gen_thread_id_retry_max = 3;
var $thread_conf = array(
			'xml_file' => array(
				'base_dir' => null
			)
		);
// コンストラクタ ----------------------------------
	function ThreadData($conf = null)
	{
		$this->set_conf($conf);
	}
// データ操作 ----------------------------------
	function &get()
	{
		return $this->pxml->node_data['thread'];
	}
	function add($id=null)
	{
		if(!empty($id))
		{
			if(file_exists($this->thread_conf['xml_file']['base_dir'].$id))
			{
				return false;	// スレッド名重複
			}
			$this->conf['thread']['id'] = $id;
		}
		if(empty($this->conf['thread']['id']))
		{
			// 新規ID生成
			if(!($this->conf['thread']['id'] = $this->gen_thread_id()))
			{
				return false;
			}
		}
		// スレッドデータディレクトリ生成
		$this->make_thread_dir();
	}
	function remove()
	{
		// スレッドリストからの削除
		// スレッド関連データの削除
	}
	function update()
	{
		// スレッドリストデータの修正
	}
// サブファンクション ----------------------------------
	function make_thread_dir()
	{
		$dirname=$this->thread_conf['xml_file']['base_dir'].$this->conf['thread']['id'];
		if(is_writable($dirname))
		{
			return false;
		}
		if(!mkdir($dirname))
		{
			return false;
		}
		return true;
	}
	function gen_thread_id()
	{
		for($i=0;$i<$this->gen_thread_id_retry_max;$i++)
		{
			$id = $this->gen_id();
			if(file_exists($this->thread_conf['xml_file']['base_dir'].$id))
			{
				sleep(1);
				continue;	// スレッド名重複
			}
			return $id;
		}
		return false;
	}
}

?>
