<?php
// $Id: xml.class.php,v 1.5 2005/06/13 16:38:22 fukami Exp $
// 参考: http://www.pat.hi-ho.ne.jp/dimension/sample/sample_xml_sax_rss.shtml

class Project extends PublogXMLParser
{
	var $prjdatafile=null;
	var $project_data=array();
	function Project()
	{
		$this->PublogXMLParser();
		$this->project_data =& $this->node_data;
	}
	function setProjectFile($filename)
	{
		$this->prjdatafile = $filename;
	}
	function loadProjectFile($filename=null)
	{
		if(!empty($filename)){
			$this->prjdatafile = $filename;
		}
		$this->parse($this->prjdatafile);
	}
}


/**
 * 各TOPIC（itemノード）を格納するクラス
 */
class Item
{
    var $data_;
    var $mode_;
    function setMode($mode)
    {
        $this->mode_ = $mode;
        if (!isset($this->data_[$mode])) { $this->data_[$mode] = ""; }
    }
    function getMode() { return $this->mode_; }
    function put($str) { $this->data_[$this->mode_] = $str; }
    function get() { return $this->data_; }
}

/**
 * 最終的なTOPICの配列。それぞれの要素は、Itemオブジェクトとなる
 */
$items = array();

/**
 * 現在処理を行っているItemオブジェクト
 */
$currentItem = null;


/**
 * PUBLOG_XMLパーサクラス
 */
class PublogXMLParser
{
	var $before_node=null;
	
	var $xml_parser=null;
	var $node_stack = array();
	var $node_ctr = array();
	var $node_data = array();	// 配列に展開されたデータ本体
	var $xmlstr=null;
	var $prev_node = array( 'name' => null, 'ctr' => null );
	function PublogXMLParser()
	{
		$handler_start='startHandler';
		$handler_end='endHandler';
		$handler_char='charDataHandler';
		$this->xml_parser = xml_parser_create('UTF-8');
		xml_set_object($this->xml_parser, $this);
		$this->itemname = $itemname;
		/**
		 * 各ハンドラを設定する
		 */
        xml_parser_set_option(
            $this->xml_parser,
            XML_OPTION_CASE_FOLDING,
            false);
        xml_set_element_handler(
            $this->xml_parser,
            $handler_start,
            $handler_end);
        xml_set_character_data_handler(
            $this->xml_parser,
            $handler_char);
    }

    /**
     * 引数には、ファイル名かURLを指定
     */
    function load($file) {
        if (!($fp = fopen($file, "r"))) {
            die("could not open XML input");
        }
        while ($data = fread($fp, 4096)) {
            if (!xml_parse($this->xml_parser, $data, feof($fp))) {
							$error_message=sprintf("XML error: %s at line %d column %d  file name $file",
														xml_error_string(xml_get_error_code($this->xml_parser)),
														xml_get_current_line_number($this->xml_parser),
														xml_get_current_column_number($this->xml_parser));
							file_put_contents('xml_error.txt',$error_message."\n");
            }
        }
        xml_parser_free($this->xml_parser);
				$this->node_data = xml_array_sanitize($this->node_data);
    }

		/**
		 * 引数には、arrayを指定
		 */
		function &array_load(&$arr) {
			foreach($arr as $data)
			{
				if (!xml_parse($this->xml_parser, $data, false)) {
					$error_message=sprintf("XML error: %s at line %d column %d  file name $file",
						xml_error_string(xml_get_error_code($this->xml_parser)),
						xml_get_current_line_number($this->xml_parser),
						xml_get_current_column_number($this->xml_parser));
					file_put_contents('xml_error.txt',$error_message."\n");
				}
			}
			xml_parse($this->xml_parser, null, true);
			xml_parser_free($this->xml_parser);
			$this->node_data = xml_array_sanitize($this->node_data);
			return $this->node_data;
		}



	/**
	 * PUBLOG簡易汎用XML処理(SAX)
	 * ちょっと特殊: タグの中に attr id , もしくは子要素に<id></id>をみつけて、 name__id
	 * という key でツリーの中に押し込みます。(id がないと、データが崩れます)
	 */
	function startHandler($parser, $name, $attrs)
	{
		if(empty($attrs))
		{
			array_unshift($this->node_stack,$name);
		}else{
			if(!empty($attrs['id']))
			{
				array_unshift($this->node_stack,$name.'__'.trim($attrs['id']));
			}else{
				array_unshift($this->node_stack,$name);
			}
		}
		return;
	}
	function endHandler($parser, $name)
	{
		$pos = strpos($this->node_stack[0],'__');
		$nodename=null;
		if($pos === false or $pos == 0 or $pos == '')
		{
			$nodename = $this->node_stack[0];
		}else{
			$nodename=substr($this->node_stack[0],0,$pos);
		}
		if($nodename != $name)
		{
			exit("XML data is not well-formed.");
		}
		array_shift($this->node_stack);
		$this->node_ctr[$name]++;
		return;
	}
	function charDataHandler($parser, $data)
	{
		if($this->node_stack[0]=='id')
		{
			$data = trim($data);
		}
		if($this->before_node != $this->node_stack[0])
		{
			if(""==trim($data)) return;
		}
		$this->before_node = $this->node_stack[0];
		if($this->node_stack[0] == 'id' and
				(count($this->node_stack) > 2) and
				!preg_match('/__/',$this->node_stack[1])){
			$pnode=null;
			$rstack=array_reverse($this->node_stack);
			array_pop($rstack);
			array_pop($rstack);
			foreach($rstack as $val){
				if(empty($pnode))
					$pnode =& $this->node_data[$val];
				else
					$pnode =& $pnode[$val];
			}
			if(!empty($pnode)){
				$pnode[$this->node_stack[1].'__'.$data] = $pnode[$this->node_stack[1]];
				$pnode[$this->node_stack[1]]=null;
				unset($pnode[$this->node_stack[1]]);
			}
			$this->node_stack[1]=$this->node_stack[1].'__'.$data;
		}
		$reval=array();
		foreach($this->node_stack as $val){
			if(empty($reval)){
				$reval = array($val=>$data);
			}else{
				$reval = array($val=>$reval);
			}
		}
		$this->node_data=array_merge_recursive($this->node_data,$reval);
		return;
	}
	
	function node_path_check($path)
	{
		if(preg_match('/^[\/]+(.+)$/',$path,$regs)){
				$path = $regs[1];
		}
		if(preg_match('/^(.+[^\/])[\/]+$/',$path,$regs)){
				$path = $regs[1];
		}
		$pathstack = preg_split('/\//',$path);
		return $pathstack;
	}
	function &get_node_pointer($pathstack)
	{
		$pnode =& $this->node_data;
		foreach($pathstack as $val){
			if(array_key_exists($val,$pnode))
				$pnode =& $pnode[$val];
			else
				return false;
		}
		return $pnode;
	}
	// id オプション付きデータを連番添え字の配列にして返す
	// $path  ex.) '/feed/entry'
	function &get_array($path){
		$pathstack = $this->node_path_check($path);
		$target = array_pop($pathstack);
		$pnode =& $this->get_node_pointer($pathstack);
		$out = array();
		if(empty($pnode))
			return false;
		foreach($pnode as $key => $val){
			if($target == $key)	// 配列要素が一つのとき
				$out[]=$val;
			if(preg_match('/^'.$target.'__/',$key)){
				$out[]=$val;
			}
		}
		if(empty($out))
			return false;
		return $out;
	}
	// id オプション付きデータの中でidが条件に合うもののみ連番添え字の配列にして返す
	// $path  ex.) '/feed/entry'
	// $pattern 正規表現
	function &get_array_id_search($path,$pattern){
		$pathstack = $this->node_path_check($path);
		$target = array_pop($pathstack);
		$pnode =& $this->get_node_pointer($pathstack);
		$out = array();
		if(empty($pnode))
			return false;
		foreach($pnode as $key => $val){
			if($target == $key)
				$out[]=$val;
			if(preg_match('/^'.$target.'__'.$pattern.'/',$key)){
				$out[]=$val;
			}
		}
		if(empty($out))
			return false;
		return $out;
	}
	
	function &get_node($path)
	{
		$pathstack = $this->node_path_check($path);
		$target = array_pop($pathstack);
		$pnode =& $this->get_node_pointer($pathstack);
		return $pnode;
	}

	function rm_node($path)
	{
		$pathstack = $this->node_path_check($path);
		$target = array_pop($pathstack);
print("<p>target[".$target."]</p>");
		$pnode =& $this->get_node_pointer($pathstack);
		$pnode[$target] = null;
		unset($pnode[$target]);
		return true;
	}


	function xml2str_keys($key)
	{
		$keys = array();
		if(empty($key))
		{
			$keys['key'] = null;
			$keys['identifier'] = null;
			return $keys;
		}
		if(preg_match('/^([a-z0-9\-\_]+)__([a-z0-9]+)$/i',$key,$matches))
		{
			$keys['key'] = $matches[1];
			$keys['identifier'] = $matches[2];
		}else{
			$keys['key'] = $key;
			$keys['identifier'] = '';
		}
		return $keys;
	}
	
	function xml2str_body($param,$key="")
	{
		$tabs=null;
		for($i=1;$i<$this->tabnum_static;$i++)
			$tabs.="\t";
		$this->tabnum_static++;
		$keys = $this->xml2str_keys($key);
		if (is_array($param))
		{
			if(!empty($keys['key']))
			{
				if(!empty($keys['identifier'])){
					$this->xmlstr.=$tabs."<".$keys['key']." id=\"".$keys['identifier']."\">\n";
				}else{
					$this->xmlstr.=$tabs."<".$keys['key'].">\n";
				}
			}
			foreach($param as $k => $v)
			{
				if(is_numeric($k))
				{
					$this->xmlstr.=$v;
				}else{
					$this->xml2str_body($v,$k);
				}
			}
	//		array_map('xml2str_body',$param,array_keys($param));
			if(!empty($keys['key']))
			{
				$this->xmlstr.=$tabs."</".$keys['key'].">\n";
			}
		}
		else
		{
			if(!empty($keys['key']))
			{
				if(!empty($keys['identifier'])){
					$this->xmlstr.=$tabs."<".$keys['key']." id=\"".$keys['identifier']."\">".
						$param."</".$keys['key'].">\n";
				}else{
					$this->xmlstr.=$tabs."<".$keys['key'].">".$param."</".$keys['key'].">\n";
				}
			}
		}
		$this->tabnum_static--;
	}
	var $tagnum_static = 0;
	function &xml2str($rootkey=null)
	{
		$this->tabnum_static = 0;
		$this->xmlstr=null;
		$node_data = array_phtmlenc($this->node_data);
		$this->xml2str_body($node_data,$rootkey="");
		$out=null;
		$out.="<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
		$out.=$this->xmlstr;
		return $out;
	}


}





/**
 * RSS処理関数(SAX)
 */
function _XMLParser_rss_startElement($parser, $name, $attrs)
{
    global $currentItem;
    if ($name == "item") {
        $currentItem = new Item();
    }
    if ($currentItem != null) {
        $currentItem->setMode($name);
    }
}
function _XMLParser_rss_endElement($parser, $name)
{
    global $items, $currentItem;
    if ($name == "item") {
        if ($currentItem != null) {
            array_push($items, $currentItem);
            $currentItem = null;
        }
    }
}
function _XMLParser_rss_charData($parser, $data)
{
    global $currentItem;
    $data = mb_convert_encoding($data, "UTF-8", "auto");
    if ($currentItem != null) {
        $currentItem->put($data);
        $currentItem->setMode("");
    }
}

?>