<?php
// エラーメッセージを表示して終了
function error_exit($msg)
{
	$mime_charset=PUBLOG_MIME_CHARSET;
	$title = PUBLOG_SYSTEM_NAME_VER." warning:";
	$body = <<<EOD
<h3>$title</h3>
「<strong> $msg </strong>」
EOD;

	header('Content-Type: text/html; charset=$mime_charset');
	$out = <<<EOD
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
 <head>
  <title>$title</title>
  <meta http-equiv="content-type" content="text/html; charset=$mime_charset">
 </head>
 <body>
 $body
 </body>
</html>
EOD;

	print(mb_convert_encoding($out,PUBLOG_HTTP_OUTPUT_ENCODING,PUBLOG_INTERNAL_ENCODING));
	exit();
}

function error_out($msg)
{
	$mime_charset=PUBLOG_MIME_CHARSET;
	$title = PUBLOG_SYSTEM_NAME_VER." warning:";
	$body = <<<EOD
<h3>$title</h3>
$msg 
EOD;


	return prj_html_out($title,$body);
}

?>
