<?php
//ita.func.php
//板関連関数

function &get_ita_setting($prjcd){
	$setfile=APATH_HOME_DIR."$prjcd/ita.ini";
	if(!file_exists($setfile)){
		error_exit("err get ".$setfile);
	}
	return parse_ini_file($setfile,FALSE);
}

function upd_itapage($prjcd)
{
	$data=gen_ita_top($prjcd);
	$filename=APATH_DATA_DIR.$prjcd."/index.html";
	$fp=pfopen($filename,"w");
	pfwrite($fp,$data);
	pfclose($fp);
	chmod($filename,0777);
}


function create_top_thread_data($prjcd){
	$tailrange=10;
	$viewrange=10;
	$threadlist=load_threadlist($prjcd);
	$count_threadlist = count($threadlist);
	$outdata="";
	for($i=0;($i<$count_threadlist)&&($i<$viewrange);$i++){	// 箱ループ

		$sortarr=split(":",$threadlist[$i][2]);
		$thread_type=$sortarr[0];	// スレッドのタイプ

	$func = 'create_top_thread_data_'.$thread_type;
	$thread_data="";
	if (function_exists($func))
	{
		$thread_data=call_user_func($func,$prjcd,$threadlist[$i],$i,$tailrange);
	}

		$outdata.=$thread_data;
	}
	return $outdata;
}

// 固定HTMLページ再構築
function fixed_html_ita_bapge_rebuild($prjcd){
	$threadlist=load_threadlist($prjcd);
	$count_threadlist = count($threadlist);
	$outdata="";
	for($i=0;$i<$count_threadlist;$i++){	// 箱ループ
		$threaddata=&load_mfbbs_thread_data($prjcd,$threadlist[$i][1]);
		$sortarr=split(":",$threadlist[$i][2]);
		$thread_type=$sortarr[0];	// スレッドのタイプ
		
		$func = 'upd_page_'.$thread_type;
		$thread_data="";
		if (function_exists($func))
		{
			$thread_data=call_user_func($func,$prjcd,$threadlist[$i][1],$threaddata);
		}else{
			if(DEBUG) print("Can not find function [".$func."], skip.");
		}

		$outdata.=$thread_data;
	}
	return $outdata;
}

// 板トップデータ生成
function &gen_ita_top($prjcd){
	// 案セッティング取得
	$setting=get_ita_setting($prjcd);
	$thread_title_contents = create_top_thread_title_view($prjcd);
	$thread_title_view = "<table width=\"95%\" bgcolor=#ddffdd border=1 cellspacing=7 cellpadding=3>";
	$thread_title_view .= "<tr><td>";
	$thread_title_view .= "<b>".$setting["TITLE"]."</b><br>";
	$thread_title_view .= "<font size=\"-1\">";
	$thread_title_view .= $thread_title_contents;
//	$thread_title_view .= "<p align=right><a href=\"subback.html\" target=_blank>一覧はこちら</a></p>";
	$thread_title_view .= "<p align=right><a href=\"prjtool".PUBLOG_PHP_EXTENSION."?action=view_subback\" target=_blank>一覧はこちら</a></p>";
	$thread_title_view .= "</font></td></tr></table>";
	
	$thread_data = create_top_thread_data($prjcd);
	
	$outdata="";

	$outdata.="<p>";
	$outdata.="<center>";
	$outdata.="<img src=\"".$setting["TITLE_PICTURE"]."\" border=0>";
	
	$outdata.="<table width=\"95%\" bgcolor=#ddffdd border=1 cellspacing=7 cellpadding=3>";
	$outdata.="<tr><td>";
	$outdata.=load_ita_info_file($prjcd);	// インフォ
	$outdata.="</td></tr></table>";

	$outdata.="<p>";

	$outdata.=$thread_data;
	$outdata.="</dl><p><hr><p>";
	
		$outdata.="<table width=\"95%\" bgcolor=#ddffdd border=1 cellspacing=7 cellpadding=3>";
		$outdata.="<tr><td>";
		$outdata.="<b>新しいスレッドを作る</b><p>";
		$outdata.="<form action=\"".HTTP_SCRIPT_DIR."hako".PUBLOG_PHP_EXTENSION."\" method=post>";
		$outdata.="<input type=hidden name=anid value=$prjcd>";
		$outdata.="<input type=hidden name=action value=\"\">";
		$outdata.="<input type=submit value=\"新しいスレッドを作る\">";
		$outdata.="</form>";
		$outdata.="</td></tr></table>";


	return $outdata;
}

// 箱一覧をつくる
function create_subback($prjcd){

	$outdata=gen_subback($prjcd);

	$outfilename=APATH_DATA_DIR."$prjcd/subback.html";
	$outfp=pfopen($outfilename,"w");
	fwrite($outfp,$outdata);
	pfclose($outfp);
	chmod($outfilename,0777);
}
// 箱一覧をつくる
function gen_subback($prjcd){
	$subbackrange=100;
	$threadlist=load_threadlist($prjcd);
	$count_threadlist = count($threadlist);
	$tabledata="";
	for($i=0;($i<$count_threadlist)&&($i<$subbackrange);$i++){	// 箱ループ
		$tabledata.=($i+1).":";
		$tabledata.="<a href=\"".HTTP_DATA_DIR.$prjcd."/".$threadlist[$i][1].".html\">";
		$tabledata.=$threadlist[$i][3];
		$tabledata.="(".$threadlist[$i][4].")";	// 書き込み数
		$tabledata.="</a> ";
	}

	$outdata="";
	$outdata.="<html><body><font size=\"-1\">";
	$outdata.=$tabledata;
	$outdata.="</font></body></html>\n";

	return $outdata;
}


function &load_ita_info_file($prjcd){
	$fp = pfopen(APATH_HOME_DIR.$prjcd."/itainfo.txt", "r");
	if(!$fp) {
		echo "err load info.txt\n";
		exit;
	}
	$infodata="";
	while(!feof($fp)) {
		$line = fgets($fp,4096);
		$line=trim($line);
		if($line==""){
			continue;
		}
		$infodata.=$line;
		
	}
	pfclose($fp);
	return $infodata;
}



// トップスレッド一覧データ生成
function create_top_thread_title_view($prjcd){
	$toprange=10;
	$viewrange=30;
	
	$threadlist=load_threadlist($prjcd);
	$count_threadlist = count($threadlist);
	$tabledata="";
	for($i=0;($i<$count_threadlist)&&($i<$toprange);$i++){	// 箱ループ
		$tabledata.=($i+1).":";
		$tabledata.="<a href=\"#".($i+1)."\">";
		$tabledata.=$threadlist[$i][3];	// タイトル
		$tabledata.="(".$threadlist[$i][4].")";	// 書き込み数
		$tabledata.="</a> ";
	}
	if($toprange<$count_threadlist){
		for($i=($toprange);($i<$count_threadlist)&&($i<$viewrange);$i++){	// 箱ループ
			$tabledata.=($i+1).":";
			$tabledata.="<a href=\"".HTTP_DATA_DIR.$prjcd."/".$threadlist[$i][1].".html\">";
			$tabledata.=$threadlist[$i][3];
			$tabledata.="(".$threadlist[$i][4].")";	// 書き込み数
			$tabledata.="</a> ";
		}
		
	}
	return $tabledata;
}

?>
