<?
//プラグインが存在するか確認し、存在すれば展開
// name:プラグイン名, level:プラグインレベル, tty:スレッドタイプ(levelがresのときだけ)

// テンプレートファイル名を取得
function get_tpl_filename($lv,$mod,$cmd,$trans)
{
	//テンプレートディレクトリ？
	$tpl=TPL_DIR.$lv.'/'.$mod.'/'.SITE_PREFIX.'.'.$cmd.'.'.$trans.'.tpl';
	if (file_exists($tpl) and is_readable($tpl))
	{
		return $tpl;
	}
	//テンプレートディレクトリ？
	$tpl=TPL_DIR.$lv.'/'.$mod.'/'.$cmd.'.'.$trans.'.tpl';
	if (file_exists($tpl) and is_readable($tpl))
	{
		return $tpl;
	}
	//モジュールディレクトリ内のテンプレートディレクトリ？
	$tpl=MOD_DIR.$lv.'/'.$mod.'/tpl/'.SITE_PREFIX.'.'.$cmd.'.'.$trans.'.tpl';
	if (file_exists($tpl) and is_readable($tpl))
	{
		return $tpl;
	}
	//モジュールディレクトリ内のテンプレートディレクトリ？
	$tpl=MOD_DIR.$lv.'/'.$mod.'/tpl/'.$cmd.'.'.$trans.'.tpl';
	if (file_exists($tpl) and is_readable($tpl))
	{
		return $tpl;
	}
	//モジュールディレクトリ内のスケルトンディレクトリ？
	$tpl=MOD_DIR.$lv.'/'.$mod.'/skelton/'.SITE_PREFIX.'.'.$cmd.'.'.$trans.'.tpl';
	if (file_exists($tpl) and is_readable($tpl))
	{
		return $tpl;
	}
	//モジュールディレクトリ内のスケルトンディレクトリ？
	$tpl=MOD_DIR.$lv.'/'.$mod.'/skelton/'.$cmd.'.'.$trans.'.tpl';
	if (file_exists($tpl) and is_readable($tpl))
	{
		return $tpl;
	}

	error_exit('lv='.$lv.', mod='.$mod.', cmd='.$cmd.', trans='.$trans.' (tpl file) is not found.');
}

function exist_mod($lv,$name)
{
	switch ($lv)
	{
		case 'core':
			$modfile=MOD_DIR.'core/'.$name.'/'.$name.'.inc.php';
			break;
		case 'base':
			$modfile=BASE_MOD_DIR.$name.'/'.$name.'.inc.php';
			break;
		case 'project':
			$modfile=PROJECT_MOD_DIR.$name.'/'.$name.'.inc.php';
			break;
		case 'thread':
			$modfile=THREAD_MOD_DIR.$name.'/'.$name.'.inc.php';
			break;
		default :
			error_exit("mod level error.");
	}

	if (preg_match('/^\w{1,64}$/',$name)
		and file_exists($modfile))
	{
		require_once($modfile);
		return TRUE;
	}
	print("error".$modfile);
	return FALSE;
}
function exist_mod_action($lv,$name)
{
	if (!exist_mod($lv,$name))
	{
		return FALSE;
	}
	return function_exists('mod_action');
}
//初期化
function do_mod_init()
{
	load_mod_message();

	$func = 'mod_init';
	if (function_exists($func))
	{
		@call_user_func($func);
		return TRUE;
	}
	return FALSE;
}

function do_mod_action($lv,$name)
{
	if (!exist_mod_action($lv,$name))
	{
		return array();
	}
	
	do_mod_init();
	return call_user_func('mod_action');
}

function load_mod_skelton()
{
	global $smes,$pmes;
	global $vars;
	global $logindat;
	$skelton=MOD_DIR.$vars['lv'].'/'.$vars['mod'].'/skelton/'.
						$vars['cmd'].'.'.$vars['trans'].'.php';
	if (!file_exists($skelton)||!is_readable($skelton))
	{
		error_exit($skelton.'(skelton file) is not found.');
	}
	require($skelton);
	if(function_exists('do_mod_proc_disp'))
	{
		do_mod_proc_disp();	// あれば実行なければあきらめる ;-p
	}else{
		die("module not found.");
	}
	return;
}

function load_mod_message()
{
	global $pmes;
	global $vars;

	$mesdir=MESSAGE_DIR.$vars['lv'].'/';
	$pmes=load_message($mesdir,$vars['mod']);
	return;
}

function fetch_mod_tpl()
{
	global $vars, $retvars;
	global $systpl;
	
	$systpl->init_assign();

	if (!empty($retvars['body_tpl']))
	{
		$tpl=$retvars['body_tpl'];
	}else{
	 	$tpl=get_tpl_filename($vars['lv'],$vars['mod'],$vars['cmd'],$vars['trans']);
/*		//テンプレートディレクトリ？
		$tpl=TPL_DIR.$vars['lv'].'/'.$vars['mod'].'/'.$vars['cmd'].'.'.$vars['trans'].'.tpl';
		if (!file_exists($tpl) or !is_readable($tpl))
		{
			//モジュールディレクトリ内のテンプレートディレクトリ？
			$tpl=MOD_DIR.$vars['lv'].'/'.$vars['mod'].'/tpl/'.$vars['cmd'].'.'.$vars['trans'].'.tpl';
			if (!file_exists($tpl) or !is_readable($tpl))
			{
				//モジュールディレクトリ内のスケルトンディレクトリ？
				$tpl=MOD_DIR.$vars['lv'].'/'.$vars['mod'].'/skelton/'.$vars['cmd'].'.'.$vars['trans'].'.tpl';
				if (!file_exists($tpl)||!is_readable($tpl))
				{
						error_exit($tpl.'(tpl file) is not found.');
				}
			}
		}
*/
	}
	$systpl->assign('body_tpl_name',$tpl);
	$retvars['smarty']=true;
	if($retvars['main_tpl']=="")
		$retvars['main_tpl']='tool_main.tpl';

	$mtpl = APATH_SCRIPT_DIR.'smarty/templates/'.SITE_PREFIX.'.'.$retvars['main_tpl'];
	if (defined('SITE_PREFIX') and file_exists($mtpl) and is_readable($mtpl))
	{
		$retvars['main_tpl'] = SITE_PREFIX.'.'.$retvars['main_tpl'];
	}


	if($retvars['body_as_main'])
	{
		$retvars['body'] =& $systpl->fetch($tpl);
	}else{
		$retvars['body'] =& $systpl->fetch($retvars['main_tpl']);
	}
}

?>
