<?php
// 新規プロジェクト作成
function create_new_project($prjcd,$prjname,$setsumei,$bbscode,$designthema,
	$email,$newpassword,$ownerhandlename)
{
	require_once('class/publogdata.class.php');
	$prjtype = "blog"; // デフォルト値

	setcookie("mfbbs_prjcd",$prjcd,time()+(3600*36));
	setcookie("mfbbs_tripkey",$newpassword,time()+(3600*36));
	setcookie("mfbbs_email",$email,time()+(3600*36));

	// 新規プロジェクトディレクトリ作成
	prj_insert_new_project_dir($prjcd);

	// 新規プロジェクトレコード挿入
	prj_insert_new_project($prjcd,$prjname,
	$setsumei,$bbscode);

	$link=URL_HOME_DIR."/".$prjcd."/";

	// データオブジェクト ====================
	$publogdata_conf = array(
				'project' => array(
					'cd' => $prjcd
				),
				'xml_file' => array(
					'sys_dir' => SYS_DIR,
					'base_dir' => APATH_HOME_DIR,
					'script_dir' => APATH_SCRIPT_DIR
				)
			);
	$publogdata = new PublogData($publogdata_conf);
	// プロジェクトファイルの生成(xml)
	$ini_project = array(
		'project' => array(
			'cd' => $prjcd,
			'title' => $prjname,
			'tagline' => $setsumei,
			'link' => $link,
			'language' => LANG
		)
	);
	$project =& $publogdata->create('project');
	$project->new_xml_file($ini_project);


	// スタッフリスト新規追加(owner)
	$trip_matcha=gen_trip_matcha($newpassword);	// matchaトリップ生成
	stafflist_add($prjcd,$trip_matcha,$ownerhandlename,$email,"owner");

	// blog デフォルトデザインテンプレートコピー
	$src_dirname = APATH_SCRIPT_DIR.'default_design/blog/text';
	$dest_dirname = APATH_HOME_DIR.$prjcd.'/design/blog/default';
	if(!dir_copy_file($src_dirname,$dest_dirname))
	{
		echo '<p>publog warnning: default design file copy error.</p>';
	}
	
/*
	// 新規プロジェクトルートスレッド（板）初期設定ファイル等生成
	prj_create_new_project_ita_setting_file($prjcd,
	$prjname,$setsumei,$prjtype,$designthema);

	// 新規プロジェクトBBS初期スレ生成
	prj_create_new_project_default_thread_open($prjcd,
	$prjname,$prjtype);

	// ページテンプレートからHTML生成
	cnv_prj_template_file_to_html($prjcd,
	$prjname,$setsumei);
*/


	return;
}

// プロジェクト総数カウント
function project_count()
{
	$data_filename=APATH_PROJECT_DATA_FILE;
	$table=load_file_table($data_filename);
	if(!is_array($table) or empty($table) or null == $table)
	{
		$ct = 0;
	}else{
		$ct = count($table);
	}
	return $ct;
}
function prj_get_data($prjcd){
	$ret=array();
	if(!ereg("^[a-z][a-z0-9-]+$",$prjcd)){
		$ret['ret']=false;
		return $ret;
	}

	// データオープン
	$fp = pfopen(APATH_PROJECT_DATA_FILE, "r");
	if(!$fp) {
		error_exit("システム的な問題でログインできません");
	}
	$data=array();
	while(!feof($fp)) {
		$data=pfgetcsv($fp,2048,"\t");
		if($data[0]==$prjcd){
			$ret['ret']=true;
			$ret['data']=$data;
			pfclose($fp);
			return $ret;
		}
	}
	pfclose($fp);

	$ret['ret']=false;
	return $ret;
}
// ユーザーヘッダー

function get_editbbs_userheader($prjcd,$userdataset){
	if($userdataset["handle"]==""){
		return "";
	}
	$outdata="";
	$outdata.="<table bgcolor=#999999 width=\"100%\" cellpadding=0 cellspacing=1 border=0><tr bgcolor=#000055><td align=right>";
	$outdata.="<font size=\"-1\"><font color=#ffffff>Login... </font><font color=#ffcc00>".$userdataset["email"]."</font>";
	$outdata.="<font color=#ffffff> | ".$userdataset["handle"]." (".$prjcd.":".$userdataset["authority"].")";
	$outdata.="</td><td width=\"3%\" bgcolor=#888899 align=right><font size=\"-1\">";
	$outdata.=" <a href=\"triplogout".PUBLOG_PHP_EXTENSION."\">Logout</a> ";
	$outdata.="</font>";
	$outdata.="</td><td width=\"3%\" bgcolor=#887777 align=right><font size=\"-1\">";
	$outdata.=" <a href=\"prjtool".PUBLOG_PHP_EXTENSION."\">menu</a> ";
	$outdata.="</font>";
	$outdata.="</td></tr></table>";
	
	return $outdata;
}

// プロジェクトヘッダー
function header_txt($login_dataset,$title){
	$outdata="";
	$outdata.="<table bgcolor=#000055 width=\"100%\"><tr><td bgcolor=#dddddd>";
	$outdata.="<font color=#000000><b>";
	$outdata.=$login_dataset["prj"]["name"]."(".$login_dataset["prj"]["cd"].")";
	$outdata.="</b></font>";
	$outdata.="</td><td rowspan=2 width=1 nowrap bgcolor=#000055>";
//	$outdata.="<a href=\"prjtool".PUBLOG_PHP_EXTENSION."?action=editbbs_top_view\" target=_blank>Edit<br>BBS</a>";
	$outdata.="<a href=\"prjtool".PUBLOG_PHP_EXTENSION."?action=editbbs_top_view\" target=_blank><img src=\"img/new_button/edit.gif\" border=0></a>";
	$outdata.="</td><td rowspan=2 width=1 nowrap bgcolor=#000055>";
//	$outdata.="<a href=\"http://".$login_dataset["prj"]["homeurl"]."\" target=_blank>HOME</a>";
	$outdata.="<a href=\"http://".$login_dataset["prj"]["homeurl"]."\" target=_blank><img src=\"img/new_button/home.gif\" border=0></a>";
	$outdata.="</td><td align=right rowspan=2>";
	$outdata.="</td></tr>";
	$outdata.="<tr><td bgcolor=#333366>";
	$outdata.="<font size=\"-1\" color=#eeeeee><b>";
	$outdata.=$title;
	$outdata.="</b></font>";
	$outdata.="</td></tr>";
	$outdata.="</table>";

	return $outdata;
}

// プロジェクトフッター
function footer_txt($prjcd,$pass){
	$outdata="";

	$outdata.="<p>";
	$outdata.="<table bgcolor=#000055 width=\"100%\">";

	$outdata.="<form action=\"prjtool".PUBLOG_PHP_EXTENSION."?action=\" method=post>";
	$outdata.="<tr><td>";
	$outdata.="<input type=hidden name=prjcd value=\"".$prjcd."\">";
	$outdata.="<input type=hidden name=pass value=\"".$pass."\">";
	$outdata.="<input type=submit value=\"MENU\">";
	$outdata.="</td>";
	$outdata.="</form>";

	// 権限チェック
	if(	($userdataset["authority"]=="owner")||
		($userdataset["authority"]=="chief")||
		($userdataset["authority"]=="desk")||
		($userdataset["authority"]=="design") ){

		$outdata.="<form action=\"prjtool".PUBLOG_PHP_EXTENSION."?action=edit_file_select\" method=post>";
		$outdata.="<td>";
		$outdata.="<input type=hidden name=prjcd value=\"".$prjcd."\">";
		$outdata.="<input type=hidden name=pass value=\"".$pass."\">";
		$outdata.="<input type=submit value=\"編集\">";
		$outdata.="</td>";
		$outdata.="</form>";
		
		$outdata.="<form action=\"prjtool".PUBLOG_PHP_EXTENSION."?action=new_file_filename\" method=post>";
		$outdata.="<td>";
		$outdata.="<input type=hidden name=prjcd value=\"".$prjcd."\">";
		$outdata.="<input type=hidden name=pass value=\"".$pass."\">";
		$outdata.="<input type=submit value=\"新規\">";
		$outdata.="</td>";
		$outdata.="</form>";
		

		$outdata.="<form action=\"prjtool".PUBLOG_PHP_EXTENSION."?action=delete_file_select\" method=post>";
		$outdata.="<td>";
		$outdata.="<input type=hidden name=prjcd value=\"".$prjcd."\">";
		$outdata.="<input type=hidden name=pass value=\"".$pass."\">";
		$outdata.="<input type=submit value=\"削除\">";
		$outdata.="</td>";
		$outdata.="</form>";

		$outdata.="<form action=\"prjtool".PUBLOG_PHP_EXTENSION."?action=rename_file_select\" method=post>";
		$outdata.="<td>";
		$outdata.="<input type=hidden name=prjcd value=\"".$prjcd."\">";
		$outdata.="<input type=hidden name=pass value=\"".$pass."\">";
		$outdata.="<input type=submit value=\"RENAME\">";
		$outdata.="</td>";
		$outdata.="</form>";

		$outdata.="<form action=\"prjtool".PUBLOG_PHP_EXTENSION."?action=upload_file_select\" method=post>";
		$outdata.="<td>";
		$outdata.="<input type=hidden name=prjcd value=\"".$prjcd."\">";
		$outdata.="<input type=hidden name=pass value=\"".$pass."\">";
		$outdata.="<input type=submit value=\"UPLOAD\">";
		$outdata.="</td>";
		$outdata.="</form>";
		$outdata.="</td>";
		$outdata.="<td align=right>";
		$outdata.="<font color=#cccccc><b>".PUBLOG_SYSTEM_NAME_VER." project tool</b></font>";
		$outdata.="</tr></table>";
	} // 権限チェック


	$outdata.="<table width=\"100%\"><tr><td align=right>";
	$outdata.="<a href=\"".PUBLOG_HOME_URL."\">".PUBLOG_SYSTEM_NAME_VER."</a> ";
	$outdata.="</td></tr></table>";


	return $outdata;
}


// プロジェクトコード重複チェック
function prj_check_dup_prjcd($prjcd){
	$data_filename=APATH_PROJECT_DATA_FILE;
	if(!file_exists($data_filename)){
		return true;	// データファイルが存在しなかった場合は、重複がなかったことにする
	}
	$table=load_file_table($data_filename);
	reset($table);
	while(list($key,$val) = each($table)){
		if($val[0]==$prjcd){
			return false;
		}
	}
	return true;
}

// 新しいプロジェクトのディレクトリを作成
// 0.07.00 より bbs dir 廃止 designthema dir 廃止
function prj_insert_new_project_dir($prjcd){
	$home_dir=APATH_HOME_DIR.$prjcd;	// プロジェクトホームディレクトリ
//	$bbs_dir=APATH_DATA_DIR.$prjcd;	// プロジェクト編集板ディレクトリ
	$hidden_dir=HIDDEN_DIR.$prjcd;	// ユーザー隠しデータディレクトリ
	
	if(file_exists($home_dir)){
		error_exit("そのプロジェクトコードは使えません");
	}
//	if(file_exists($bbs_dir)){
//		error_exit("そのプロジェクトコードは使えません");
//	}
	if(file_exists($hidden_dir)){
		error_exit("そのプロジェクトコードは使えません");
	}
	//ホームディレクトリ
	mkdir($home_dir,0707);
	chmod($home_dir,0707);
	//BBSディレクトリ
//	mkdir($bbs_dir,0707);
//	chmod($bbs_dir,0707);
//	mkdir($bbs_dir."/data",0707);
//	chmod($bbs_dir."/data",0707);
//	mkdir($bbs_dir."/include",0707);
//	chmod($bbs_dir."/include",0707);
	//隠しディレクトリ
	mkdir($hidden_dir,0707);
	chmod($hidden_dir,0707);

//	$designthema_dir = $home_dir."/designthema";
//	if(!file_exists($designthema_dir))
//	{
//		mkdir($designthema_dir,0707);
//		chmod($designthema_dir,0707);
//	}
	$design_dir = $home_dir."/design";
	if(!file_exists($design_dir))
	{
		mkdir($design_dir,0707);
		chmod($design_dir,0707);
	}
	$design_blog_dir = $design_dir.'/blog';
	if(!file_exists($design_blog_dir))
	{
		mkdir($design_blog_dir,0707);
		chmod($design_blog_dir,0707);
	}
	$design_blog_default_dir = $design_blog_dir.'/default';
	if(!file_exists($design_blog_default_dir))
	{
		mkdir($design_blog_default_dir,0707);
		chmod($design_blog_default_dir,0707);
	}
//	$design_blog_default_current_dir = $design_blog_default_dir.'/current';
//	if(!file_exists($design_blog_default_current_dir))
//	{
//		mkdir($design_blog_default_current_dir,0707);
//		chmod($design_blog_default_current_dir,0707);
//	}
	
	$arc_dir = $home_dir."/archives";
	if(!file_exists($arc_dir))
	{
		mkdir($arc_dir,0707);
		chmod($arc_dir,0707);
	}
	$arc_blog_dir = $arc_dir.'/blog';
	if(!file_exists($arc_blog_dir))
	{
		mkdir($arc_blog_dir,0707);
		chmod($arc_blog_dir,0707);
	}

	$data_dir = $home_dir."/data";
	if(!file_exists($data_dir))
	{
		mkdir($data_dir,0707);
		chmod($data_dir,0707);
	}
	$data_blog_dir = $data_dir.'/blog';
	if(!file_exists($data_blog_dir))
	{
		mkdir($data_blog_dir,0707);
		chmod($data_blog_dir,0707);
	}

	$sys_dir = $home_dir."/sys";
	if(!file_exists($sys_dir))
	{
		mkdir($sys_dir,0707);
		chmod($sys_dir,0707);
	}
	//携帯用[Timeserver][2005/11/18][06:22]
	$m_dir = $home_dir."/m";
	if(!file_exists($m_dir))
	{
		mkdir($m_dir,0707);
		chmod($m_dir,0707);
	}
// windows だと symlink() 使えない…orz
//	$sysbbs_dir = $sys_dir."/bbs";
//	if(!file_exists($sysbbs_dir))
//	{
//		symlink($bbs_dir,$sysbbs_dir);
//		chmod($sysbbs_dir,0707);
//	}
}

// 新規プロジェクトレコード挿入
function prj_insert_new_project($prjcd,$prjname,$prjexp,$prjcat){
	$data_filename=APATH_PROJECT_DATA_FILE;
	$record="";
	$record.=$prjcd."\t";
	$record.=$prjname."\t";
	$record.=$prjexp."\t";
	$record.=$prjcat."\t";
	$record.="p\t";	// state[o/x/p]
	$record.=date("YmdHis")."\t";
	$record.=date("YmdHis")."\t";
	if(NO_SUBDOMAIN)
		$record.=URL_HOME_DIR."/".$prjcd."/\n";	// ホームURL
	else
		$record.=$prjcat.".".BASE_DOMAIN."/".$prjcd."/\n";	// ホームURL
	add_file($data_filename,$record);
}

// プロジェクトレコード更新
function prj_update_project_data($prjcd,$prjname,$prjexp,$prjcat,$state){
	$data_filename=APATH_PROJECT_DATA_FILE;
	if(!file_exists($data_filename)){
		print("システムエラー（データオブジェクトNOT FOUND),管理者に連絡してくだせい");
		exit;
	}
	$table=load_file_table($data_filename);
	$tcount=count($table);
	for($i=0;$i<$tcount;$i++){
		if($table[$i][0]==$prjcd){
			$table[$i][1]=$prjname;
			$table[$i][2]=$prjexp;
			$table[$i][3]=$prjcat;
			$table[$i][4]=$state;
			$table[$i][6]=date("YmdHis");
		}
	}
	// 書き戻しデータ作成
	reset($table);
	$data="";
	while(list($key,$val) = each($table)){
		if((""==$val[0])&&(""==$val[1])) continue;
		$data.=$val[0]."\t";
		$data.=$val[1]."\t";
		$data.=$val[2]."\t";
		$data.=$val[3]."\t";
		$data.=$val[4]."\t";
		$data.=$val[5]."\t";
		$data.=$val[6]."\t";
		$data.=$val[7]."\n";
	}
	write_file($data_filename,$data);
}

// プロジェクトレコード削除
function prj_del_project_data($prjcd){
	$data_filename=APATH_PROJECT_DATA_FILE;
	if(!file_exists($data_filename)){
		print("システムエラー（データオブジェクトNOT FOUND),管理者に連絡してくだせい");
		exit;
	}
	$table=&load_file_table($data_filename);
	// 書き戻しデータ作成
	reset($table);
	$data="";
	$val=array();
	while(list($key,$val) = each($table)){
		if((""==$val[0])&&(""==$val[1])) continue;
		if($val[0]==$prjcd) continue;	// skip
		$data.=$val[0]."\t";
		$data.=$val[1]."\t";
		$data.=$val[2]."\t";
		$data.=$val[3]."\t";
		$data.=$val[4]."\t";
		$data.=$val[5]."\t";
		$data.=$val[6]."\t";
		$data.=$val[7]."\n";
		$val=array();
	}
	write_file($data_filename,$data);
}

// 新規プロジェクトBBS初期設定ファイル等生成
function prj_create_new_project_ita_setting_file($prjcd,$prjname,$setsumei,$prjtype,$designthema){
//	require_once('func/designthema.func.php');
	// ita.ini 編集掲示板セッティング
	$setfile=APATH_HOME_DIR.$prjcd."/ita.ini";
	copy(DEFAULT_FILE_DIR."ita.ini",$setfile);
	chmod($setfile,0707);

	$wif = new WriteIniFile($setfile,FALSE,TRUE);
	$insdat=array();
	$insdat['TITLE']=$prjname;
	$insdat['TITLE_LINK']=HTTP_HOME_DIR.$prjcd."/";
	$wif->write_ini_file($insdat);

//	$data=load_file(DEFAULT_FILE_DIR."setting.txt");
//	$data=ereg_replace("<!title>",$prjname,$data);
//	$data=ereg_replace("<!title_picture>",HTTP_HOME_DIR.$prjcd."/bbstitle.gif",$data);
//	$data=ereg_replace("<!background_picture>",HTTP_HOME_DIR.$prjcd."/bbsbackground.gif",$data);
//	$data=ereg_replace("<!title_link>",HTTP_HOME_DIR ,$data);
//	write_file(APATH_HOME_DIR.$prjcd."/setting.txt",$data);

	// info.txt 編集掲示板の上に表示される説明文
	$info_data="<b>".$prjname."編集板</b><br>\n";
	$info_data.="<font size=\"-1\">";
	$info_data.=$setsumei;
	$info_data.="</font>\n";
	write_file(APATH_HOME_DIR.$prjcd."/itainfo.txt",$info_data);

	// デフォルトファイルディレクトリのファイル一覧を取得
	$filelist=prj_dir(DEFAULT_FILE_DIR);
	reset($filelist);
	// ファイルごとのループ
	while(list($key,$val) = each($filelist)){
		if(ereg("[.]gif$",$val)){	// すべてのGIFファイル
			copy(DEFAULT_FILE_DIR.$val,APATH_HOME_DIR.$prjcd."/".$val);
			chmod(APATH_HOME_DIR.$prjcd."/".$val,0707);
			continue;
		}
	}
	// デザインテーマファイルコピー
	prj_change_designthema($prjcd,$designthema);
	////
	// BBSディレクトリ関連
	// thread.txt 編集掲示板スレッドリストの空のものを用意
	$thread_data="\n";
	write_file(APATH_DATA_DIR.$prjcd."/thread.txt",$thread_data);
}




// 新規プロジェクト初期スレ生成
function prj_create_new_project_default_thread_open($prjcd,$prjname,$prjtype){
	// ■linksスレ
	// 箱(スレ)リストファイルに新規追加
//	ins_threadlist($prjcd,"links","oneline",$prjname."関連リンク集スレッド");
	// １行BBSファイルに初期書き込み
//	new_onelinefile($prjcd,"links",$prjname."関連リンク集スレッド",
//		$prjname."の関連リンクを収拾するスレッド",PUBLOG_SYSTEM_NAME_VER);
	// １行BBSファイルに書き込み
//	write_onelinefile($prjcd,"links",PUBLOG_SYSTEM_NAME_VER,"",PUBLOG_SYSTEM_NAME_VER,PUBLOG_SYSTEM_NAME_VER,PUBLOG_HOME_URL);

	// ■infoスレ
	// 箱(スレ)リストファイルに新規追加
	ins_threadlist($prjcd,"info","blog",$prjname."関連情報スレッド");
	// 編集BBSファイルに初期書き込み
	$obj = new Blog();
	$obj->new_file($prjcd,"info",$prjname."関連情報スレッド",
		$prjname."の関連情報スレッド",PUBLOG_SYSTEM_NAME_VER,"");
	// 編集BBSファイルに書き込み
	$obj->write_file($prjcd,"info",PUBLOG_SYSTEM_NAME_VER,"","info",$prjname."情報","dempa2ch","","x",date("YmdHis"));

	// ■commentスレ
	// スレリストファイルに新規追加
//	ins_threadlist($prjcd,"comment","bbs:n:y",$prjname."コメントスレッド");
	// BBSファイルに初期書き込み
//	new_bbsfile($prjcd,"comment",$prjname."コメントスレッド",
//		PUBLOG_SYSTEM_NAME_VER,"",$prjname."のコメントスレッド","");

	// ■メインスレ
		// 箱(スレ)リストファイルに新規追加
		ins_threadlist($prjcd,"blog","blog",$prjname."ブログメインスレッド");
		// 編集BBSファイルに初期書き込み
		$obj->new_file($prjcd,"blog",$prjname."ブログメインスレッド",
			$prjname."のブログメインスレッドです",PUBLOG_SYSTEM_NAME_VER,"");
		// 編集BBSファイルに書き込み
		$obj->write_file($prjcd,"blog",PUBLOG_SYSTEM_NAME_VER,"",$prjname."スタート",$prjname."スタートです<br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br />","PUBLOG","","x",date("YmdHis"));
	// ＢＢＳ全ページ再構築
	all_page_rebuild($prjcd);
}


// 全ページ再構築
function all_page_rebuild($prjcd,$threadidlist=array())
{
	require_once('mod/thread/blog/blog.class.php');
	require_once('mod/thread/blog/blog.func.php');
	require_once('func/thread.func.php');
	require_once('func/page.func.php');
	require_once('func/ita.func.php');


	if(0>=count($threadidlist)){
		$threadidlist=&Blog::find($prjcd);
	}
if(DEBUG){
	$starttime=microtime();
//	disp_elapse_time($starttime,"");	// 経過時間表示
//	print("-- rebuild start --");
//	flush();
}
	// 案トップ更新
	upd_itapage($prjcd);
if(DEBUG){
//	disp_elapse_time($starttime,"");	// 経過時間表示
//	print("-- bbs top updated --");
//	flush();
}
	// 固定HTMLページ再構築
	fixed_html_ita_bapge_rebuild($prjcd);
if(DEBUG){
//	disp_elapse_time($starttime,"");	// 経過時間表示
//	print("-- fix html(bbs) updated --");
//	flush();
}
	// ページテンプレートからHTML生成
	prj_ptmp_to_html($prjcd);
if(DEBUG){
//	disp_elapse_time($starttime,"");	// 経過時間表示
//	print("-- ptmp updated --");
//	flush();
}

	for($i=0;$i<count($threadidlist);$i++)
	{
		// ブログページのアーカイブ書き出し(シーケンスナンバー)
		gen_all_archive_page_seq($prjcd,$threadidlist[$i]);
if(DEBUG){
//		disp_elapse_time($starttime,"");	// 経過時間表示
//		print("-- archives(page) updated --");
//		flush();
}
		// ブログページのアーカイブ書き出し(日ごと)
		gen_all_archive_page_day($prjcd,$threadidlist[$i]);
if(DEBUG){
//		disp_elapse_time($starttime,"");	// 経過時間表示
//		print("-- archive(day) updated --");
//		flush();
}
	}

}
// 1ページ再構築
function one_page_rebuild($prjcd,$threadlist,$seq,$outdate)
{
//	$starttime=microtime();
//	disp_elapse_time($starttime,"");	// 経過時間表示
//	print("-- rebuild start --");
//	flush();
	// 案トップ更新
	upd_itapage($prjcd);
//	disp_elapse_time($starttime,"");	// 経過時間表示
//	print("-- bbs top updated --");
//	flush();
	// 固定HTMLページ再構築
	fixed_html_ita_bapge_rebuild($prjcd);
//	disp_elapse_time($starttime,"");	// 経過時間表示
//	print("-- fix html(bbs) updated --");
//	flush();
	// ページテンプレートからHTML生成
	prj_ptmp_to_html($prjcd);
//	disp_elapse_time($starttime,"");	// 経過時間表示
//	print("-- ptmp updated --");
//	flush();

	for($i=0;$i<count($threadlist);$i++){
		// シーケンスナンバーで指定したページだけ書き出し
		gen_one_archive_page_seq($prjcd,$threadlist[$i],$seq);
		disp_elapse_time($starttime,"");	// 経過時間表示
		print("-- archives(".$seq.") updated --");
		flush();
		// 指定日のページだけ書き出し
		gen_archive_page_bydate($prjcd,$threadlist[$i],$outdate);
		disp_elapse_time($starttime,"");	// 経過時間表示
		print("-- archives(".$outdate.") updated --");
		flush();
	}
}

?>
