<?php
// thread.func.php
// スレッド関連関数

// スレッドタイプごとのテンプレートファイル名を取得
function get_thread_type_tpl_filename($mod,$cmd,$trans)
{
	return get_tpl_filename('thread',$mod,$cmd,$trans);
}

// スレッドデータを取得
function &get_thread_data($prjcd,$threadid){
	$threadlist =& load_threadlist($prjcd);
	foreach($threadlist as $thread)
	{
		if($thread[1]==$threadid)
			return $thread;
	}
	return false;
}


// スレッドリストを読み込み
function &load_threadlist($prjcd){
	// スレッドデータオープン
	$fp = pfopen(APATH_DATA_DIR."$prjcd/thread.txt", "r");
	if(!$fp) {
		error_exit("ファイルを開くことができませんでした(thread.txt)");
	}
	// スレッドデータ読み込み
	while(!feof($fp)) {
		$line = fgets($fp,2000);
		$line=trim($line);
		if(""==$line){
			continue;
		}
		$arr="";
		$arr=split("\t",$line);
		$linearr[]=$arr;
	}
	pfclose($fp);
	return $linearr;
}

// スレッドリストを更新
function upd_threadlist($prjcd,$threadid,$tohyo_count){
	// スレッドデータ読み込み
	$linearr=load_threadlist($prjcd);
	$linectr=count($linearr);

	// 当該スレッドデータを削除して後のデータをまとめる
	$threaddata="";
	$threaddata_found=false;
	for($i=0;$i<$linectr;$i++){
//		$mesarr=explode("\t",$linearr[$i]);
		$mesarr=$linearr[$i];
		$in_date=$mesarr[0];
		if(trim($in_date)==""){
			continue;
		}
		$in_hakoid=$mesarr[1];
		$in_enqsort=$mesarr[2];
		$in_title=$mesarr[3];
		$in_count=$mesarr[4];
		
		// 当該スレッドと合致
		if($threadid==$in_hakoid){
			$threaddata_found=true;
			$update_hakoid=$in_hakoid;
			$update_enqsort=$in_enqsort;
			$update_title=$in_title;
//			$update_count=$in_count;
			continue;
		}
		$threaddata.=$in_date."\t".$in_hakoid."\t".$in_enqsort."\t".$in_title."\t".$in_count."\n";
	}
	if(false==$threaddata_found){
		print("<p>そのスレ、ないよ、なんでだろ<p>");
		return false;
	}
	
	// 最新の書き込みスレッドレコードを先頭に書き込み
	$now = date("Y-m-d H:i:s");
	$threaddata=$now."\t".$update_hakoid."\t".$update_enqsort."\t".$update_title."\t".$tohyo_count."\n".$threaddata;

	// ファイル更新(テンポラリネームで書き換えてから名前変更)
	$outfilename=tempnam(APATH_DATA_DIR."$prjcd","thread_out_");
	$tmpfilename=tempnam(APATH_DATA_DIR."$prjcd","thread_tmp_");

	$outfp=pfopen($outfilename,"w");
	pfwrite($outfp,$threaddata);
	pfclose($outfp);

	rename(APATH_DATA_DIR."$prjcd/thread.txt",$tmpfilename);
	chmod($tmpfilename,0777);
	rename($outfilename,APATH_DATA_DIR."$prjcd/thread.txt");
	chmod(APATH_DATA_DIR."$prjcd/thread.txt",0777);

	unlink($tmpfilename);

	return true;

}



// スレッドリストファイルに新規追加
function ins_threadlist($prjcd,$threadid,$enqsort,$title){
	// スレッドデータ読み込み
	$linearr=load_threadlist($prjcd);
	$linectr=count($linearr);

	$threaddata="";
	for($i=0;$i<$linectr;$i++){
		$mesarr=$linearr[$i];
		$in_date=$mesarr[0];
		if(trim($in_date)==""){
			continue;
		}
		$in_hakoid=$mesarr[1];
		$in_enqsort=$mesarr[2];
		$in_title=$mesarr[3];
		$in_count=$mesarr[4];
		
		$threaddata.=$in_date."\t".$in_hakoid."\t".$in_enqsort."\t".$in_title."\t".$in_count."\n";
	}
	
	// 最新の書き込みスレッドレコードを先頭に書き込み
	$now = date("Y-m-d H:i:s");
	$threaddata=$now."\t".$threadid."\t".$enqsort."\t".$title."\t1\n".$threaddata;

	$outfilename=APATH_DATA_DIR."$prjcd/thread.txt";
	$outfp=pfopen($outfilename,"w");
	fwrite($outfp,$threaddata);
	pfclose($outfp);
	chmod(APATH_DATA_DIR."$prjcd/thread.txt",0777);

	return true;
}




// mfbbs スレッドデータ読み出し【汎用】
function &load_mfbbs_thread_data($prjcd,$threadid){
	$fp = pfopen(APATH_DATA_DIR."$prjcd/data/$threadid.txt", "r");
	if(!$fp) {
		echo "err load ".$threadid.".txt\n";
		exit;
	}
	$bodydata=array();
	$headerdata=array();
	$headsw=true;
	$firstline=true;
	while(!feof($fp)) {
		$line = fgets($fp,50000);
		$line=ereg_replace("[\r\n]","",$line);
		
		if($firstline){
			if(ereg("^MFBBS/(.+)",$line,$regs)){
				$headerdata["mfbbsver"]=$regs[1];
				$firstline=false;
			}else{
				echo "file format err(edit)\n";
				exit;
			}
		}
		if($headsw){
			if($line==""){
				$headsw=false;
				continue;
			}
			$arr=split("\t",$line);
			$headerdata[$arr[0]]=$arr[1];
			continue;
		}

		if($line==""){
			continue;
		}

		$arr=array();
		$arr=split("\t",$line);
		$bodydata[]=$arr;
	}

	pfclose($fp);
	
	$retdata=array();
	$retdata["header"]=$headerdata;
	$retdata["body"]=$bodydata;

	return $retdata;
}



// mfbbs スレッドデータ書き出し【汎用】
function write_mfbbs_thread_data($prjcd,$threadid,$threaddata){
	$header_data=$threaddata["header"];
	$body_data=$threaddata["body"];

	$outheader="";
	$outheader.="MFBBS/1.0\n";
	while(list($key,$val)=each($header_data)){
		if(substr($key,0,5)=="MFBBS"){
			continue;
		}
		if($key=="threadcomment"){
			$outheader.=$key."\t".$val."\n";
		}else{
			$outheader.=$key."\t".$val."\n";
		}
	}

	$outbody="";
	$body_count=count($body_data);
	for($i=0;$i<$body_count;$i++){
		$rec_count=count($body_data[$i]);
		for($j=0;$j<$rec_count;$j++){
			$outbody.=$body_data[$i][$j];
			if($j<($rec_count-1)){
				$outbody.="\t";
			}
		}
		$outbody.="\n";
	}

	$outdata="";
	$outdata.=$outheader;
	$outdata.="\n";
	$outdata.=$outbody;
	
	$outfilename=APATH_DATA_DIR."$prjcd/data/$threadid.txt";
	$outfp=pfopen($outfilename,"w");
	fwrite($outfp,$outdata);
	pfclose($outfp);
	chmod($outfilename,0777);

}

//////////////////////////////////////////////////////////////////////
// 最新ｎ件表示データ作成
// スレッドテンプレートを読み込んで、データを当てはめて書き出し
//
function gen_includefile_newest_n_template($prjcd,$hakoid,&$bbsdata)
{
	// プロジェクトディレクトリのファイル一覧を取得
	$filelist=prj_get_filelist($prjcd,"designthema/");

	$headerdata=&$bbsdata["header"];
	$bodydata=$bbsdata["body"];

	$bc=count($bodydata);
	$bodydata=array_reverse($bodydata);	// データを逆順に

	reset($filelist);
	// テンプレートファイルごとのループ
	while(list($key,$val) = each($filelist)){
		// ファイルリストから、スレッドテンプレート以外のものを弾く
		// ファイルリストから、スレッドタイプが一致していないものを弾く
		if(!ereg($hakoid."-([a-zA-Z0-9\\-]+)[.]ttmp$",$val,$regs)){
			continue;
		}
		$template_threadid=$hakoid;	// テンプレートid
		$template_name=$regs[1];		// テンプレート名

		$thread_template_data=load_threadtemplate_file(APATH_HOME_DIR.$prjcd."/designthema/".$val);
		$thread_template_header=$thread_template_data["header"];
		$template_loop=$thread_template_header["count"];	// 表示レス数
		if($template_loop>1000){
			$template_loop=1000;
		}
		$thread_template=$thread_template_data["bodytext"];

		// 処理開始位置の指定
		if (array_key_exists("pos", $thread_template_header)) {
			$startpos=$thread_template_header["pos"];
			if($startpos==""){
				$startpos=0;
			}
		}else{
			$startpos=0;
		}

		// プロジェクト関連の置き換え
		$thread_template=ereg_replace("<!prj-dir>",
			HTTP_HOME_DIR.$prjcd."/",$thread_template);
		
		$pagedata="";
		for($i=$startpos;($i<$bc)&&($i<($startpos+$template_loop));$i++){
			if($bodydata[$i][6]!="o"){	// state 非公開
				continue;
			}

			$caturl="";

			$res_data=$thread_template;
			
			$func = 'convert_page_'.$headerdata["type"];
			if(function_exists($func))
			{
				$pagedata.=call_user_func($func,$res_data,$headerdata,$bodydata,$i);
			}
		}
		// 書き出し
		write_file(APATH_DATA_DIR.$prjcd."/include/".$template_threadid."-".$template_name.".tinc",$pagedata);
	}

}


// スレッド削除
function rm_thread($prjcd,$threadid)
{
	$deleted_thread=array();

	$thread_list=load_threadlist($prjcd);
	$outlist="";
	foreach($thread_list as $value)
	{
		if($threadid==$value[1]){
			$deleted_thread=$value;
			continue;	// 無視してスキップ
		}
		$outlist.=$value[0]."\t";	// datetime
		$outlist.=$value[1]."\t";	// threadid
		$outlist.=$value[2]."\t";	// 設定
		$outlist.=$value[3]."\t";	// title
		$outlist.=$value[4]."\n";	// レス数
	}

	if(empty($deleted_thread))
		error_exit("該当するスレッドがありません");

	// ファイル更新(テンポラリネームで書き換えてから名前変更)
	$outfilename=APATH_DATA_DIR.$prjcd."/".uniqid('o_');
	$tmpfilename=APATH_DATA_DIR.$prjcd."/".uniqid('t_');

	$outfp=pfopen($outfilename,"w");
	fwrite($outfp,$outlist);
	pfclose($outfp);

	rename(APATH_DATA_DIR.$prjcd."/thread.txt",$tmpfilename);
	chmod($tmpfilename,0777);
	rename($outfilename,APATH_DATA_DIR.$prjcd."/thread.txt");
	chmod(APATH_DATA_DIR.$prjcd."/thread.txt",0777);

	unlink($tmpfilename);	// テンプレファイル削除

	rm_ereg_files(APATH_DATA_DIR.$prjcd."/","^".$threadid.".+$");
	rm_ereg_files(APATH_DATA_DIR.$prjcd."/data/","^".$threadid."[.].+$");

	return $deleted_thread;
}

?>
