<?php
// $Id: reserve_entry.php,v 1.3 2004/12/11 14:10:52 fukami Exp $
// 第１引数：実行ディレクトリ
// 0:指定日時, 1:予約した日時,2:prjcd,3:threadid,4:batch_id,5:題名,6:筆者名,7:ブログ名
//
// 設置方法(例)：
// UNIX環境の場合
// ---
// crontab -u nobody -e
// ---
// SHELL=/bin/bash
// MAILTO=yourmailaddr@hogehoge.com
// #           ↓PHPの場所        ↓reserve_entry.phpへの絶対パス              ↓PUBLOGスクリプトディレクトリ
// */5 * * * * /usr/local/bin/php /home/publog/hidden_script/reserve_entry.php /home/publog/public_html/editor


	$exec_dir = trim($argv[1]);
	if(!is_dir($exec_dir))
		exit;

	chdir($exec_dir);

	// ユーザー設定ファイル
	$conf=parse_ini_file('publog_conf.ini',TRUE);
	// 設定ファイル def 系
	require_once("publog_def.ini");
	// PUBLOG システム関数
	require_once("func/file.func.php");
	require_once("func/html.func.php");

	$now = date("YmdHis");

	$reserve_filename = SYS_DIR.'reserve_entry.txt';
	$reserve_tmp_filename = SYS_DIR.'tmp_reserve_entry.txt';
	$reserve_log_filename = SYS_DIR.'log_reserve_entry_'.date("Ym").'.txt';

	if(!file_exists($reserve_filename))
		exit;

	$data = load_file_table($reserve_filename);
	reset($data);
	$kick_line=array();
	$save_line=array();
	foreach($data as $line)
	{
		if($line[0] <= $now)
		{
			$kick_line[] = $line;
		}else{
			$save_line[] = $line;
		}
	}
	// tmp ファイル確認
	if(file_exists($reserve_tmp_filename))
	{
		exit("tmp file is exists. stop function.");
	}
	save_file_table($reserve_filename,$save_line);
	if(0<=count($kick_line))
	{
		save_file_table($reserve_tmp_filename,$kick_line);
	}else{
		return;
	}
	foreach($kick_line as $reserve_line)
	{
		$batch_id = $reserve_line[4];
		// 予約配信プロセスのキック
		$command = APATH_PHP_EXE.' ';
		$command.= APATH_SCRIPT_DIR.'batch.php publog_batch '.$batch_id;
		if(OS_TYPE == OS_TYPE_UNIX)
		{
			$command.= '> /dev/null &';
		}	
		// エントリープロセスをキック
		$res = system($command);
		$log = "success\t";
		$log.= $now."\t";
		$log.= $reserve_line[0]."\t";
		$log.= $reserve_line[1]."\t";
		$log.= $reserve_line[2]."\t";
		$log.= $reserve_line[3]."\t";
		$log.= $reserve_line[4]."\t";
		$log.= $reserve_line[5]."\t";
		$log.= $reserve_line[6]."\t";
		$log.= $reserve_line[7]."\t";
		$log.= $reserve_line[8]."\n";
		add_file($reserve_log_filename,$log);
		print($log);
		print("<br />");
		sleep(5);
	}
	// 終了
	unlink($reserve_tmp_filename);
?>
