<?php
/*
 * $Id: blog_pagegenerator.class.php,v 1.45 2006/01/14 08:05:29 timeserver Exp $
 * ブログページの生成とデータの管理
 *
 */

// ブログページの生成とデータの管理をおこなうオブジェクト
class BlogPageGenerator
{
	var $blogdata = null;	// BlogData object
	var $tpl_obj = null; // Smarty object
/*
	var $conf = array(
				'base' => array(
					'id' => null		// ex.) 'www.example.com/home/'
				),
				'project' => array(
					'cd' => null
				),
				'thread' => array(
					'id' => null
				),
				'entry' => array(
					'id' => null
				),
				'comment' => array(
					'id' => null
				),
				'xml_file' => array(
					'sys_dir' => null,
					'base_dir' => null
				)
			);
*/
	var $page_conf = array(
		'0' => array(
			'template_base_dir' => null,	// template file dir
			'out_data' => null // output data (text, page data
		)
	);
	function BlogPageGenerator($data_conf = array(), $page_conf = array())
	{
//		$this->blogdata = new BlogTemplateDataGenerator;
		$this->blogdata = new BlogData;
		if(null == $data_conf){
			return false;
		}
		$this->conf =& $data_conf;	// this (page generator data conf)
		$this->blogdata->set_conf($data_conf);	// data generator conf

		if(null == $page_conf){
			return false;
		}
		$this->page_conf =& $page_conf;
	}
	function set_page_conf($page_conf = array())
	{
		if(empty($page_conf)){
			return false;
		}
		$this->page_conf =& $page_conf;
	}
/*
	function &assign_by_ref($arr)
	{
		$name = $arr['name'];
		$method = $arr['method'];
		$NameData =& $this->blogdata->load($name);
		$ret =& $NameData->$method($arr);
		return $ret;
	}
*/
	function &assign_entry_data($arr)
	{
		$conf = array(
			'entry' => array(
				'id' => $arr['id']
			)
		);
		$EntryData =& $this->blogdata->load('entry',$conf);
		$options['contents_nl2br'] = true;
		$options['contents_wiki'] = true;
		$entry_data =& $EntryData->get($options);
		
		return $entry_data;
	}
	//携帯用[Timeserver][2005/11/18][07:53]
	function &assign_entry_data_m($arr)
	{
		$conf = array(
			'entry' => array(
				'id' => $arr['id']
			)
		);
		$EntryData =& $this->blogdata->load('entry',$conf);
		$options['contents_nl2br'] = true;
		$options['contents_wiki'] = true;
		$entry_data_m =& $EntryData->get_m($options);
		
		return $entry_data_m;
	}
	function &assign_commentlist_data($arr)
	{
		$conf = array(
			'entry' => array(
				'id' => $arr['id']
			)
		);
		$CommentlistData =& $this->blogdata->load('commentlist',$conf);
		return $CommentlistData->commentlist_all();
	}

	// 最近のライトバック
	function &assign_recently_writeback($arr)
	{
		$project_cd = $arr['project_cd'];
		$thread_id = $arr['thread_id'];
		$last = (int)$arr['last'];
		if(empty($project_cd))
		{
			return 'project_cd is null.';
		}
		if(empty($thread_id))
		{
			return 'thread_id is null.';
		}
		if(empty($last))
			$last = 10;

		$filename = APATH_HOME_DIR.$project_cd.'/data/blog/'.$thread_id.'/recently_writeback.txt';

		if(!file_exists($filename))
		{
			return 'data file not found('.$filename.').';
		}

/*		$filedata=file_get_contents($filename);
		$filearr = explode("\r\n",$filedata);
		$wbdat = array();
		$ctr = 0;
		foreach($filearr as $data)
		{
			$ctr++;
			if($last < $ctr)
				break;
			$linearr = explode("\t",$data);
			$tmp = array(
				'link' => trim($linearr[0]),
				'res_link' => trim($linearr[1]),
				'title' => $linearr[2],
				'author' => $linearr[3]
			);
print_r($tmp);
			$wbdat[] = $tmp;
		}
*/
		$handle = pfopen ($filename,"r");
		$wbdat = array();
		$ctr = 0;
		while ($data = pfgetcsv ($handle, 1000, "\t")) {
			$ctr++;
			if($last < $ctr)
				break;
			$tmp = array(
				'link' => trim($data[0]),
				'res_link' => trim($data[1]),
				'title' => $data[2],
				'author' => $data[3],
				'datetime' => $data[4],
				'publog_node' => $data[5],
				'entry_title' => $data[6]
			);
			$wbdat[] = $tmp;
		}
		pfclose ($handle);
		return $wbdat;
	}

	// [Timeserver][2005/11/26]携帯用 最近のライトバック
	function &assign_recently_writeback_m($arr)
	{
		$project_cd = $arr['project_cd'];
		$thread_id = $arr['thread_id'];
		$last = (int)$arr['last'];
		if(empty($project_cd))
		{
			return 'project_cd is null.';
		}
		if(empty($thread_id))
		{
			return 'thread_id is null.';
		}
		if(empty($last))
			$last = 10;

		$filename = APATH_HOME_DIR.$project_cd.'/data/blog/'.$thread_id.'/recently_writeback.txt';

		if(!file_exists($filename))
		{
			return 'data file not found('.$filename.').';
		}
		$handle = pfopen ($filename,"r");
		$wbdat = array();
		$ctr = 0;
		while ($data = pfgetcsv ($handle, 1000, "\t")) {
			$ctr++;
			if($last < $ctr)
				break;
			$tmp = array(
				'link' => trim($data[0]),
				'res_link' => ereg_replace('.html#res','m.html#res',trim($data[1])),//[Timeserver][2005/11/26]インチキ臭い対応
				'title' => $data[2],
				'author' => $data[3],
				'datetime' => $data[4],
				'publog_node' => $data[5],
				'entry_title' => $data[6]
			);
			$wbdat[] = $tmp;
		}
		pfclose ($handle);
		return $wbdat;
	}
	function &assign($arr)
	{
		$name = $arr['name'];
		$method = $arr['method'];
		$NameData =& $this->blogdata->load($name);
		return $NameData->$method($arr);
	}
	function &plugin($arr)
	{
		$name = $arr['name'];
		if(empty($name))
		{
			return null;
		}
		if('calender' == $name)
		{
			$name = 'calendar';
		}
		$plugin_filename = 'mod/thread/blog/plugin/'.$name.'.plugin.php';
		if(!file_exists($plugin_filename))
		{
			return null;
		}
		require_once($plugin_filename);
		$call_module_name = 'do_plugin_action_thread_blog_'.$name;
		if(!function_exists($call_module_name)){
			return null;
		}
		// プラグイン呼び出し
		$ret =& $call_module_name($arr,$this);
		return $ret;
	}


	function generate_page_index($page_conf = array())
	{
		if(!empty($page_conf)){
			$this->set_page_conf($page_conf);
		}
		$this->tpl_obj = new BlogPage_Smarty;
		$this->tpl_obj->register_object('Blogdata',$this);
		foreach($this->page_conf as $pkey => $pconf)
		{
			$this->tpl_obj->template_dir = $pconf['template_base_dir'];
			$this->tpl_obj->assign('http_project_top_dir',$pconf['http_project_top_dir']);
			$this->tpl_obj->assign('http_thread_top_dir',$pconf['http_thread_top_dir']);
			$this->tpl_obj->assign('design_template_dir',$pconf['http_template_dir']);
			$this->tpl_obj->assign('default_css',$pconf['default_css']);
			$this->tpl_obj->assign('rss_1_0_url',$pconf['http_base_dir'].$this->conf['thread']['id'].'/rss.rdf');
			$this->tpl_obj->assign('dedio_rss_url',$pconf['http_base_dir'].$this->conf['thread']['id'].'/dedio_rss.rdf');
			$this->tpl_obj->assign('dedio_playlist_url',$pconf['http_base_dir'].$this->conf['thread']['id'].'/playlist.xml');
//			$this->page_conf[$key]['out_data'] =& $this->tpl_obj->fetch($pconf['template']);
//			$outdata =& $this->tpl_obj->fetch($pconf[''].'index.tpl');
			$outdata =& $this->tpl_obj->fetch($pconf['template_file']);
//			$filename = $this->page_conf[$pkey]['file_base_dir'].$this->conf['thread']['id'].'/index.html';
			check_dir( $this->page_conf[$pkey]['file_base_dir'].$this->conf['thread']['id'].'/');
//			file_put_contents($filename,$outdata);
			if(is_array($this->page_conf[$pkey]['out_file_name']))
			{
				foreach($this->page_conf[$pkey]['out_file_name'] as $out_filename)
				{
					file_put_contents($out_filename,$outdata);
				}
			}
		}
		return;
	}
	//[Timeserver][2005/11/18][07:02]携帯用
	function generate_page_index_m($page_conf = array())
	{
		if(!empty($page_conf)){
			$this->set_page_conf($page_conf);
		}
		$this->tpl_obj = new BlogPage_Smarty;
		$this->tpl_obj->register_object('Blogdata',$this);
		foreach($this->page_conf as $pkey => $pconf)
		{
			$this->tpl_obj->template_dir = $pconf['template_base_dir'];
			$this->tpl_obj->assign('http_project_top_dir',$pconf['http_project_top_dir']);
			$this->tpl_obj->assign('http_thread_top_dir',$pconf['http_thread_top_dir']);
			$this->tpl_obj->assign('design_template_dir',$pconf['http_template_dir']);
			$this->tpl_obj->assign('default_css',$pconf['default_css']);
			$this->tpl_obj->assign('rss_1_0_url',$pconf['http_base_dir'].$this->conf['thread']['id'].'/rss.rdf');
			$this->tpl_obj->assign('dedio_rss_url',$pconf['http_base_dir'].$this->conf['thread']['id'].'/dedio_rss.rdf');
			$this->tpl_obj->assign('dedio_playlist_url',$pconf['http_base_dir'].$this->conf['thread']['id'].'/playlist.xml');
			$outdata =& $this->tpl_obj->fetch($pconf['template_file_m']);
			$outdata = mb_convert_encoding($outdata,'SJIS','UTF8');
			$outdata = ereg_replace('<br />','<br>',$outdata);
			//フォルダが無ければ作る
			check_dir( $this->page_conf[$pkey]['file_base_dir'].$this->conf['thread']['id'].'/m/');
			if(is_array($this->page_conf[$pkey]['out_file_name_m']))
			{
				foreach($this->page_conf[$pkey]['out_file_name_m'] as $out_filename)
				{
					file_put_contents($out_filename,$outdata);
				}
			}
		}
		return;
	}
	// RSS 出力(entrylist)
	function _save_entrylist_rss($page_conf = array())
	{
		if(!empty($page_conf)){
			$this->set_page_conf($page_conf);
		}
		if(empty($this->blogdata->entrylist))
		{
			$entrylist_obj =& $this->blogdata->load('entrylist');	// エントリーリストのロード
		}else{
			$entrylist_obj =& $this->blogdata->entrylist;
		}
		$entrylist =& $entrylist_obj->entrylist_all();
		foreach($this->page_conf as $pkey => $pconf)
		{
			foreach($entrylist as $key => $var)
			{
				$link = $pconf['http_base_dir'].$this->conf['thread']['id'].'/'.substr($var['id'],0,4).'/'.substr($var['id'],4,2).'/'.substr($var['id'],6,2).'_'.substr($var['id'],-6).'.html';
				$entrylist[$key]['url'] = $link;
			}
			$entrylist =& array_phtmlenc_by_ref($entrylist);
			$this->tpl_obj->assign_by_ref('entrylist',$entrylist);
			$rss_url = $pconf['http_base_dir'].$this->conf['thread']['id'].'/rss.rdf';
			$this->tpl_obj->assign_by_ref('rss_url',$rss_url);
			// スレッドデータの取得
			$thread_obj =& $this->blogdata->load('thread');
			$thread = & $thread_obj->pxml->node_data['thread'];
			$thread['url'] = $pconf['http_base_dir'].$this->conf['thread']['id'].'/';
			$thread =& array_phtmlenc_by_ref($thread);
			$this->tpl_obj->assign_by_ref('thread',$thread);
			$tpl_file = APATH_SCRIPT_DIR.'mod/thread/blog/xml_templates/rss_xml.tpl';
			if(file_exists($tpl_file))
			{
				$outdata =& $this->tpl_obj->fetch($tpl_file);
			}
			$filename = $this->page_conf[$pkey]['file_base_dir'].$this->conf['thread']['id'].'/rss.rdf';
			file_put_contents($filename,$outdata);
		}
	}
	// dedio RSS 出力(entrylist)
	function _save_entrylist_dedio_rss($page_conf = array())
	{
		if(!empty($page_conf)){
			$this->set_page_conf($page_conf);
		}
		if(empty($this->blogdata->entrylist))
		{
			$entrylist_obj =& $this->blogdata->load('entrylist');	// エントリーリストのロード
		}else{
			$entrylist_obj =& $this->blogdata->entrylist;
		}
		$entrylist =& $entrylist_obj->entrylist_all();
		foreach($this->page_conf as $pkey => $pconf)
		{
			foreach($entrylist as $key => $var)
			{
				$link = $pconf['http_base_dir'].$this->conf['thread']['id'].'/'.substr($var['id'],0,4).'/'.substr($var['id'],4,2).'/'.substr($var['id'],6,2).'_'.substr($var['id'],-6).'.html';
				$entrylist[$key]['url'] = $link;
				// dedio mp3
				$dedio_file = APATH_HOME_DIR.$this->conf['project']['cd'].'/media/blog/'.$this->conf['thread']['id'].'/'.substr($var['id'],0,4).'/'.substr($var['id'],4,2).'/radio_'.substr($var['id'],6,2).'_'.substr($var['id'],-6).'.mp3';
				if(file_exists($dedio_file))
				{
					$dedio_uri = HTTP_HOME_DIR.$this->conf['project']['cd'].'/media/blog/'.$this->conf['thread']['id'].'/'.substr($var['id'],0,4).'/'.substr($var['id'],4,2).'/radio_'.substr($var['id'],6,2).'_'.substr($var['id'],-6).'.mp3';
					$entrylist[$key]['radio']['uri'] = $dedio_uri;
				}
			}
			$entrylist =& array_phtmlenc_by_ref($entrylist);
			$this->tpl_obj->assign_by_ref('entrylist',$entrylist);
			$rss_url = $pconf['http_base_dir'].$this->conf['thread']['id'].'/dedio_rss.rdf';
			$this->tpl_obj->assign_by_ref('rss_url',$rss_url);
			// スレッドデータの取得
			$thread_obj =& $this->blogdata->load('thread');
			$thread = & $thread_obj->pxml->node_data['thread'];
			// スレッドロゴ
			if(file_exists(APATH_HOME_DIR.$this->conf['project']['cd'].'/media/blog/'.$this->conf['thread']['id'].'/logo.gif')){
				$thread['logo']['uri']=HTTP_HOME_DIR.$this->conf['project']['cd'].'/media/blog/'.$this->conf['thread']['id'].'/logo.gif';
			}else
			// プロジェクトロゴ
			if(file_exists(APATH_HOME_DIR.$this->conf['project']['cd'].'/media/logo.gif')){
				$thread['logo']['uri']=HTTP_HOME_DIR.$this->conf['project']['cd'].'/media/logo.gif';
			}
			$thread['url'] = $pconf['http_base_dir'].$this->conf['thread']['id'].'/';
			$thread =& array_phtmlenc_by_ref($thread);
			$this->tpl_obj->assign_by_ref('thread',$thread);
			$tpl_file = APATH_SCRIPT_DIR.'mod/thread/blog/xml_templates/dediorss_xml.tpl';
			if(file_exists($tpl_file))
			{
				$outdata =& $this->tpl_obj->fetch($tpl_file);
			}
			$filename = $this->page_conf[$pkey]['file_base_dir'].$this->conf['thread']['id'].'/dedio_rss.rdf';
			file_put_contents($filename,$outdata);
		}
	}

	// podcast feed 出力(entrylist)
	function _save_entrylist_podcast($page_conf = array())
	{
		if(!empty($page_conf)){
			$this->set_page_conf($page_conf);
		}
		// プロジェクトデータの取得
		$project_obj =& $this->blogdata->load('project');
		$project = & $project_obj->pxml->node_data['project'];
		if(empty($this->blogdata->entrylist))
		{
			$entrylist_obj =& $this->blogdata->load('entrylist');	// エントリーリストのロード
		}else{
			$entrylist_obj =& $this->blogdata->entrylist;
		}
		$entrylist =& $entrylist_obj->entrylist_all();
		foreach($this->page_conf as $pkey => $pconf)
		{
			foreach($entrylist as $key => $var)
			{
				$link = $pconf['http_base_dir'].$this->conf['thread']['id'].'/'.substr($var['id'],0,4).'/'.substr($var['id'],4,2).'/'.substr($var['id'],6,2).'_'.substr($var['id'],-6).'.html';
				$entrylist[$key]['url'] = $link;
				// dedio mp3
				$dedio_file = APATH_HOME_DIR.$this->conf['project']['cd'].'/media/blog/'.$this->conf['thread']['id'].'/'.substr($var['id'],0,4).'/'.substr($var['id'],4,2).'/radio_'.substr($var['id'],6,2).'_'.substr($var['id'],-6).'.mp3';
				if(file_exists($dedio_file))
				{
					$dedio_uri = HTTP_HOME_DIR.$this->conf['project']['cd'].'/media/blog/'.$this->conf['thread']['id'].'/'.substr($var['id'],0,4).'/'.substr($var['id'],4,2).'/radio_'.substr($var['id'],6,2).'_'.substr($var['id'],-6).'.mp3';
					$entrylist[$key]['radio']['uri'] = $dedio_uri;
					$entrylist[$key]['radio']['filesize'] = filesize($dedio_file);
				}
			}
			$entrylist =& array_phtmlenc_by_ref($entrylist);
			$this->tpl_obj->assign_by_ref('entrylist',$entrylist);
			$rss_url = $pconf['http_base_dir'].$this->conf['thread']['id'].'/dedio_rss.rdf';
			$this->tpl_obj->assign_by_ref('rss_url',$rss_url);
			// スレッドデータの取得
			$thread_obj =& $this->blogdata->load('thread');
			$thread = & $thread_obj->pxml->node_data['thread'];
			// スレッドロゴ
			if(file_exists(APATH_HOME_DIR.$this->conf['project']['cd'].'/media/blog/'.$this->conf['thread']['id'].'/logo.gif')){
				$thread['logo']['uri']=HTTP_HOME_DIR.$this->conf['project']['cd'].'/media/blog/'.$this->conf['thread']['id'].'/logo.gif';
			}else
			// プロジェクトロゴ
			if(file_exists(APATH_HOME_DIR.$this->conf['project']['cd'].'/media/logo.gif')){
				$thread['logo']['uri']=HTTP_HOME_DIR.$this->conf['project']['cd'].'/media/logo.gif';
			}
			$thread['url'] = $pconf['http_base_dir'].$this->conf['thread']['id'].'/';
			$project =& array_phtmlenc_by_ref($project);
			$this->tpl_obj->assign_by_ref('project',$project);
			$thread =& array_phtmlenc_by_ref($thread);
			$this->tpl_obj->assign_by_ref('thread',$thread);
			$this->tpl_obj->assign('now_w3c',now_w3c());
			$this->tpl_obj->assign('language',LANG);
			$tpl_file = APATH_SCRIPT_DIR.'mod/thread/blog/xml_templates/podcast_xml.tpl';
			if(file_exists($tpl_file))
			{
				$outdata =& $this->tpl_obj->fetch($tpl_file);
			}
			$filename = $this->page_conf[$pkey]['file_base_dir'].$this->conf['thread']['id'].'/podcast.xml';
			file_put_contents($filename,$outdata);
		}
	}




	// dedio playlist 出力(entrylist) *Shift_JIS で出力するコト
	function _save_entrylist_dedio_playlist($page_conf = array())
	{
		if(!empty($page_conf)){
			$this->set_page_conf($page_conf);
		}
		if(empty($this->blogdata->entrylist))
		{
			$entrylist_obj =& $this->blogdata->load('entrylist');	// エントリーリストのロード
		}else{
			$entrylist_obj =& $this->blogdata->entrylist;
		}
		$entrylist =& $entrylist_obj->entrylist_all();
//		$entrylist = array_reverse($entrylist,false);
		foreach($this->page_conf as $pkey => $pconf)
		{
			foreach($entrylist as $key => $var)
			{
				$link = $pconf['http_base_dir'].$this->conf['thread']['id'].'/'.substr($var['id'],0,4).'/'.substr($var['id'],4,2).'/'.substr($var['id'],6,2).'_'.substr($var['id'],-6).'.html';
				$entrylist[$key]['url'] = $link;
				// dedio mp3
				$dedio_file = APATH_HOME_DIR.$this->conf['project']['cd'].'/media/blog/'.$this->conf['thread']['id'].'/'.substr($var['id'],0,4).'/'.substr($var['id'],4,2).'/radio_'.substr($var['id'],6,2).'_'.substr($var['id'],-6).'.mp3';
				if(file_exists($dedio_file))
				{
					$dedio_uri = HTTP_HOME_DIR.$this->conf['project']['cd'].'/media/blog/'.$this->conf['thread']['id'].'/'.substr($var['id'],0,4).'/'.substr($var['id'],4,2).'/radio_'.substr($var['id'],6,2).'_'.substr($var['id'],-6).'.mp3';
					$entrylist[$key]['radio']['uri'] = $dedio_uri;
				}
			}
			$entrylist =& array_phtmlenc_by_ref($entrylist);
			$this->tpl_obj->assign_by_ref('entrylist',$entrylist);
			$playlist_url = $pconf['http_base_dir'].$this->conf['thread']['id'].'/playlist.xml';
			$this->tpl_obj->assign_by_ref('playlist_url',$playlist_url);
			// スレッドデータの取得
			$thread_obj =& $this->blogdata->load('thread');
			$thread = & $thread_obj->pxml->node_data['thread'];
			$thread['url'] = $pconf['http_base_dir'].$this->conf['thread']['id'].'/';
			$thread =& array_phtmlenc_by_ref($thread);
			$this->tpl_obj->assign_by_ref('thread',$thread);
			$tpl_file = APATH_SCRIPT_DIR.'mod/thread/blog/xml_templates/dedioplaylist_xml.tpl';
			if(file_exists($tpl_file))
			{
				$outdata =& $this->tpl_obj->fetch($tpl_file);
			}
			$filename = $this->page_conf[$pkey]['file_base_dir'].$this->conf['thread']['id'].'/playlist.xml';
			// sjis 変換
			$outdata = mb_convert_encoding($outdata,'SJIS','auto');
			file_put_contents($filename,$outdata);
		}
	}



	function generate_page_entrylist_all($page_conf = array())
	{
		if(!empty($page_conf)){
			$this->set_page_conf($page_conf);
		}
		// プロジェクトデータの取得
		$project_obj =& $this->blogdata->load('project');
		$project = & $project_obj->pxml->node_data['project'];
		// スレッドデータの取得
		$thread_obj =& $this->blogdata->load('thread');
		$thread = & $thread_obj->pxml->node_data['thread'];
		// エントリーデータの取得
		$entrylist =& $this->blogdata->load('entrylist');	// エントリーリストのロード
		$entrylist_date_arr =& $entrylist->entrylist_mdarray();	// 全エントリーリストの多次元配列
		// 基本データの入手と割り当て
		$this->tpl_obj = new BlogPage_Smarty;
		$this->tpl_obj->register_object('Blogdata',$this);
		$this->tpl_obj->assign_by_ref('Project',$project);
//		$this->tpl_obj->assign_by_ref('Thread',$thread);
		$this->tpl_obj->assign_by_ref('Blog',$thread);

		// entry_year ページの生成 ===
		foreach($this->page_conf as $pkey => $pconf)
		{
			$entrylist_link_year = array();
			foreach($entrylist_date_arr as $ykey => $yvar)
			{
				$arr = array(
					'year' => $ykey,
					'link' => $this->page_conf[$pkey]['http_base_dir'].$this->conf['thread']['id'].'/'.$ykey.'/index.html'
				);
				$entrylist_link_year[] = $arr;
			}
			$this->tpl_obj->template_dir = $pconf['template_base_dir'];
			$this->tpl_obj->assign('http_project_top_dir',$pconf['http_project_top_dir']);
			$this->tpl_obj->assign('http_thread_top_dir',$pconf['http_thread_top_dir']);
			$this->tpl_obj->assign('design_template_dir',$pconf['http_template_dir']);
			$this->tpl_obj->assign_by_ref('Entrylist_link_year',$entrylist_link_year);
			$this->tpl_obj->assign('default_css',$pconf['default_css']);
			$this->tpl_obj->assign('rss_1_0_url',$pconf['http_base_dir'].$this->conf['thread']['id'].'/rss.rdf');
			$this->tpl_obj->assign('dedio_rss_url',$pconf['http_base_dir'].$this->conf['thread']['id'].'/dedio_rss.rdf');
			$outdata =& $this->tpl_obj->fetch('entrylist_year.tpl');
			$filename = $this->page_conf[$pkey]['file_base_dir'].$this->conf['thread']['id'].'/entry_index.html';
			check_dir($this->page_conf[$pkey]['file_base_dir'].$this->conf['thread']['id'].'/');
			file_put_contents($filename,$outdata);
		}
		// entry_month ページの生成 ===
		// 年の数だけループ
		$entrylist_all = array();	// 全リスト
		foreach($entrylist_date_arr as $ykey => $yvar)
		{
			foreach($this->page_conf as $pkey => $pconf)
			{
				$entrylist_link_month = array();
				// 月の数だけループ
				foreach($entrylist_date_arr[$ykey] as $mkey => $mvar)
				{
					$arr = array(
						'year' => $ykey,
						'month' => $mkey,
						'link' => $this->page_conf[$pkey]['http_base_dir'].$this->conf['thread']['id'].'/'.$ykey.'/'.$mkey.'/index.html'
					);
					$entrylist_link_month[] = $arr;
				}
				$this->tpl_obj->template_dir = $pconf['template_base_dir'];
				$this->tpl_obj->assign('http_project_top_dir',$pconf['http_project_top_dir']);
				$this->tpl_obj->assign('http_thread_top_dir',$pconf['http_thread_top_dir']);
				$this->tpl_obj->assign('design_template_dir',$pconf['http_template_dir']);
				$this->tpl_obj->assign_by_ref('Entrylist_this_year',$ykey);
				$this->tpl_obj->assign_by_ref('Entrylist_link_year',$entrylist_link_year);
				$this->tpl_obj->assign_by_ref('Entrylist_link_month',$entrylist_link_month);
				$this->tpl_obj->assign('default_css',$pconf['default_css']);
				$this->tpl_obj->assign('rss_1_0_url',$pconf['http_base_dir'].$this->conf['thread']['id'].'/rss.rdf');
				$this->tpl_obj->assign('dedio_rss_url',$pconf['http_base_dir'].$this->conf['thread']['id'].'/dedio_rss.rdf');
				$outdata =& $this->tpl_obj->fetch('entrylist_month.tpl');
				$filename = $this->page_conf[$pkey]['file_base_dir'].$this->conf['thread']['id'].'/'.$ykey.'/index.html';
				check_dir($this->page_conf[$pkey]['file_base_dir'].$this->conf['thread']['id'].'/'.$ykey.'/');
				file_put_contents($filename,$outdata);
			}
			// 月の数だけループ
			foreach($entrylist_date_arr[$ykey] as $mkey => $mvar)
			{
				foreach($this->page_conf as $pkey => $pconf)
				{
					$entrylist_link_day = array();
					// 日の数だけループ
					foreach($entrylist_date_arr[$ykey][$mkey] as $dkey => $dvar)
					{
						$link = null;
						if(1 > count($entrylist_date_arr[$ykey][$mkey][$dkey]))
						{
							continue;
						}
						if(1 == count($entrylist_date_arr[$ykey][$mkey][$dkey]))
						{
							$link = $this->page_conf[$pkey]['http_base_dir'].$this->conf['thread']['id'].'/'.$ykey.'/'.$mkey.'/'.$dkey.'_'.substr($entrylist_date_arr[$ykey][$mkey][$dkey][0]['id'],-6).'.html';
						}else{
							$link = $this->page_conf[$pkey]['http_base_dir'].$this->conf['thread']['id'].'/'.$ykey.'/'.$mkey.'/'.$dkey.'_index.html';
						}
						$arr = array(
							'year' => $ykey,
							'month' => $mkey,
							'day' => $dkey,
							'link' => $link
						);
						$entrylist_link_day[] = $arr;
					}
					$this->tpl_obj->template_dir = $pconf['template_base_dir'];
					$this->tpl_obj->assign('http_project_top_dir',$pconf['http_project_top_dir']);
					$this->tpl_obj->assign('http_thread_top_dir',$pconf['http_thread_top_dir']);
					$this->tpl_obj->assign('design_template_dir',$pconf['http_template_dir']);
					$this->tpl_obj->assign_by_ref('Entrylist_this_year',$ykey);
					$this->tpl_obj->assign_by_ref('Entrylist_this_month',$mkey);
					$this->tpl_obj->assign_by_ref('Entrylist_link_year',$entrylist_link_year);
					$this->tpl_obj->assign_by_ref('Entrylist_link_month',$entrylist_link_month);
					$this->tpl_obj->assign_by_ref('Entrylist_link_day',$entrylist_link_day);
					$this->tpl_obj->assign('default_css',$pconf['default_css']);
					$this->tpl_obj->assign('rss_1_0_url',$pconf['http_base_dir'].$this->conf['thread']['id'].'/rss.rdf');
					$this->tpl_obj->assign('dedio_rss_url',$pconf['http_base_dir'].$this->conf['thread']['id'].'/dedio_rss.rdf');
					$outdata =& $this->tpl_obj->fetch('entrylist_day.tpl');
					$filename = $this->page_conf[$pkey]['file_base_dir'].$this->conf['thread']['id'].'/'.$ykey.'/'.$mkey.'/index.html';
					check_dir($this->page_conf[$pkey]['file_base_dir'].$this->conf['thread']['id'].'/'.$ykey.'/'.$mkey.'/');
					file_put_contents($filename,$outdata);
				}
				// 月の数だけループ
				foreach($this->page_conf as $pkey => $pconf)
				{
					// 日の数だけループ
					foreach($entrylist_date_arr[$ykey][$mkey] as $dkey => $dvar)
					{
						$entrylist_whole_day = array();
						// 日の中のエントリーの数だけループ
						foreach($entrylist_date_arr[$ykey][$mkey][$dkey] as $hkey => $hvar)
						{
							$link = $this->page_conf[$pkey]['http_base_dir'].$this->conf['thread']['id'].'/'.$ykey.'/'.$mkey.'/'.$dkey.'_'.substr($hvar['id'],-6).'.html';
							$arr = array(
								'year' => $ykey,
								'month' => $mkey,
								'day' => $dkey,
								'link' => $link,
								'content' => $hvar
							);
							$entrylist_whole_day[] = $arr;
							$entrylist_all[] = $arr;
						}
						$this->tpl_obj->template_dir = $pconf['template_base_dir'];
						$this->tpl_obj->assign('http_project_top_dir',$pconf['http_project_top_dir']);
						$this->tpl_obj->assign('http_thread_top_dir',$pconf['http_thread_top_dir']);
						$this->tpl_obj->assign('design_template_dir',$pconf['http_template_dir']);
						$this->tpl_obj->assign_by_ref('Entrylist_this_year',$ykey);
						$this->tpl_obj->assign_by_ref('Entrylist_this_month',$mkey);
						$this->tpl_obj->assign_by_ref('Entrylist_this_day',$dkey);
						$this->tpl_obj->assign_by_ref('Entrylist_link_year',$entrylist_link_year);
						$this->tpl_obj->assign_by_ref('Entrylist_link_month',$entrylist_link_month);
						$this->tpl_obj->assign_by_ref('Entrylist_link_day',$entrylist_link_day);
						$this->tpl_obj->assign_by_ref('Entrylist_whole_day',$entrylist_whole_day);
						$this->tpl_obj->assign('default_css',$pconf['default_css']);
						$this->tpl_obj->assign('rss_1_0_url',$pconf['http_base_dir'].$this->conf['thread']['id'].'/rss.rdf');
						$this->tpl_obj->assign('dedio_rss_url',$pconf['http_base_dir'].$this->conf['thread']['id'].'/dedio_rss.rdf');

						$outdata =& $this->tpl_obj->fetch('entrylist_whole_day.tpl');
						$filename = $this->page_conf[$pkey]['file_base_dir'].$this->conf['thread']['id'].'/'.$ykey.'/'.$mkey.'/'.$dkey.'_index.html';
						check_dir($this->page_conf[$pkey]['file_base_dir'].$this->conf['thread']['id'].'/'.$ykey.'/'.$mkey.'/');
						file_put_contents($filename,$outdata);
					}
				}
			}
		}
		// 全エントリーリスト
		if(file_exists($pconf['template_base_dir'].'entrylist_all.tpl'))
		{
			$entrylist_all = array_reverse($entrylist_all);
//print_r($entrylist_all);
			$this->tpl_obj->assign_by_ref('Entrylist_all',$entrylist_all);
			$outdata =& $this->tpl_obj->fetch('entrylist_all.tpl');
			$filename = $this->page_conf[$pkey]['file_base_dir'].$this->conf['thread']['id'].'/entrylist_all.html';
			file_put_contents($filename,$outdata);
		}
	}

	function generate_page_entry($page_conf = array(),$targetid=null)
	{
		if(!empty($page_conf)){
			$this->set_page_conf($page_conf);
		}
		// プロジェクトデータの取得
		$project_obj =& $this->blogdata->load('project');
		$project = & $project_obj->pxml->node_data['project'];
		$thread_obj =& $this->blogdata->load('thread');
		$thread = & $thread_obj->pxml->node_data['thread'];

		$entrylist_obj =& $this->blogdata->load('entrylist');	// エントリーリストのロード

		$this->tpl_obj = new BlogPage_Smarty;
		$this->tpl_obj->assign_by_ref('Project',$project);
		$this->tpl_obj->assign_by_ref('Blog',$thread);
		$this->tpl_obj->register_object('Entrylist',$entrylist_obj);

		$entrylist =& $entrylist_obj->entrylist_all();
		if(!is_array($entrylist))
		{
			return false;
		}
		$entrylist_count = count($entrylist);
		foreach($entrylist as $ekey => $evar)
		{
			if(!empty($targetid))
				if($evar['id'] != $targetid)
					continue;
			$generator_conf = array( 'entry' => array( 'id' => $evar['id'] ) );
			$entry_obj =& $this->blogdata->load('entry',$generator_conf);
			$options['contents_nl2br'] = true;
			$options['contents_wiki'] = true;
			$entry =& $entry_obj->get($options);
/*			if($entry['input_format'] == 'x'){
				$entry['content'] = url2href($entry['content']);
			}
*/
			$this->tpl_obj->assign_by_ref('Entry',$entry);
			$commentlist_obj =& $this->blogdata->load('commentlist',$generator_conf);
			$commentlist =& $commentlist_obj->commentlist_all();
			$this->tpl_obj->assign_by_ref('Commentlist',$commentlist);
			if(is_array($commentlist)){
				$this->tpl_obj->assign('CommentTotal',count($commentlist));
			}else{
				$this->tpl_obj->assign('CommentTotal',0);
			}
			$url_this_entry = $this->gen_entry_filename($this->conf['thread']['id'],
					$evar['id'],
					HTTP_HOME_DIR.$project['cd'].'/archives/blog/');
			$this->tpl_obj->assign('url_this_entry',$url_this_entry);
			$trackback_url =HTTP_SCRIPT_DIR.PUBLOG_SCRIPT_FILE.'?lv=thread&mod=blog&cmd=tb&id='.$project['cd'].'/'.$thread['id'].'/'.$evar['id'];
			$this->tpl_obj->assign_by_ref('TrackbackURL',$trackback_url);
			// 埋め込みRDF
			$rdf_data = array(
				'about' => $url_this_entry,
				'identifier' => $url_this_entry,
				'title' => $entry['title'],
				'description' => $entry['summary'],
				'creator' => $entry['author']['name'],
				'ping' => $trackback_url
			);
			$this->tpl_obj->assign_by_ref('TrackbackRDF',tb_get_rdf($rdf_data));
			// 前後のエントリー( $entrylist の中身は日付降順)
			if($entrylist_count <= 1)
			{
				$url_prev_entry = null;
				$url_next_entry = null;
			}else
			if($ekey <= 0)
			{
				$url_prev_entry = null;
				$url_next_entry = $this->gen_entry_filename($this->conf['thread']['id'],
						$entrylist[1]['id'],
						HTTP_HOME_DIR.$project['cd'].'/archives/blog/');
			}else
			if($ekey >= ($entrylist_count - 1))
			{
				$url_prev_entry = $this->gen_entry_filename($this->conf['thread']['id'],
						$entrylist[$entrylist_count-2]['id'],
						HTTP_HOME_DIR.$project['cd'].'/archives/blog/');
				$url_next_entry = null;
			}else
			{
				$url_prev_entry = $this->gen_entry_filename($this->conf['thread']['id'],
						$entrylist[$ekey-1]['id'],
						HTTP_HOME_DIR.$project['cd'].'/archives/blog/');
				$url_next_entry = $this->gen_entry_filename($this->conf['thread']['id'],
						$entrylist[$ekey+1]['id'],
						HTTP_HOME_DIR.$project['cd'].'/archives/blog/');
			}
			$this->tpl_obj->assign('url_prev_entry',$url_next_entry);	// 逆順なので逆
			$this->tpl_obj->assign('url_next_entry',$url_prev_entry);
			//[Timeserver][2005/11/22]携帯用 前後のエントリー( $entrylist の中身は日付降順)
			if($entrylist_count <= 1)
			{
				$url_prev_entry_m = null;
				$url_next_entry_m = null;
			}
			else{
				if($ekey <= 0)
				{
					$url_prev_entry_m = null;
					$url_next_entry_m = $this->gen_entry_filename_m($this->conf['thread']['id'],
							$entrylist[1]['id'],
							HTTP_HOME_DIR.$project['cd'].'/archives/blog/');
				}
				else{
					if($ekey >= ($entrylist_count - 1))
					{
						$url_prev_entry_m = $this->gen_entry_filename_m($this->conf['thread']['id'],
								$entrylist[$entrylist_count-2]['id'],
								HTTP_HOME_DIR.$project['cd'].'/archives/blog/');
						$url_next_entry_m = null;
					}else
					{
						$url_prev_entry_m = $this->gen_entry_filename_m($this->conf['thread']['id'],
								$entrylist[$ekey-1]['id'],
								HTTP_HOME_DIR.$project['cd'].'/archives/blog/');
						$url_next_entry_m = $this->gen_entry_filename_m($this->conf['thread']['id'],
								$entrylist[$ekey+1]['id'],
								HTTP_HOME_DIR.$project['cd'].'/archives/blog/');
					}
				}
				$this->tpl_obj->assign('url_prev_entry_m',$url_next_entry_m);	// 逆順なので逆
				$this->tpl_obj->assign('url_next_entry_m',$url_prev_entry_m);
			}

			foreach($this->page_conf as $pkey => $pconf)
			{
				$this->tpl_obj->assign("publog_node_path",'/core/'.LANG.'/'.PUBLOG_SERVER_NAME.'/'.$project['cd'].'/'.$thread['id'].'/'.$evar['id']);
				$this->tpl_obj->template_dir = $pconf['template_base_dir'];
//				$outdata =& $this->tpl_obj->fetch($pconf['template']);
				$this->tpl_obj->assign('http_project_top_dir',$pconf['http_project_top_dir']);
				$this->tpl_obj->assign('http_thread_top_dir',$pconf['http_thread_top_dir']);
				$this->tpl_obj->assign('design_template_dir',$pconf['http_template_dir']);
				$this->tpl_obj->assign('default_css',$pconf['default_css']);
				$this->tpl_obj->assign('rss_1_0_url',$pconf['http_base_dir'].$this->conf['thread']['id'].'/rss.rdf');
				$this->tpl_obj->assign('dedio_rss_url',$pconf['http_base_dir'].$this->conf['thread']['id'].'/dedio_rss.rdf');
				$outdata =& $this->tpl_obj->fetch('entry.tpl');
				$filename = $this->gen_entry_filename($this->conf['thread']['id'],
						$evar['id'],
						$this->page_conf[$pkey]['file_base_dir']);
				if(!check_dir($filename)){
					die ("Can not create file(".$filename.")");
				}
//print($outdata);
				file_put_contents($filename,$outdata);
				//[Timeserver][2005/11/16][06:26]携帯用
				$outdata =& $this->tpl_obj->fetch('m_entry.tpl');
				$filename = $this->gen_entry_filename_m($this->conf['thread']['id'],
						$evar['id'],
						$this->page_conf[$pkey]['file_base_dir']);
				if(!check_dir($filename)){
					die ("Can not create file(".$filename.")");
				}
				$outdata = ereg_replace('<br />','<br>',$outdata);
				$outdata = mb_convert_encoding($outdata,'SJIS','UTF8');
				file_put_contents($filename,$outdata);
			}
		}
		return true;
	}
	function gen_entry_filename($thread_id,$entry_id,$base_dir)
	{
		$filename = $base_dir.$thread_id.'/'.
			substr($entry_id,0,4).'/'.
			substr($entry_id,4,2).'/'.
//			substr($entry_id,6,2).'/'.
//			'entry_'.$entry_id.'.html';
			substr($entry_id,6,2).'_'.
			substr($entry_id,-6).'.html';
		return $filename;
	}
	//[Timeserver][2005/11/16][06:26]携帯用
	function gen_entry_filename_m($thread_id,$entry_id,$base_dir)
	{
		$filename = $base_dir.$thread_id.'/'.
			substr($entry_id,0,4).'/'.
			substr($entry_id,4,2).'/'.
			substr($entry_id,6,2).'_'.
			substr($entry_id,-6).'m.html';
		return $filename;
	}

}
?>
