<?php
// $Id: entrylistdata.class.php,v 1.4 2004/09/11 14:25:55 fukami Exp $

/*
	$entry_data = array(
		'id' => null,
		'title' => null,
		'tagline' => null,
		'issued' => null,
		'modified' => null
		'author' => array( 'name' => null )
	);
*/

// エントリーリストデータ共通処理クラス
class EntrylistData extends PUBLOGXMLListData
{

// コンストラクタ ----------------------------------
	function EntrylistData($conf = null)
	{
		$list_conf = array(
			'rt' => 'entrylist',	// root tag name
			'lt' => 'entry'		// list tag name
		);

		parent::PUBLOGXMLListData($conf,$list_conf);
	}

// テンプレートへ渡すデータの加工 ----------------------------------
	function &entrylist_all($arr=array())
	{
		$entrylist =& $this->pxml->get_array('/entrylist/entry');
		if((!empty($arr['last'])) and (is_int((int)$arr['last'])))
		{
			$entrylist_buf = array();
			$ctr = count($entrylist);
			$start = $ctr - (int)$arr['last'];
			if($start <= 0){
				$start = 0;
			}
			for($i = $start; $i < $ctr;$i++)
			{
				$entrylist_buf[] = $entrylist[$i];
			}
			$entrylist =& $entrylist_buf;
		}
		if(!is_array($entrylist))
		{
			return array();
		}
		if(!empty($arr['sort']))
		{
			if('desc' == $arr['sort'])
			{
				$entrylist = array_reverse($entrylist);
			}
		}else{
			$entrylist = array_reverse($entrylist);
		}
		return $entrylist;
	}

	// エントリーリストの総数
	function &entrylist_count($arr=array())
	{
		$entrylist =& $this->pxml->get_array('/entrylist/entry');
		return count($entrylist);
	}

	// id が $pattern と合致するレコードのみ返す
	// $pattern は正規表現
	function &entrylist_id_search($pattern)
	{
		return $this->pxml->get_array_id_search('/entrylist/entry',$pattern);
	}
	// 全エントリーリストを年月日の多次元配列に放り込む
	function &entrylist_mdarray()
	{
		$entrylist_all =& $this->entrylist_all();	// 全エントリーリスト
		// ----- ベタベタな処理スタート -----
		$entryidkey=array();
		// id を key にして配列にいれなおして、
		foreach($entrylist_all as $var)
		{
			$entryidkey[$var['id']] = $var;
		}
		// key で sort して、
		ksort($entryidkey);
		$mdarray = array(); // 年・月・日での配列
		foreach($entryidkey as $key => $var)
		{
			$yyyy = substr($key,0,4);
			$mm = substr($key,4,2);
			$dd = substr($key,6,2);
			$mdarray[$yyyy][$mm][$dd][] = $var;
		}
		return $mdarray;
	}

}


?>
