<?php


// $type : 生成するカレンダータイプ
// $pos  : 生成するターゲット月日(yyyymmdd)
function &do_plugin_action_thread_blog_calendar(&$arr,&$dataobj)
{
	$type = $arr['type'];
	$pos = $arr['pos'];
	
	$conf =& $dataobj->conf;
	$page_conf =& $dataobj->page_conf;
	
	if(empty($type)){
		$type = 'tor';
	}
	if('now' == $pos){
		$pos = date("Ymd");
//		$pos = null;
	}
	$function_name = 'calendar_'.$type;
	if(!function_exists($function_name)){
		return null;
	}

	$entrylist =& $dataobj->blogdata->load('entrylist');	// エントリーリストのロード
	$mdarray =& $entrylist->entrylist_mdarray();	// 全エントリーリストの多次元配列
	$target_month =& $mdarray[substr($pos,0,4)][substr($pos,4,2)];
	if(!is_array($target_month))
	{
		$target_month = array();
	}
	// リンク先がある(アーカイブがある)日のリスト
	$calarray = array();
	// 指定年月の中のアーカイブがある日の分ループ
	foreach($target_month as $key => $var)
	{
		$calarray[substr($pos,0,6).$key] = 
			$page_conf['index']['http_base_dir'].$conf['thread']['id'].'/'.
			substr($pos,0,4).'/'.substr($pos,4,2).'/'.$key.'_index.html';
	}

	$thread_arclink = $page_conf['index']['http_base_dir'].$conf['thread']['id'].'/entry_index.html';
	$year_arclink = $page_conf['index']['http_base_dir'].$conf['thread']['id'].'/'.substr($pos,0,4).'/index.html';
	$month_arclink = $page_conf['index']['http_base_dir'].$conf['thread']['id'].'/'.substr($pos,0,4).'/'.substr($pos,4,2).'/index.html';
	$archivelink = array(
		'thread' => $thread_arclink,
		'year' => $year_arclink,
		'month' => $month_arclink
	);
	 
	return $function_name($calarray,$pos,$archivelink);
}

function calendar_tor($linkarr,$ymd=null,$archivelink=array())
{
	$thread_arclink = $archivelink['thread'];

// カレンダー by ToR
//  Edit:2002/12/20 R.Miyake
//  re:2003/03/25 前後の余白に前月・次月の日付を表示
//  re:2003/03/26 多少ビジュアル化(^^);
//  Edit:2004/06/24 E.Fukami
// ===ご注意===
//  対応環境の検討は不十分ですので適当に改変して下さい。
//  PHP 4.2.0 以降ではディレクティブ php_flag register_globals on
//  でないと正常に動作しません。

// 今日の日付を保存
$defday = getdate();
$d_yr = $defday[year];
$d_mn = $defday[mon];
$d_dy = $defday[mday];
//$de_day = 'Today:'.sprintf("%4d/%02d/%02d", $d_yr, $d_mn, $d_dy);
$de_day = null;

// 引数を調べて指定日付を保存
if(ereg("^[0-9]{8}",$ymd)){
  $yr = substr($ymd,0,4);
  $mon = substr($ymd,4,2);
  $dy = substr($ymd,6,2);

  $fg_ch = (substr($ymd,9,1)=="1") ? true : false;
  $fg_d = (($yr == $d_yr) && ($mon == $d_mn)) ? true : false;
  $today = getdate(mktime(0,0,0,$mon,$dy,$yr));
}else{
  $fg_d = true;
  $today = $defday;
}
$m_num = $today[mon];
$d_num = $today[mday];
$year = $today[year];

// カレンダーの変数初期設定
$dImg = "./image";
$lastday = strftime ("%d", mktime (0,0,0,$m_num,0,$year));
$f_holi = 100;  // 振替休日検出用カウンタ（数字はダミー）
$f_today = getdate(mktime(0,0,0,$m_num,1,$year));
$wday = $f_today[wday];
$wday_n = 0;
$day = 1;
$fweek = ($wday=="0") ? false : true;
$m_name = "<small><a href=\"".$archivelink['year']."\">".$year."年</a><a href=\"".$archivelink['month']."\">".substr($m_num,0)."月</a></small>";

$kong = ($fg_d) ? "<small>▼</small>":"<small>▲</small>";
$kong = ($fg_d) ? "\" title=\"list\">$kong" : "\" title=\"$today[mon]list\">$kong";

$prev_month = date("Ymd", mktime(0,0,0,$m_num,0,$year));
$next_month = date("Ymd", mktime(0,0,0,$m_num+1,1,$year));

// 日の決まった祝日（春分・秋分の日はダミー）
$holiday1 = array('dammy','春分の日','秋分の日',
'0101','0211','0429','0503','0504','0505','1103','1123','1223');

// 春分・秋分日を計算（1980-2099まで有効）
$dirY = 1980;
$syunbun = (int)(20.8431 + 0.242194*($year - $dirY) - (int)(($year - $dirY)/4));
$syubun = (int)(23.2488 + 0.242194*($year - $dirY) - (int)(($year - $dirY)/4));
$holiday1[1] = ($year <= "2099") ? "03".substr("0".$syunbun,-2) : '';
$holiday1[2] = ($year <= "2099") ? "09".substr("0".$syubun,-2) : '';

// 日の決まっていない祝日（何月 => 第何月曜）
$holiday2 = array(1 => 2, 7 => 3, 9 => 3, 10 => 2);

// HTML 出力
$calendar_header= <<<EOH

<div class="calendar">

<table summary="calendar" border="0" cellspacing="1" cellpadding="0" class="calendar_table">
 <colgroup><col span="7" /></colgroup>
 <thead>
  <tr> 
   <th colspan="7" abbr="Title">
    $m_name <a href="$thread_arclink$kong</a>
   </th>
  </tr>
 </thead>
 <tfoot>
  <tr>
   <td colspan="7">$de_day</td>
  </tr>
 </tfoot>

 <tbody>
  <tr> 
   <th class="sunday" abbr="Sun">日</th>
   <th abbr="Mon">月</th>
   <th abbr="Tue">火</th>
   <th abbr="Wed">水</th>
   <th abbr="Thu">木</th>
   <th abbr="Fri">金</th>
   <th class="saturday" abbr="Sat">土</th>
  </tr>
  <tr>
EOH;

// Blank
$calendar_body = null;

$x = $lastday-$wday+1;
if($fweek){
  for ($i=$x; $i<=$lastday; $i++) {
    $calendar_body .= "   <td class=\"blk\"><small>$i</small></td>\n";
  }
  $fweek=false;
}

while(checkdate($m_num,$day,$year)){
//  $link = sprintf("%4d%02d%02d", $year, $m_num, $day);
	$thisdate = sprintf("%4d%02d%02d", $year, $m_num, $day);
	if(!empty($linkarr[$thisdate]))
	{
		$link = $linkarr[$thisdate];
	}else{
		$link = null;
	}

  $o_holi = array_search (substr($link,4,4), $holiday1);
  $hol1 = ($o_holi) ? ' holiday1' : '';
  if($o_holi && ($wday == 0)){ $f_holi = 1; }
  if ($f_holi == 2) { $hol1 = ' holiday1'; $f_holi = 100; }
  if($wday == 1){ $wday_n++; }
  $hol2 = (array_key_exists ($m_num, $holiday2) && ($holiday2[$m_num] == $wday_n) && ($wday == 1)) ? ' holiday2' : '';

  if($wday == 0){ $calendar_body .= ($day == 1) ? "" : "  </tr>\n  <tr>\n"; }
  if(($day == $today[mday]) && ($m_num == $today[mon]) && ($year == $today[year]) && !$fg_ch){
    // Today 
    $calendar_body .= "   <td class=\"today$hol1$hol2\">";
		if(empty($link))
			$calendar_body .= $day;
		else
			$calendar_body .= "<a href=\"$link\" title=\"指定日\"><strong>$day</strong></a>";
		$calendar_body .= "</td>\n";
  }elseif($wday == 0){
    // Sunday
    $calendar_body .= "   <td class=\"sunday$hol1\">";
		if(empty($link))
			$calendar_body .= $day;
		else
			$calendar_body .= "<a href=\"$link\">$day</a>";
		$calendar_body .= "</td>\n";
  }elseif($wday == 6){
    // Saturday
    $calendar_body .= "   <td class=\"saturday$hol1\">";
		if(empty($link))
			$calendar_body .= $day;
		else
			$calendar_body .= "<a href=\"$link\">$day</a>";
		$calendar_body .= "</td>\n";
  }else{
    // Weekday
    $calendar_body .= "   <td class=\"weekday$hol1$hol2\">";
		if(empty($link))
			$calendar_body .= $day;
		else
			$calendar_body .= "<a href=\"$link\">$day</a>";
		$calendar_body .= "</td>\n";
  }
  $f_holi++;
  $day++;
  $wday++;
  $wday = $wday % 7;
}

// Blank
$x = 8-$wday;
if($wday > 0){
  for ($i=1; $i<$x; $i++) {
    $calendar_body .= "   <td class=\"blk\"><small>$i</small></td>\n";
  }
}

$calendar_body .= <<<EOH
  </tr>
 </tbody>
</table>

</div>
EOH;
$calendar_body .= "\n\n";

$calendar = $calendar_header.$calendar_body;
return $calendar;
}



function calendar_bar($linkarr,$ymd=null,$archivelink=array())
{
	$thread_arclink = $archivelink['thread'];

// カレンダー by ToR
//  Edit:2002/12/20 R.Miyake
//  re:2003/03/25 前後の余白に前月・次月の日付を表示
//  re:2003/03/26 多少ビジュアル化(^^);
//  Edit:2004/06/24 E.Fukami
//  Edit:2004/09/15 E.Fukami
// ===ご注意===
//  対応環境の検討は不十分ですので適当に改変して下さい。
//  PHP 4.2.0 以降ではディレクティブ php_flag register_globals on
//  でないと正常に動作しません。

// 今日の日付を保存
$defday = getdate();
$d_yr = $defday[year];
$d_mn = $defday[mon];
$d_dy = $defday[mday];
//$de_day = 'Today:'.sprintf("%4d/%02d/%02d", $d_yr, $d_mn, $d_dy);
$de_day = null;

// 引数を調べて指定日付を保存
if(ereg("^[0-9]{8}",$ymd)){
  $yr = substr($ymd,0,4);
  $mon = substr($ymd,4,2);
  $dy = substr($ymd,6,2);

  $fg_ch = (substr($ymd,9,1)=="1") ? true : false;
  $fg_d = (($yr == $d_yr) && ($mon == $d_mn)) ? true : false;
  $today = getdate(mktime(0,0,0,$mon,$dy,$yr));
}else{
  $fg_d = true;
  $today = $defday;
}
$m_num = $today[mon];
$d_num = $today[mday];
$year = $today[year];

// カレンダーの変数初期設定
$dImg = "./image";
$lastday = strftime ("%d", mktime (0,0,0,$m_num,0,$year));
$f_holi = 100;  // 振替休日検出用カウンタ（数字はダミー）
$f_today = getdate(mktime(0,0,0,$m_num,1,$year));
$wday = $f_today[wday];
$wday_n = 0;
$day = 1;
$fweek = ($wday=="0") ? false : true;
$m_name = "<small><a href=\"".$archivelink['year']."\">".$year."年</a><a href=\"".$archivelink['month']."\">".substr($m_num,0)."月</a></small>";

$kong = ($fg_d) ? "<small>.</small>":"<small>.</small>";
$kong = ($fg_d) ? "\" title=\"list\">$kong" : "\" title=\"$today[mon]list\">$kong";

$prev_month = date("Ymd", mktime(0,0,0,$m_num,0,$year));
$next_month = date("Ymd", mktime(0,0,0,$m_num+1,1,$year));

// 日の決まった祝日（春分・秋分の日はダミー）
$holiday1 = array('dammy','春分の日','秋分の日',
'0101','0211','0429','0503','0504','0505','1103','1123','1223');

// 春分・秋分日を計算（1980-2099まで有効）
$dirY = 1980;
$syunbun = (int)(20.8431 + 0.242194*($year - $dirY) - (int)(($year - $dirY)/4));
$syubun = (int)(23.2488 + 0.242194*($year - $dirY) - (int)(($year - $dirY)/4));
$holiday1[1] = ($year <= "2099") ? "03".substr("0".$syunbun,-2) : '';
$holiday1[2] = ($year <= "2099") ? "09".substr("0".$syubun,-2) : '';

// 日の決まっていない祝日（何月 => 第何月曜）
$holiday2 = array(1 => 2, 7 => 3, 9 => 3, 10 => 2);

// HTML 出力
$calendar_header= <<<EOH

<div class="calendar">
<div class="calendar_bar_month">
$m_name <a href="$thread_arclink$kong</a>
</div>
<div class="calendar_bar_day">
EOH;

// Blank
$calendar_body = null;

$x = $lastday-$wday+1;
if($fweek){
  for ($i=$x; $i<=$lastday; $i++) {
    $calendar_body .= null;
  }
  $fweek=false;
}

while(checkdate($m_num,$day,$year)){
//  $link = sprintf("%4d%02d%02d", $year, $m_num, $day);
	$thisdate = sprintf("%4d%02d%02d", $year, $m_num, $day);
	if(!empty($linkarr[$thisdate]))
	{
		$link = $linkarr[$thisdate];
	}else{
		$link = null;
	}

  $o_holi = array_search (substr($link,4,4), $holiday1);
  $hol1 = ($o_holi) ? ' holiday1' : '';
  if($o_holi && ($wday == 0)){ $f_holi = 1; }
  if ($f_holi == 2) { $hol1 = ' holiday1'; $f_holi = 100; }
  if($wday == 1){ $wday_n++; }
  $hol2 = (array_key_exists ($m_num, $holiday2) && ($holiday2[$m_num] == $wday_n) && ($wday == 1)) ? ' holiday2' : '';

  if($wday == 0){ $calendar_body .= ($day == 1) ? "" : ""; }
  if(($day == $today[mday]) && ($m_num == $today[mon]) && ($year == $today[year]) && !$fg_ch){
    // Today 
    $calendar_body .= "<span class=\"calendar_bar_today\">";
		if(empty($link))
			$calendar_body .= $day;
		else
			$calendar_body .= "<a href=\"$link\">$day</a>";
		$calendar_body .= "</span>\n";
  }elseif($wday == 0){
    // Sunday
    $calendar_body .= "<span class=\"calendar_bar_sunday\">";
		if(empty($link))
			$calendar_body .= $day;
		else
			$calendar_body .= "<a href=\"$link\">$day</a>";
		$calendar_body .= "</span>\n";
  }elseif($wday == 6){
    // Saturday
    $calendar_body .= "<span class=\"calendar_bar_saturday\">";
		if(empty($link))
			$calendar_body .= $day;
		else
			$calendar_body .= "<a href=\"$link\">$day</a>";
		$calendar_body .= "</span>\n";
  }else{
    // Weekday
    $calendar_body .= "<span class=\"calendar_bar_weekday\">";
		if(empty($link))
			$calendar_body .= $day;
		else
			$calendar_body .= "<a href=\"$link\">$day</a>";
		$calendar_body .= "</span>\n";
  }
  $f_holi++;
  $day++;
  $wday++;
  $wday = $wday % 7;
}

// Blank
$x = 8-$wday;
if($wday > 0){
  for ($i=1; $i<$x; $i++) {
    $calendar_body .= null;
  }
}

$calendar_body .= <<<EOH
</div>
</div>
EOH;
$calendar_body .= "\n\n";

$calendar = $calendar_header.$calendar_body;
return $calendar;
}




function calendar_lived($linkarr,$ymd=null,$archivelink=array())
{

$monstr=array(
	'1' => 'January',
	'2' => 'February',
	'3' => 'March',
	'4' => 'April',
	'5' => 'May',
	'6' => 'June',
	'7' => 'July',
	'8' => 'August',
	'9' => 'September',
	'10' => 'October',
	'11' => 'November',
	'12' => 'December'
);

	$thread_arclink = $archivelink['thread'];

// 今日の日付を保存
$defday = getdate();
$d_yr = $defday[year];
$d_mn = $defday[mon];
$d_dy = $defday[mday];
//$de_day = 'Today:'.sprintf("%4d/%02d/%02d", $d_yr, $d_mn, $d_dy);
$de_day = null;

// 引数を調べて指定日付を保存
if(ereg("^[0-9]{8}",$ymd)){
  $yr = substr($ymd,0,4);
  $mon = substr($ymd,4,2);
  $dy = substr($ymd,6,2);

  $fg_ch = (substr($ymd,9,1)=="1") ? true : false;
  $fg_d = (($yr == $d_yr) && ($mon == $d_mn)) ? true : false;
  $today = getdate(mktime(0,0,0,$mon,$dy,$yr));
}else{
  $fg_d = true;
  $today = $defday;
}
$m_num = $today[mon];
$d_num = $today[mday];
$year = $today[year];

// カレンダーの変数初期設定
$dImg = "./image";
$lastday = strftime ("%d", mktime (0,0,0,$m_num,0,$year));
$f_holi = 100;  // 振替休日検出用カウンタ（数字はダミー）
$f_today = getdate(mktime(0,0,0,$m_num,1,$year));
$wday = $f_today[wday];
$wday_n = 0;
$day = 1;
$fweek = ($wday=="0") ? false : true;
$m_name = "<small><a href=\"".$archivelink['month']."\">".$monstr[substr($m_num,0)].",</a><a href=\"".$archivelink['year']."\">".$year."</a></small>";


$kong = ($fg_d) ? "<small>.</small>":"<small>.</small>";
$kong = ($fg_d) ? "\" title=\"list\">$kong" : "\" title=\"$today[mon]list\">$kong";

$prev_month = date("Ymd", mktime(0,0,0,$m_num,0,$year));
$next_month = date("Ymd", mktime(0,0,0,$m_num+1,1,$year));

// 日の決まった祝日（春分・秋分の日はダミー）
$holiday1 = array('dammy','春分の日','秋分の日',
'0101','0211','0429','0503','0504','0505','1103','1123','1223');

// 春分・秋分日を計算（1980-2099まで有効）
$dirY = 1980;
$syunbun = (int)(20.8431 + 0.242194*($year - $dirY) - (int)(($year - $dirY)/4));
$syubun = (int)(23.2488 + 0.242194*($year - $dirY) - (int)(($year - $dirY)/4));
$holiday1[1] = ($year <= "2099") ? "03".substr("0".$syunbun,-2) : '';
$holiday1[2] = ($year <= "2099") ? "09".substr("0".$syubun,-2) : '';

// 日の決まっていない祝日（何月 => 第何月曜）
$holiday2 = array(1 => 2, 7 => 3, 9 => 3, 10 => 2);

// HTML 出力
$calendar_header= <<<EOH
<!-- calender plugin 'lived' -->
<div class="calendarhead">$m_name <a href="$thread_arclink$kong</a></div>
<table border="0" cellspacing="0" cellpadding="0" class="calendartable">
<tr>
	<td class="calendarwd" width="100%">
		<table border="0" cellspacing="0" cellpadding="2" width="100%">
		<tr>
		<td width="14%" align="center">
		<span class="calendarweek">S</span>
		</td>
		<td width="14%" align="center">
		<span class="calendarweek">M</span>
		</td>
		<td width="14%" align="center">
		<span class="calendarweek">T</span>
		</td>
		<td width="14%" align="center">
		<span class="calendarweek">W</span>
		</td>
		<td width="14%" align="center">
		<span class="calendarweek">T</span>
		</td>
		<td width="14%" align="center">
		<span class="calendarweek">F</span>
		</td>
		<td width="14%" align="center">
		<span class="calendarweek">S</span>
		</td>
		</tr>
		</table>
	</td>
</tr>
<tr>
	<td width="100%">
		<table border="0" cellspacing="0" cellpadding="2" width="100%">
		<tr>		

EOH;

// Blank
$calendar_body = null;

$x = $lastday-$wday+1;
if($fweek){
  for ($i=$x; $i<=$lastday; $i++) {
    $calendar_body .=<<<EOH
			<td width="14%" align="center" class="calendard"><span class="calendar">&nbsp;</span></td>
EOH;
  }
  $fweek=false;
}

while(checkdate($m_num,$day,$year)){
//  $link = sprintf("%4d%02d%02d", $year, $m_num, $day);
	$thisdate = sprintf("%4d%02d%02d", $year, $m_num, $day);
	if(!empty($linkarr[$thisdate]))
	{
		$link = $linkarr[$thisdate];
	}else{
		$link = null;
	}

  $o_holi = array_search (substr($link,4,4), $holiday1);
  $hol1 = ($o_holi) ? ' holiday1' : '';
  if($o_holi && ($wday == 0)){ $f_holi = 1; }
  if ($f_holi == 2) { $hol1 = ' holiday1'; $f_holi = 100; }
  if($wday == 1){ $wday_n++; }
  $hol2 = (array_key_exists ($m_num, $holiday2) && ($holiday2[$m_num] == $wday_n) && ($wday == 1)) ? ' holiday2' : '';

  if($wday == 0){ $calendar_body .= ($day == 1) ? "" : "  </tr>\n  <tr>\n"; }
  if(($day == $today[mday]) && ($m_num == $today[mon]) && ($year == $today[year]) && !$fg_ch){
    // Today 
    $calendar_body .= "";
		if(empty($link)){
			$calendar_body .= <<<EOH
			<td width="14%" align="center" class="calendard"><span class="calendar">$day</span></td>
EOH;
		}
		else{
			$calendar_body .= <<<EOH
			<td width="14%" align="center" class="calendardbg"><span class="calendar"><a class="acalendar" href="$link">$day</a></span></td>
EOH;
		}
		$calendar_body .= "\n";
  }elseif($wday == 0){
    // Sunday
    $calendar_body .= "";
		if(empty($link)){
			$calendar_body .= <<<EOH
			<td width="14%" align="center" class="calendard"><span class="calendar">$day</span></td>
EOH;
		}
		else{
			$calendar_body .= <<<EOH
			<td width="14%" align="center" class="calendardbg"><span class="calendar"><a class="acalendar" href="$link">$day</a></span></td>
EOH;
		}
		$calendar_body .= "\n";
  }elseif($wday == 6){
    // Saturday
    $calendar_body .= "";
		if(empty($link)){
			$calendar_body .= <<<EOH
			<td width="14%" align="center" class="calendard"><span class="calendar">$day</span></td>
EOH;
		}
		else{
			$calendar_body .= <<<EOH
			<td width="14%" align="center" class="calendardbg"><span class="calendar"><a class="acalendar" href="$link">$day</a></span></td>
EOH;
		}
		$calendar_body .= "\n";
  }else{
    // Weekday
    $calendar_body .= "";
		if(empty($link)){
			$calendar_body .= <<<EOH
			<td width="14%" align="center" class="calendard"><span class="calendar">$day</span></td>
EOH;
		}
		else{
			$calendar_body .= <<<EOH
			<td width="14%" align="center" class="calendardbg"><span class="calendar"><a class="acalendar" href="$link">$day</a></span></td>
EOH;
		}
		$calendar_body .= "\n";
  }
  $f_holi++;
  $day++;
  $wday++;
  $wday = $wday % 7;
}

// Blank
$x = 8-$wday;
if($wday > 0){
  for ($i=1; $i<$x; $i++) {
    $calendar_body .=<<<EOH
			<td width="14%" align="center" class="calendard"><span class="calendar">&nbsp;</span></td>
EOH;
  }
}

$calendar_body .= <<<EOH
</tr></table>
</td></tr></table>
EOH;
$calendar_body .= "\n\n";

$calendar = $calendar_header.$calendar_body;
return $calendar;
}



//////////////////
// mt
function calendar_mt($linkarr,$ymd=null,$archivelink=array())
{

$monstr=array(
	'1' => 'January',
	'2' => 'February',
	'3' => 'March',
	'4' => 'April',
	'5' => 'May',
	'6' => 'June',
	'7' => 'July',
	'8' => 'August',
	'9' => 'September',
	'10' => 'October',
	'11' => 'November',
	'12' => 'December'
);

	$thread_arclink = $archivelink['thread'];

// 今日の日付を保存
$defday = getdate();
$d_yr = $defday[year];
$d_mn = $defday[mon];
$d_dy = $defday[mday];
//$de_day = 'Today:'.sprintf("%4d/%02d/%02d", $d_yr, $d_mn, $d_dy);
$de_day = null;

// 引数を調べて指定日付を保存
if(ereg("^[0-9]{8}",$ymd)){
  $yr = substr($ymd,0,4);
  $mon = substr($ymd,4,2);
  $dy = substr($ymd,6,2);

  $fg_ch = (substr($ymd,9,1)=="1") ? true : false;
  $fg_d = (($yr == $d_yr) && ($mon == $d_mn)) ? true : false;
  $today = getdate(mktime(0,0,0,$mon,$dy,$yr));
}else{
  $fg_d = true;
  $today = $defday;
}
$m_num = $today[mon];
$d_num = $today[mday];
$year = $today[year];

// カレンダーの変数初期設定
$dImg = "./image";
$lastday = strftime ("%d", mktime (0,0,0,$m_num,0,$year));
$f_holi = 100;  // 振替休日検出用カウンタ（数字はダミー）
$f_today = getdate(mktime(0,0,0,$m_num,1,$year));
$wday = $f_today[wday];
$wday_n = 0;
$day = 1;
$fweek = ($wday=="0") ? false : true;
$m_name = "<small><a href=\"".$archivelink['month']."\">".$monstr[substr($m_num,0)]."</a> <a href=\"".$archivelink['year']."\">".$year."</a></small>";


$kong = ($fg_d) ? "<small>.</small>":"<small>.</small>";
$kong = ($fg_d) ? "\" title=\"list\">$kong" : "\" title=\"$today[mon]list\">$kong";

$prev_month = date("Ymd", mktime(0,0,0,$m_num,0,$year));
$next_month = date("Ymd", mktime(0,0,0,$m_num+1,1,$year));

// 日の決まった祝日（春分・秋分の日はダミー）
$holiday1 = array('dammy','春分の日','秋分の日',
'0101','0211','0429','0503','0504','0505','1103','1123','1223');

// 春分・秋分日を計算（1980-2099まで有効）
$dirY = 1980;
$syunbun = (int)(20.8431 + 0.242194*($year - $dirY) - (int)(($year - $dirY)/4));
$syubun = (int)(23.2488 + 0.242194*($year - $dirY) - (int)(($year - $dirY)/4));
$holiday1[1] = ($year <= "2099") ? "03".substr("0".$syunbun,-2) : '';
$holiday1[2] = ($year <= "2099") ? "09".substr("0".$syubun,-2) : '';

// 日の決まっていない祝日（何月 => 第何月曜）
$holiday2 = array(1 => 2, 7 => 3, 9 => 3, 10 => 2);

// HTML 出力
$calendar_header= <<<EOH
<!-- calender plugin 'mt' -->
<div align="center" class="calendar">
<table border="0" cellspacing="4" cellpadding="0" summary="Monthly calendar with links to each day's posts"><caption class="calendarhead">$m_name<a href="$thread_arclink$kong</a></caption>
<tr>
<th abbr="Sunday" align="center"><span class="calendar">Sun</span></th>
<th abbr="Monday" align="center"><span class="calendar">Mon</span></th>
<th abbr="Tuesday" align="center"><span class="calendar">Tue</span></th>
<th abbr="Wednesday" align="center"><span class="calendar">Wed</span></th>
<th abbr="Thursday" align="center"><span class="calendar">Thu</span></th>
<th abbr="Friday" align="center"><span class="calendar">Fri</span></th>
<th abbr="Saturday" align="center"><span class="calendar">Sat</span></th>
</tr>
<tr>

EOH;

// Blank
$calendar_body = null;

$x = $lastday-$wday+1;
if($fweek){
  for ($i=$x; $i<=$lastday; $i++) {
    $calendar_body .=<<<EOH
			<td align="center"><span class="calendar">&nbsp;</span></td>
EOH;
  }
  $fweek=false;
}

while(checkdate($m_num,$day,$year)){
//  $link = sprintf("%4d%02d%02d", $year, $m_num, $day);
	$thisdate = sprintf("%4d%02d%02d", $year, $m_num, $day);
	if(!empty($linkarr[$thisdate]))
	{
		$link = $linkarr[$thisdate];
	}else{
		$link = null;
	}

  $o_holi = array_search (substr($link,4,4), $holiday1);
  $hol1 = ($o_holi) ? ' holiday1' : '';
  if($o_holi && ($wday == 0)){ $f_holi = 1; }
  if ($f_holi == 2) { $hol1 = ' holiday1'; $f_holi = 100; }
  if($wday == 1){ $wday_n++; }
  $hol2 = (array_key_exists ($m_num, $holiday2) && ($holiday2[$m_num] == $wday_n) && ($wday == 1)) ? ' holiday2' : '';

  if($wday == 0){ $calendar_body .= ($day == 1) ? "" : "  </tr>\n  <tr>\n"; }
  if(($day == $today[mday]) && ($m_num == $today[mon]) && ($year == $today[year]) && !$fg_ch){
    // Today 
    $calendar_body .= "";
		if(empty($link)){
			$calendar_body .= <<<EOH
<td align="center"><span class="calendar">
$day</span></td>
EOH;
		}
		else{
			$calendar_body .= <<<EOH
<td align="center"><span class="calendar">
<a href="$link">$day</a></span></td>
EOH;
		}
		$calendar_body .= "\n";
  }elseif($wday == 0){
    // Sunday
    $calendar_body .= "";
		if(empty($link)){
			$calendar_body .= <<<EOH
<td align="center"><span class="calendar">
$day</span></td>
EOH;
		}
		else{
			$calendar_body .= <<<EOH
<td align="center"><span class="calendar">
<a href="$link">$day</a></span></td>
EOH;
		}
		$calendar_body .= "\n";
  }elseif($wday == 6){
    // Saturday
    $calendar_body .= "";
		if(empty($link)){
			$calendar_body .= <<<EOH
<td align="center"><span class="calendar">
$day</span></td>
EOH;
		}
		else{
			$calendar_body .= <<<EOH
<td align="center"><span class="calendar">
<a href="$link">$day</a></span></td>
EOH;
		}
		$calendar_body .= "\n";
  }else{
    // Weekday
    $calendar_body .= "";
		if(empty($link)){
			$calendar_body .= <<<EOH
<td align="center"><span class="calendar">
$day</span></td>
EOH;
		}
		else{
			$calendar_body .= <<<EOH
<td align="center"><span class="calendar">
<a href="$link">$day</a></span></td>
EOH;
		}
		$calendar_body .= "\n";
  }
  $f_holi++;
  $day++;
  $wday++;
  $wday = $wday % 7;
}

// Blank
$x = 8-$wday;
if($wday > 0){
  for ($i=1; $i<$x; $i++) {
    $calendar_body .=<<<EOH
<td align="center"><span class="calendar">
&nbsp;</span></td>
EOH;
  }
}

$calendar_body .= <<<EOH
</table>
</div>
EOH;
$calendar_body .= "\n\n";

$calendar = $calendar_header.$calendar_body;
return $calendar;
}



?>
