<?php
/********************************************************************
 *
 *  PUBLOGトラックバックモジュール
 *  lv=base,mod=tb
 *  $Id: tb.done.php,v 1.7.2.1 2006/02/13 14:24:10 n_a_o Exp $
 *
 * Publog Developers Team  http://publog.net/
 * License: GPL
 ********************************************************************/

require_once('class/xml.class.php');
require_once('class/publogxmldata.class.php');
require_once('class/publogxmllistdata.class.php');
require_once('class/projectdata.class.php');
require_once('class/threadlistdata.class.php');
require_once('class/threaddata.class.php');
require_once('mod/thread/blog/class/entrylistdata.class.php');
require_once('mod/thread/blog/class/entrylistdata.class.php');
require_once('mod/thread/blog/class/entrydata.class.php');
require_once('mod/thread/blog/class/commentlistdata.class.php');
require_once('mod/thread/blog/class/blog_pagegenerator.class.php');
require_once('mod/thread/blog/class/blog_smarty.class.php');

require_once('class/publogdata.class.php');
require_once('mod/thread/blog/class/blog_data.class.php');

require_once('mod/thread/blog/blog.func.php');

require_once('func/trackback.func.php');

function do_mod_proc_disp()
{
	global $vars, $retvars;
	global $smes,$pmes;
	global $logindat,$prjdat,$userdat;
	global $systpl;
	require('func/inc/vars_to_variable.inc.php');

	//referer付きのTrackBack Pingは無視
	if(!empty($_SERVER['HTTP_REFERER'])){
		die(''); //return no message
	}

	// TrackBack Ping における URL パラメータは必須である。
	if (empty($url)){
		tb_xml_msg(1,'It is an indispensable parameter. URL is not set up.');
	}
	//[Timeserver][2006/01/16][08:11]
	//Spamチェック↓のブラックリスト利用
	//http://bulkfeeds.net/app/blacklist 
	//http://blog.bulknews.net/mt/archives/001834.html 
	//とりあえず、ドメイン分だけで、フォルダ付きについては無視してます。
	else{
		$temphost   = ereg_replace("http:\/\/", "", $url);
		$temphost   = ereg_replace("\/.*", "", $temphost);
		$result = dns_get_record($temphost.".rbl.bulkfeeds.jp");
		//spamに登録されている場合は127.0.0.2を返すのではじく
		if($result[0]['ip']=="127.0.0.2"){
			tb_xml_msg(1,'It is an indispensable parameter. URL is not correct.');
			//print("spam!".$temphost);
		}

	}
	
	
	if (!is_url($url))
	{
		tb_xml_msg(1,'TrackBack URL Error.');
	}
	// Query String を得る
	if (empty($id))
	{
		tb_xml_msg(1,'TrackBack Ping URL is inaccurate.');
	}

	$id_arr = explode('/',$id);
	if(3 > count($id_arr))
	{
		tb_xml_msg(1,'TrackBack id Error.');
	}
	$project_cd = $id_arr[0];
	$thread_id = $id_arr[1];
	$entry_id = $id_arr[2];

	if(empty($author))
	{
		$author = '名無しさん';
	}
	
	

	$entry_id_yyyy = substr($entry_id,0,4);
	$entry_id_mm = substr($entry_id,4,2);

	$name_list=sep_name_trip10($author);	// name, trip
	$now = now_w3c();

	// データオブジェクト ====================
	$blogdata_conf = array(
				'project' => array(
					'cd' => $project_cd
				),
				'thread' => array(
					'id' => $thread_id
				),
				'entry' => array(
					'id' => $entry_id
				),
				'xml_file' => array(
					'sys_dir' => SYS_DIR,
					'base_dir' => APATH_HOME_DIR,
					'script_dir' => APATH_SCRIPT_DIR
				)
			);
	$blogdata = new BlogData($blogdata_conf);

	$add_comment = array(
				'id' => null,
				'title' => mb_convert_encoding($title,'UTF-8','auto'),
				'link' => mb_convert_encoding($url,'UTF-8','auto'),
				'type' => 'text',
				'format' => 'text/plain',
				'language' => LANG,
				'author' => array(
					'name' => $name_list['name'],
					'trip' => $name_list['trip'],
					'email' => null
				),
				'content' => mb_convert_encoding($excerpt,'UTF-8','auto'),
				'issued' => $now,
				'modified' => $now,
				'publisher' => mb_convert_encoding($blog_name,'UTF-8','auto')
	);


	$commentlist =& $blogdata->load('commentlist');
	$commentlist->add($add_comment);
	$commentlist->_save();

	// Entry
	$entry =& $blogdata->load('entry');
	if($entry)
	{
		$entry_data =& $entry->get();
	}else{
		die("Entry data load error");
	}
	$systpl->assign_by_ref('Entry',$entry_data);

	recently_writeback_add($project_cd,$thread_id,null,$url,null,$title,$name_list,$now,$entry_data);

	// ページ更新
//	blog_thread_all_rebuild($project_cd,$thread_id,PUBLOG_SERVER_NAME,LANG);
	blog_thread_target_entry_rebuild($project_cd,$thread_id,$entry_id);

	tb_xml_msg(0,'');
	die;
}
?>
